/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Set Parameter Value", description="Identifies the parameter that will be set by the enclosed value.", name="set-parameter", moduleClass=OscalImplementationCommonModule.class)
public class SetParameter
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Parameter ID", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented) reference to a `parameter` within a control, who's catalog has been imported into the current implementation context.", name="param-id", required=true, typeAdapter=TokenAdapter.class)
    private String _paramId;
    @BoundField(formalName="Parameter Value", description="A parameter value or set of values.", useName="value", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="values", inJson=JsonGroupAsBehavior.LIST))
    private List<String> _values;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public SetParameter() {
        this(null);
    }

    public SetParameter(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getParamId() {
        return this._paramId;
    }

    public void setParamId(String value) {
        this._paramId = value;
    }

    public List<String> getValues() {
        return this._values;
    }

    public void setValues(List<String> value) {
        this._values = value;
    }

    public boolean addValue(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._values == null) {
            this._values = new LinkedList<String>();
        }
        return this._values.add(value);
    }

    public boolean removeValue(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._values != null && this._values.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

