/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.ByComponent;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Specific Control Statement", description="Identifies which statements within a control are addressed.", name="statement", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="responsible-role/@role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset.")})}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-statement-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once."), @IsUnique(id="unique-ssp-implemented-requirement-statement-by-component", level=IConstraint.Level.ERROR, target="by-component", keyFields={@KeyField(target="@component-uuid")}, remarks="Since `by-component` can reference `component` entries using the component's uuid, each component must be referenced only once. This ensures that all implementation statements are contained in the same `by-component` entry.")}))
public class Statement
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Control Statement Reference", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented) identifier reference to a `control statement`.", name="statement-id", required=true, typeAdapter=TokenAdapter.class, remarks="A reference to the specific implemented statement associated with a control.")
    private String _statementId;
    @BoundFlag(formalName="Control Statement Reference Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this control statement elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The *UUID* of the `control statement` in the source OSCAL instance is sufficient to reference the data item locally or globally (e.g., in an imported OSCAL instance).", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundAssembly(formalName="Component Control Implementation", description="Defines how the referenced component implements a set of controls.", useName="by-component", maxOccurs=-1, groupAs=@GroupAs(name="by-components", inJson=JsonGroupAsBehavior.LIST))
    private List<ByComponent> _byComponents;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Statement() {
        this(null);
    }

    public Statement(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getStatementId() {
        return this._statementId;
    }

    public void setStatementId(String value) {
        this._statementId = value;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public List<ByComponent> getByComponents() {
        return this._byComponents;
    }

    public void setByComponents(List<ByComponent> value) {
        this._byComponents = value;
    }

    public boolean addByComponent(ByComponent item) {
        ByComponent value = (ByComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._byComponents == null) {
            this._byComponents = new LinkedList<ByComponent>();
        }
        return this._byComponents.add(value);
    }

    public boolean removeByComponent(ByComponent item) {
        ByComponent value = (ByComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._byComponents != null && this._byComponents.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

