/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.datatype.object.Date;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.AuthorizationBoundary;
import gov.nist.secauto.oscal.lib.model.DataFlow;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.NetworkArchitecture;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import gov.nist.secauto.oscal.lib.model.SecurityImpactLevel;
import gov.nist.secauto.oscal.lib.model.Status;
import gov.nist.secauto.oscal.lib.model.SystemId;
import gov.nist.secauto.oscal.lib.model.SystemInformation;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="System Characteristics", description="Contains the characteristics of the system, such as its name, purpose, and security impact level.", name="system-characteristics", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="identity-assurance-level", description="A value of 1, 2, or 3 as defined by [SP 800-63-3](https://doi.org/10.6028/NIST.SP.800-63-3)."), @AllowedValue(value="authenticator-assurance-level", description="A value of 1, 2, or 3 as defined by [SP 800-63-3](https://doi.org/10.6028/NIST.SP.800-63-3)."), @AllowedValue(value="federation-assurance-level", description="A value of 1, 2, or 3 as defined by [SP 800-63-3](https://doi.org/10.6028/NIST.SP.800-63-3).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[@name=('identity-assurance-level','authenticator-assurance-level','federation-assurance-level')]/@value", values={@AllowedValue(value="1", description="As defined by [SP 800-63-3](https://doi.org/10.6028/NIST.SP.800-63-3)."), @AllowedValue(value="2", description="As defined by [SP 800-63-3](https://doi.org/10.6028/NIST.SP.800-63-3)."), @AllowedValue(value="3", description="As defined by [SP 800-63-3](https://doi.org/10.6028/NIST.SP.800-63-3).")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="cloud-deployment-model", description="The associated value is one of: public-cloud, private-cloud, community-cloud, government-only-cloud, hybrid-cloud, or other."), @AllowedValue(value="cloud-service-model", description="The associated value is one of: saas, paas, iaas, or other.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='cloud-deployment-model']/@value", values={@AllowedValue(value="public-cloud", description="The public cloud deployment model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="private-cloud", description="The private cloud deployment model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="community-cloud", description="The community cloud deployment model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="hybrid-cloud", description="The hybrid cloud deployment model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="government-only-cloud", description="A specific type of community-cloud for use only by government services."), @AllowedValue(value="other", description="Any other type of cloud deployment model that is exclusive to the other choices.")}, remarks="The hybrid cloud deployment model, as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145), can be supported by selecting two or more of the existing deployment models."), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='cloud-service-model']/@value", values={@AllowedValue(value="saas", description="Software as a service (SaaS) cloud service model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="paas", description="Platform as a service (PaaS) cloud service model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="iaas", description="Infrastructure as a service (IaaS) cloud service model as defined by [The NIST Definition of Cloud Computing](https://doi.org/10.6028/NIST.SP.800-145)."), @AllowedValue(value="other", description="Any other type of cloud service model that is exclusive to the other choices.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="responsible-party/@role-id", allowOthers=true, values={@AllowedValue(value="authorizing-official", description="The authorizing official for this system."), @AllowedValue(value="authorizing-official-poc", description="The authorizing official's designated point of contact (POC) for this system."), @AllowedValue(value="system-owner", description="The executive ultimately accountable for the system."), @AllowedValue(value="system-poc-management", description="The primary management-level point of contact (POC) for the system."), @AllowedValue(value="system-poc-technical", description="The primary technical point of contact (POC) for the system."), @AllowedValue(value="system-poc-other", description="Other point of contact (POC) for the system that is not the management or technical POC."), @AllowedValue(value="information-system-security-officer", description="The primary role responsible for ensuring the organization operates the system securely."), @AllowedValue(value="privacy-poc", description="The point of contact (POC) responsible for identifying privacy information within the system, and ensuring its protection if present.")})}), modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-system-characteristics-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
public class SystemCharacteristics
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundField(formalName="System Identification", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this system identification property elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). When referencing an externally defined `system identification`, the `system identification` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference). This string should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same system across revisions of the document.", useName="system-id", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="system-ids", inJson=JsonGroupAsBehavior.LIST))
    private List<SystemId> _systemIds;
    @BoundField(formalName="System Name - Full", description="The full name of the system.", useName="system-name", minOccurs=1)
    private String _systemName;
    @BoundField(formalName="System Name - Short", description="A short name for the system, such as an acronym, that is suitable for display in a data table or summary list.", useName="system-name-short", remarks="Since `system-name-short` is optional, if the `system-name-short` is not provided, the `system-name` can be used as a substitute.")
    private String _systemNameShort;
    @BoundField(formalName="System Description", description="A summary of the system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundField(formalName="System Authorization Date", description="The date the system received its authorization.", useName="date-authorized", typeAdapter=DateAdapter.class)
    private Date _dateAuthorized;
    @BoundField(formalName="Security Sensitivity Level", description="The overall information system sensitivity categorization, such as defined by [FIPS-199](https://doi.org/10.6028/NIST.FIPS.199).", useName="security-sensitivity-level", remarks="Often, organizations require the security sensitivity level to correspond with the highest confidentiality, integrity, or availability level identified by `security-impact-level`.")
    private String _securitySensitivityLevel;
    @BoundAssembly(formalName="System Information", description="Contains details about all information types that are stored, processed, or transmitted by the system, such as privacy information, and those defined in [NIST SP 800-60](https://doi.org/10.6028/NIST.SP.800-60v2r1).", useName="system-information", minOccurs=1)
    private SystemInformation _systemInformation;
    @BoundAssembly(formalName="Security Impact Level", description="The overall level of expected impact resulting from unauthorized disclosure, modification, or loss of access to information.", useName="security-impact-level")
    private SecurityImpactLevel _securityImpactLevel;
    @BoundAssembly(formalName="Status", description="Describes the operational status of the system.", useName="status", minOccurs=1)
    private Status _status;
    @BoundAssembly(formalName="Authorization Boundary", description="A description of this system's authorization boundary, optionally supplemented by diagrams that illustrate the authorization boundary.", useName="authorization-boundary", minOccurs=1)
    private AuthorizationBoundary _authorizationBoundary;
    @BoundAssembly(formalName="Network Architecture", description="A description of the system's network architecture, optionally supplemented by diagrams that illustrate the network architecture.", useName="network-architecture")
    private NetworkArchitecture _networkArchitecture;
    @BoundAssembly(formalName="Data Flow", description="A description of the logical flow of information within the system and across its boundaries, optionally supplemented by diagrams that illustrate these flows.", useName="data-flow")
    private DataFlow _dataFlow;
    @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleParty> _responsibleParties;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public SystemCharacteristics() {
        this(null);
    }

    public SystemCharacteristics(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<SystemId> getSystemIds() {
        return this._systemIds;
    }

    public void setSystemIds(List<SystemId> value) {
        this._systemIds = value;
    }

    public boolean addSystemId(SystemId item) {
        SystemId value = (SystemId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._systemIds == null) {
            this._systemIds = new LinkedList<SystemId>();
        }
        return this._systemIds.add(value);
    }

    public boolean removeSystemId(SystemId item) {
        SystemId value = (SystemId)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._systemIds != null && this._systemIds.remove(value);
    }

    public String getSystemName() {
        return this._systemName;
    }

    public void setSystemName(String value) {
        this._systemName = value;
    }

    public String getSystemNameShort() {
        return this._systemNameShort;
    }

    public void setSystemNameShort(String value) {
        this._systemNameShort = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public Date getDateAuthorized() {
        return this._dateAuthorized;
    }

    public void setDateAuthorized(Date value) {
        this._dateAuthorized = value;
    }

    public String getSecuritySensitivityLevel() {
        return this._securitySensitivityLevel;
    }

    public void setSecuritySensitivityLevel(String value) {
        this._securitySensitivityLevel = value;
    }

    public SystemInformation getSystemInformation() {
        return this._systemInformation;
    }

    public void setSystemInformation(SystemInformation value) {
        this._systemInformation = value;
    }

    public SecurityImpactLevel getSecurityImpactLevel() {
        return this._securityImpactLevel;
    }

    public void setSecurityImpactLevel(SecurityImpactLevel value) {
        this._securityImpactLevel = value;
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status value) {
        this._status = value;
    }

    public AuthorizationBoundary getAuthorizationBoundary() {
        return this._authorizationBoundary;
    }

    public void setAuthorizationBoundary(AuthorizationBoundary value) {
        this._authorizationBoundary = value;
    }

    public NetworkArchitecture getNetworkArchitecture() {
        return this._networkArchitecture;
    }

    public void setNetworkArchitecture(NetworkArchitecture value) {
        this._networkArchitecture = value;
    }

    public DataFlow getDataFlow() {
        return this._dataFlow;
    }

    public void setDataFlow(DataFlow value) {
        this._dataFlow = value;
    }

    public List<ResponsibleParty> getResponsibleParties() {
        return this._responsibleParties;
    }

    public void setResponsibleParties(List<ResponsibleParty> value) {
        this._responsibleParties = value;
    }

    public boolean addResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleParties == null) {
            this._responsibleParties = new LinkedList<ResponsibleParty>();
        }
        return this._responsibleParties.add(value);
    }

    public boolean removeResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleParties != null && this._responsibleParties.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

