/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import java.net.URI;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaField(formalName="System Identification", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this system identification property elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). When referencing an externally defined `system identification`, the `system identification` must be used in the context of the external / imported OSCAL instance (e.g., uri-reference). This string should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same system across revisions of the document.", name="system-id", moduleClass=OscalImplementationCommonModule.class)
public class SystemId
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Identification System Type", description="Identifies the identification system from which the provided identifier was assigned.", name="identifier-type", typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="https://fedramp.gov", description="\\*\\*deprecated\\*\\* The identifier was assigned by FedRAMP. This has been deprecated; use `http://fedramp.gov/ns/oscal` instead.", deprecatedVersion="1.0.3"), @AllowedValue(value="http://fedramp.gov/ns/oscal", description="The identifier was assigned by FedRAMP."), @AllowedValue(value="https://ietf.org/rfc/rfc4122", description="\\*\\*deprecated\\*\\* A Universally Unique Identifier (UUID) as defined by RFC4122. This value has been deprecated; use `http://ietf.org/rfc/rfc4122` instead.", deprecatedVersion="1.0.3"), @AllowedValue(value="http://ietf.org/rfc/rfc4122", description="A Universally Unique Identifier (UUID) as defined by RFC4122.")})}))
    private URI _identifierType;
    @BoundFieldValue(valueKeyName="id")
    private String _id;

    public SystemId() {
        this(null);
    }

    public SystemId(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public URI getIdentifierType() {
        return this._identifierType;
    }

    public void setIdentifierType(URI value) {
        this._identifierType = value;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

