/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.datatype.object.Date;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.InventoryItem;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.SystemComponent;
import gov.nist.secauto.oscal.lib.model.SystemUser;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="System Implementation", description="Provides information as to how the system is implemented.", name="system-implementation", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="(component | inventory-item)/prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='allows-authenticated-scan']/@value", values={@AllowedValue(value="yes", description="The component allows an authenticated scan."), @AllowedValue(value="no", description="The component does not allow an authenticated scan.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="component/prop[@name='leveraged-authorization-uuid']", indexName="index-system-implementation-leveraged-authorization-uuid", keyFields={@KeyField(target="@value")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="component/link[@rel='depends-on']", indexName="index-system-implementation-component-uuid", keyFields={@KeyField(target="@href")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="component/link[@rel='validated-by']", indexName="index-system-implementation-component-uuid-validation", keyFields={@KeyField(target="@href")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="component/link[@rel='proof-of-compliance']", indexName="index-system-implementation-component-uuid-validation", keyFields={@KeyField(target="@href")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="component/link[@rel='uses-service']", indexName="index-system-implementation-component-uuid-service", keyFields={@KeyField(target="@href")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="component[@type='service']/link[@rel='provided-by']", indexName="index-system-implementation-component-uuid-software", keyFields={@KeyField(target="@href")})}), modelConstraints=@AssemblyConstraints(index={@Index(level=IConstraint.Level.ERROR, target="leveraged-authorization", name="index-system-implementation-leveraged-authorization-uuid", keyFields={@KeyField(target="@uuid")}), @Index(level=IConstraint.Level.ERROR, target="component", name="index-system-implementation-component-uuid", keyFields={@KeyField(target="@uuid")}), @Index(level=IConstraint.Level.ERROR, target="component[@type='validation']", name="index-system-implementation-component-uuid-validation", keyFields={@KeyField(target="@uuid")}), @Index(level=IConstraint.Level.ERROR, target="component[@type='service']", name="index-system-implementation-component-uuid-service", keyFields={@KeyField(target="@uuid")}), @Index(level=IConstraint.Level.ERROR, target="component[@type='service']", name="index-system-implementation-component-uuid-software", keyFields={@KeyField(target="@uuid")})}, unique={@IsUnique(id="unique-ssp-system-implementation-user", level=IConstraint.Level.ERROR, target="user", keyFields={@KeyField(target="@uuid")}, remarks="A given `uuid` must be assigned only once to a user.")}))
public class SystemImplementation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Leveraged Authorization", description="A description of another authorized system from which this system inherits capabilities that satisfy security requirements. Another term for this concept is a *common control provider*.", useName="leveraged-authorization", maxOccurs=-1, groupAs=@GroupAs(name="leveraged-authorizations", inJson=JsonGroupAsBehavior.LIST))
    private List<LeveragedAuthorization> _leveragedAuthorizations;
    @BoundAssembly(formalName="System User", description="A type of user that interacts with the system based on an associated role.", useName="user", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="users", inJson=JsonGroupAsBehavior.LIST))
    private List<SystemUser> _users;
    @BoundAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", useName="component", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="components", inJson=JsonGroupAsBehavior.LIST))
    private List<SystemComponent> _components;
    @BoundAssembly(formalName="Inventory Item", description="A single managed inventory item within the system.", useName="inventory-item", remarks="A set of `inventory-item` entries that represent the managed inventory instances of the system.", maxOccurs=-1, groupAs=@GroupAs(name="inventory-items", inJson=JsonGroupAsBehavior.LIST))
    private List<InventoryItem> _inventoryItems;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public SystemImplementation() {
        this(null);
    }

    public SystemImplementation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<LeveragedAuthorization> getLeveragedAuthorizations() {
        return this._leveragedAuthorizations;
    }

    public void setLeveragedAuthorizations(List<LeveragedAuthorization> value) {
        this._leveragedAuthorizations = value;
    }

    public boolean addLeveragedAuthorization(LeveragedAuthorization item) {
        LeveragedAuthorization value = (LeveragedAuthorization)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._leveragedAuthorizations == null) {
            this._leveragedAuthorizations = new LinkedList<LeveragedAuthorization>();
        }
        return this._leveragedAuthorizations.add(value);
    }

    public boolean removeLeveragedAuthorization(LeveragedAuthorization item) {
        LeveragedAuthorization value = (LeveragedAuthorization)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._leveragedAuthorizations != null && this._leveragedAuthorizations.remove(value);
    }

    public List<SystemUser> getUsers() {
        return this._users;
    }

    public void setUsers(List<SystemUser> value) {
        this._users = value;
    }

    public boolean addUser(SystemUser item) {
        SystemUser value = (SystemUser)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._users == null) {
            this._users = new LinkedList<SystemUser>();
        }
        return this._users.add(value);
    }

    public boolean removeUser(SystemUser item) {
        SystemUser value = (SystemUser)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._users != null && this._users.remove(value);
    }

    public List<SystemComponent> getComponents() {
        return this._components;
    }

    public void setComponents(List<SystemComponent> value) {
        this._components = value;
    }

    public boolean addComponent(SystemComponent item) {
        SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._components == null) {
            this._components = new LinkedList<SystemComponent>();
        }
        return this._components.add(value);
    }

    public boolean removeComponent(SystemComponent item) {
        SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._components != null && this._components.remove(value);
    }

    public List<InventoryItem> getInventoryItems() {
        return this._inventoryItems;
    }

    public void setInventoryItems(List<InventoryItem> value) {
        this._inventoryItems = value;
    }

    public boolean addInventoryItem(InventoryItem item) {
        InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._inventoryItems == null) {
            this._inventoryItems = new LinkedList<InventoryItem>();
        }
        return this._inventoryItems.add(value);
    }

    public boolean removeInventoryItem(InventoryItem item) {
        InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._inventoryItems != null && this._inventoryItems.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Leveraged Authorization", description="A description of another authorized system from which this system inherits capabilities that satisfy security requirements. Another term for this concept is a *common control provider*.", name="leveraged-authorization", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="system-security-plan", description="A reference to the system security plan for the leveraged authorization.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="link[@rel='system-security-plan' and starts-with(@href,'#')]", indexName="index-back-matter-resource", keyFields={@KeyField(target="@href", pattern="#(.*)")})}, matches={@Matches(level=IConstraint.Level.ERROR, target="link[@rel='system-security-plan']/@href[starts-with(.,'#')]", typeAdapter=UriReferenceAdapter.class), @Matches(level=IConstraint.Level.ERROR, target="link[@rel='system-security-plan']/@href[not(starts-with(.,'#'))]", typeAdapter=UriAdapter.class)}))
    public static class LeveragedAuthorization
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Leveraged Authorization Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope and can be used to reference this leveraged authorization elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `leveraged authorization` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundField(formalName="title field", description="A human readable name for the leveraged authorization in the context of the system.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundField(formalName="party-uuid field", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to the `party` that manages the leveraged system.", useName="party-uuid", minOccurs=1, typeAdapter=UuidAdapter.class)
        private UUID _partyUuid;
        @BoundField(formalName="System Authorization Date", description="The date the system received its authorization.", useName="date-authorized", minOccurs=1, typeAdapter=DateAdapter.class)
        private Date _dateAuthorized;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public LeveragedAuthorization() {
            this(null);
        }

        public LeveragedAuthorization(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public UUID getPartyUuid() {
            return this._partyUuid;
        }

        public void setPartyUuid(UUID value) {
            this._partyUuid = value;
        }

        public Date getDateAuthorized() {
            return this._dateAuthorized;
        }

        public void setDateAuthorized(Date value) {
            this._dateAuthorized = value;
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

