/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Impact;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="System Information", description="Contains details about all information types that are stored, processed, or transmitted by the system, such as privacy information, and those defined in [NIST SP 800-60](https://doi.org/10.6028/NIST.SP.800-60v2r1).", name="system-information", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="privacy-designation", description="Is this a privacy sensitive system? yes or no")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='privacy-designation']/@value", values={@AllowedValue(value="yes", description="The system is privacy sensitive."), @AllowedValue(value="no", description="The system is not privacy sensitive.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="link/@rel", allowOthers=true, values={@AllowedValue(value="privacy-impact-assessment", description="A link to the privacy impact assessment.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="information-type/(confidentiality-impact|integrity-impact|availability-impact)/(base|selected)", allowOthers=true, values={@AllowedValue(value="fips-199-low", description="A 'low' sensitivity level as defined in [FIPS-199](https://doi.org/10.6028/NIST.FIPS.199)."), @AllowedValue(value="fips-199-moderate", description="A 'moderate' sensitivity level as defined in [FIPS-199](https://doi.org/10.6028/NIST.FIPS.199)."), @AllowedValue(value="fips-199-high", description="A 'high' sensitivity level as defined in [FIPS-199](https://doi.org/10.6028/NIST.FIPS.199).")}, remarks="FIPS-199 taxonomy is provided here as a starting point. We will provide other taxonomies based on community requests.")}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="link[@rel='privacy-impact-assessment' and starts-with(@href,'#')]", indexName="index-back-matter-resource", keyFields={@KeyField(target="@href", pattern="#(.*)")})}, matches={@Matches(level=IConstraint.Level.ERROR, target="link[@rel='privacy-impact-assessment']/@href[starts-with(.,'#')]", typeAdapter=UriReferenceAdapter.class), @Matches(level=IConstraint.Level.ERROR, target="link[@rel='privacy-impact-assessment']/@href[not(starts-with(.,'#'))]", typeAdapter=UriAdapter.class)}))
public class SystemInformation
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Information Type", description="Contains details about one information type that is stored, processed, or transmitted by the system, such as privacy information, and those defined in [NIST SP 800-60](https://doi.org/10.6028/NIST.SP.800-60v2r1).", useName="information-type", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="information-types", inJson=JsonGroupAsBehavior.LIST))
    private List<InformationType> _informationTypes;

    public SystemInformation() {
        this(null);
    }

    public SystemInformation(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<InformationType> getInformationTypes() {
        return this._informationTypes;
    }

    public void setInformationTypes(List<InformationType> value) {
        this._informationTypes = value;
    }

    public boolean addInformationType(InformationType item) {
        InformationType value = (InformationType)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._informationTypes == null) {
            this._informationTypes = new LinkedList<InformationType>();
        }
        return this._informationTypes.add(value);
    }

    public boolean removeInformationType(InformationType item) {
        InformationType value = (InformationType)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._informationTypes != null && this._informationTypes.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Information Type", description="Contains details about one information type that is stored, processed, or transmitted by the system, such as privacy information, and those defined in [NIST SP 800-60](https://doi.org/10.6028/NIST.SP.800-60v2r1).", name="information-type", moduleClass=OscalSspModule.class, valueConstraints=@ValueConstraints(expect={@Expect(level=IConstraint.Level.WARNING, test="@uuid", message="It is a best practice to provide a UUID.")}))
    public static class InformationType
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Information Type Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this information type elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `information type` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundField(formalName="title field", description="A human readable name for the information type. This title should be meaningful within the context of the system.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundField(formalName="Information Type Description", description="A summary of how this information type is used within the system.", useName="description", minOccurs=1, typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _description;
        @BoundAssembly(formalName="Information Type Categorization", description="A set of information type identifiers qualified by the given identification `system` used, such as NIST SP 800-60.", useName="categorization", maxOccurs=-1, groupAs=@GroupAs(name="categorizations", inJson=JsonGroupAsBehavior.LIST))
        private List<Categorization> _categorizations;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Confidentiality Impact Level", description="The expected level of impact resulting from the unauthorized disclosure of the described information.", useName="confidentiality-impact")
        private Impact _confidentialityImpact;
        @BoundAssembly(formalName="Integrity Impact Level", description="The expected level of impact resulting from the unauthorized modification of the described information.", useName="integrity-impact")
        private Impact _integrityImpact;
        @BoundAssembly(formalName="Availability Impact Level", description="The expected level of impact resulting from the disruption of access to or use of the described information or the information system.", useName="availability-impact")
        private Impact _availabilityImpact;

        public InformationType() {
            this(null);
        }

        public InformationType(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public MarkupMultiline getDescription() {
            return this._description;
        }

        public void setDescription(MarkupMultiline value) {
            this._description = value;
        }

        public List<Categorization> getCategorizations() {
            return this._categorizations;
        }

        public void setCategorizations(List<Categorization> value) {
            this._categorizations = value;
        }

        public boolean addCategorization(Categorization item) {
            Categorization value = (Categorization)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._categorizations == null) {
                this._categorizations = new LinkedList<Categorization>();
            }
            return this._categorizations.add(value);
        }

        public boolean removeCategorization(Categorization item) {
            Categorization value = (Categorization)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._categorizations != null && this._categorizations.remove(value);
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public Impact getConfidentialityImpact() {
            return this._confidentialityImpact;
        }

        public void setConfidentialityImpact(Impact value) {
            this._confidentialityImpact = value;
        }

        public Impact getIntegrityImpact() {
            return this._integrityImpact;
        }

        public void setIntegrityImpact(Impact value) {
            this._integrityImpact = value;
        }

        public Impact getAvailabilityImpact() {
            return this._availabilityImpact;
        }

        public void setAvailabilityImpact(Impact value) {
            this._availabilityImpact = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Information Type Categorization", description="A set of information type identifiers qualified by the given identification `system` used, such as NIST SP 800-60.", name="categorization", moduleClass=OscalSspModule.class)
        public static class Categorization
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Information Type Identification System", description="Specifies the information type identification system used.", name="system", required=true, typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="http://doi.org/10.6028/NIST.SP.800-60v2r1", description="Based on the section identifiers in NIST [Special Publication 800-60 Volume II Revision 1](https://doi.org/10.6028/NIST.SP.800-60v2r1).")})}))
            private URI _system;
            @BoundField(formalName="Information Type Systematized Identifier", description="A [human-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#human-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier qualified by the given identification `system` used, such as NIST SP 800-60. This identifier has [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope and can be used to reference this system elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). This id should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", useName="information-type-id", maxOccurs=-1, groupAs=@GroupAs(name="information-type-ids", inJson=JsonGroupAsBehavior.LIST))
            private List<String> _informationTypeIds;

            public Categorization() {
                this(null);
            }

            public Categorization(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public URI getSystem() {
                return this._system;
            }

            public void setSystem(URI value) {
                this._system = value;
            }

            public List<String> getInformationTypeIds() {
                return this._informationTypeIds;
            }

            public void setInformationTypeIds(List<String> value) {
                this._informationTypeIds = value;
            }

            public boolean addInformationTypeId(String item) {
                String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._informationTypeIds == null) {
                    this._informationTypeIds = new LinkedList<String>();
                }
                return this._informationTypeIds.add(value);
            }

            public boolean removeInformationTypeId(String item) {
                String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._informationTypeIds != null && this._informationTypeIds.remove(value);
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }
}

