/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.AbstractOscalInstance;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.ControlImplementation;
import gov.nist.secauto.oscal.lib.model.ImportProfile;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.OscalSspModule;
import gov.nist.secauto.oscal.lib.model.SystemCharacteristics;
import gov.nist.secauto.oscal.lib.model.SystemImplementation;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="System Security Plan (SSP)", description="A system security plan, such as those described in NIST SP 800-18.", name="system-security-plan", moduleClass=OscalSspModule.class, rootName="system-security-plan", modelConstraints=@AssemblyConstraints(index={@Index(level=IConstraint.Level.ERROR, target="control-implementation/implemented-requirement//by-component|doc(system-implementation/leveraged-authorization/link[@rel='system-security-plan']/@href)/system-security-plan/control-implementation/implemented-requirement//by-component", name="by-component-uuid", keyFields={@KeyField(target="@uuid")})}))
public class SystemSecurityPlan
extends AbstractOscalInstance
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="System Security Plan Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this system security plan (SSP) elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ssp-identifiers). The locally defined *UUID* of the `SSP` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance).This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Import Profile", description="Used to import the OSCAL profile representing the system's control baseline.", useName="import-profile", minOccurs=1)
    private ImportProfile _importProfile;
    @BoundAssembly(formalName="System Characteristics", description="Contains the characteristics of the system, such as its name, purpose, and security impact level.", useName="system-characteristics", minOccurs=1)
    private SystemCharacteristics _systemCharacteristics;
    @BoundAssembly(formalName="System Implementation", description="Provides information as to how the system is implemented.", useName="system-implementation", minOccurs=1)
    private SystemImplementation _systemImplementation;
    @BoundAssembly(formalName="Control Implementation", description="Describes how the system satisfies a set of controls.", useName="control-implementation", minOccurs=1)
    private ControlImplementation _controlImplementation;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter")
    private BackMatter _backMatter;

    public SystemSecurityPlan() {
        this(null);
    }

    public SystemSecurityPlan(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    @Override
    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    public ImportProfile getImportProfile() {
        return this._importProfile;
    }

    public void setImportProfile(ImportProfile value) {
        this._importProfile = value;
    }

    public SystemCharacteristics getSystemCharacteristics() {
        return this._systemCharacteristics;
    }

    public void setSystemCharacteristics(SystemCharacteristics value) {
        this._systemCharacteristics = value;
    }

    public SystemImplementation getSystemImplementation() {
        return this._systemImplementation;
    }

    public void setSystemImplementation(SystemImplementation value) {
        this._systemImplementation = value;
    }

    public ControlImplementation getControlImplementation() {
        return this._controlImplementation;
    }

    public void setControlImplementation(ControlImplementation value) {
        this._controlImplementation = value;
    }

    @Override
    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

