/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.AuthorizedPrivilege;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalImplementationCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="System User", description="A type of user that interacts with the system based on an associated role.", name="system-user", moduleClass=OscalImplementationCommonModule.class, remarks="Permissible values to be determined closer to the application, such as by a receiving authority.", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="type", description="The type of user, such as internal, external, or general-public."), @AllowedValue(value="privilege-level", description="The user's privilege level within the system, such as privileged, non-privileged, no-logical-access.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='type']/@value", values={@AllowedValue(value="internal", description="A user account for a person or entity that is part of the organization who owns or operates the system."), @AllowedValue(value="external", description="A user account for a person or entity that is not part of the organization who owns or operates the system."), @AllowedValue(value="general-public", description="A user of the system considered to be outside")}), @AllowedValues(level=IConstraint.Level.ERROR, target="prop[has-oscal-namespace('http://csrc.nist.gov/ns/oscal') and @name='privilege-level']/@value", values={@AllowedValue(value="privileged", description="This role has elevated access to the system, such as a group or system administrator."), @AllowedValue(value="non-privileged", description="This role has typical user-level access to the system without elevated access."), @AllowedValue(value="no-logical-access", description="This role has no access to the system, such as a manager who approves access as part of a process.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="role-id", allowOthers=true, values={@AllowedValue(value="asset-owner", description="Accountable for ensuring the asset is managed in accordance with organizational policies and procedures."), @AllowedValue(value="asset-administrator", description="Responsible for administering a set of assets."), @AllowedValue(value="security-operations", description="Members of the security operations center (SOC)."), @AllowedValue(value="network-operations", description="Members of the network operations center (NOC)."), @AllowedValue(value="incident-response", description="Responsible for responding to an event that could lead to loss of, or disruption to, an organization's operations, services or functions."), @AllowedValue(value="help-desk", description="Responsible for providing information and support to users."), @AllowedValue(value="configuration-management", description="Responsible for the configuration management processes governing changes to the asset.")})}))
public class SystemUser
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="User Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this user class elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `system user` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundField(formalName="User Title", description="A name given to the user, which may be used by a tool for display and navigation.", useName="title", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="User Short Name", description="A short common name, abbreviation, or acronym for the user.", useName="short-name")
    private String _shortName;
    @BoundField(formalName="User Description", description="A summary of the user's purpose within the system.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundField(formalName="Role Identifier Reference", description="Reference to a role by UUID.", useName="role-id", maxOccurs=-1, groupAs=@GroupAs(name="role-ids", inJson=JsonGroupAsBehavior.LIST), typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, indexName="index-metadata-role-id", keyFields={@KeyField})}))
    private List<String> _roleIds;
    @BoundAssembly(formalName="Privilege", description="Identifies a specific system privilege held by the user, along with an associated description and/or rationale for the privilege.", useName="authorized-privilege", maxOccurs=-1, groupAs=@GroupAs(name="authorized-privileges", inJson=JsonGroupAsBehavior.LIST))
    private List<AuthorizedPrivilege> _authorizedPrivileges;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public SystemUser() {
        this(null);
    }

    public SystemUser(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public String getShortName() {
        return this._shortName;
    }

    public void setShortName(String value) {
        this._shortName = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<String> getRoleIds() {
        return this._roleIds;
    }

    public void setRoleIds(List<String> value) {
        this._roleIds = value;
    }

    public boolean addRoleId(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._roleIds == null) {
            this._roleIds = new LinkedList<String>();
        }
        return this._roleIds.add(value);
    }

    public boolean removeRoleId(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._roleIds != null && this._roleIds.remove(value);
    }

    public List<AuthorizedPrivilege> getAuthorizedPrivileges() {
        return this._authorizedPrivileges;
    }

    public void setAuthorizedPrivileges(List<AuthorizedPrivilege> value) {
        this._authorizedPrivileges = value;
    }

    public boolean addAuthorizedPrivilege(AuthorizedPrivilege item) {
        AuthorizedPrivilege value = (AuthorizedPrivilege)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._authorizedPrivileges == null) {
            this._authorizedPrivileges = new LinkedList<AuthorizedPrivilege>();
        }
        return this._authorizedPrivileges.add(value);
    }

    public boolean removeAuthorizedPrivilege(AuthorizedPrivilege item) {
        AuthorizedPrivilege value = (AuthorizedPrivilege)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._authorizedPrivileges != null && this._authorizedPrivileges.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

