/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.PositiveIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.AssessmentSubject;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleRole;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Task", description="Represents a scheduled event or milestone, which may be associated with a series of assessment actions.", name="task", moduleClass=OscalAssessmentCommonModule.class)
public class Task
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Task Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this task elsewhere in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope). The locally defined *UUID* of the `task` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Task Type", description="The type of task.", name="type", required=true, typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="milestone", description="The task represents a planned milestone."), @AllowedValue(value="action", description="The task represents a specific assessment action to be performed.")})}))
    private String _type;
    @BoundField(formalName="Task Title", description="The title for this task.", useName="title", minOccurs=1, typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _title;
    @BoundField(formalName="Task Description", description="A human-readable description of this task.", useName="description", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _description;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Event Timing", description="The timing under which the task is intended to occur.", useName="timing")
    private Timing _timing;
    @BoundAssembly(formalName="Task Dependency", description="Used to indicate that a task is dependent on another task.", useName="dependency", maxOccurs=-1, groupAs=@GroupAs(name="dependencies", inJson=JsonGroupAsBehavior.LIST))
    private List<Dependency> _dependencies;
    @BoundAssembly(formalName="Task", description="Represents a scheduled event or milestone, which may be associated with a series of assessment actions.", useName="task", maxOccurs=-1, groupAs=@GroupAs(name="tasks", inJson=JsonGroupAsBehavior.LIST))
    private List<Task> _tasks;
    @BoundAssembly(formalName="Associated Activity", description="Identifies an individual activity to be performed as part of a task.", useName="associated-activity", maxOccurs=-1, groupAs=@GroupAs(name="associated-activities", inJson=JsonGroupAsBehavior.LIST))
    private List<AssociatedActivity> _associatedActivities;
    @BoundAssembly(formalName="Subject of Assessment", description="Identifies system elements being assessed, such as components, inventory items, and locations. In the assessment plan, this identifies a planned assessment subject. In the assessment results this is an actual assessment subject, and reflects any changes from the plan. exactly what will be the focus of this assessment. Any subjects not identified in this way are out-of-scope.", useName="subject", remarks="The assessment subjects that the activity was performed against.", maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
    private List<AssessmentSubject> _subjects;
    @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", remarks="Identifies the person or organization responsible for performing a specific role related to the task.", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleRole> _responsibleRoles;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Task() {
        this(null);
    }

    public Task(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public MarkupLine getTitle() {
        return this._title;
    }

    public void setTitle(MarkupLine value) {
        this._title = value;
    }

    public MarkupMultiline getDescription() {
        return this._description;
    }

    public void setDescription(MarkupMultiline value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public Timing getTiming() {
        return this._timing;
    }

    public void setTiming(Timing value) {
        this._timing = value;
    }

    public List<Dependency> getDependencies() {
        return this._dependencies;
    }

    public void setDependencies(List<Dependency> value) {
        this._dependencies = value;
    }

    public boolean addDependency(Dependency item) {
        Dependency value = (Dependency)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._dependencies == null) {
            this._dependencies = new LinkedList<Dependency>();
        }
        return this._dependencies.add(value);
    }

    public boolean removeDependency(Dependency item) {
        Dependency value = (Dependency)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._dependencies != null && this._dependencies.remove(value);
    }

    public List<Task> getTasks() {
        return this._tasks;
    }

    public void setTasks(List<Task> value) {
        this._tasks = value;
    }

    public boolean addTask(Task item) {
        Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._tasks == null) {
            this._tasks = new LinkedList<Task>();
        }
        return this._tasks.add(value);
    }

    public boolean removeTask(Task item) {
        Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._tasks != null && this._tasks.remove(value);
    }

    public List<AssociatedActivity> getAssociatedActivities() {
        return this._associatedActivities;
    }

    public void setAssociatedActivities(List<AssociatedActivity> value) {
        this._associatedActivities = value;
    }

    public boolean addAssociatedActivity(AssociatedActivity item) {
        AssociatedActivity value = (AssociatedActivity)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._associatedActivities == null) {
            this._associatedActivities = new LinkedList<AssociatedActivity>();
        }
        return this._associatedActivities.add(value);
    }

    public boolean removeAssociatedActivity(AssociatedActivity item) {
        AssociatedActivity value = (AssociatedActivity)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._associatedActivities != null && this._associatedActivities.remove(value);
    }

    public List<AssessmentSubject> getSubjects() {
        return this._subjects;
    }

    public void setSubjects(List<AssessmentSubject> value) {
        this._subjects = value;
    }

    public boolean addSubject(AssessmentSubject item) {
        AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._subjects == null) {
            this._subjects = new LinkedList<AssessmentSubject>();
        }
        return this._subjects.add(value);
    }

    public boolean removeSubject(AssessmentSubject item) {
        AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._subjects != null && this._subjects.remove(value);
    }

    public List<ResponsibleRole> getResponsibleRoles() {
        return this._responsibleRoles;
    }

    public void setResponsibleRoles(List<ResponsibleRole> value) {
        this._responsibleRoles = value;
    }

    public boolean addResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleRoles == null) {
            this._responsibleRoles = new LinkedList<ResponsibleRole>();
        }
        return this._responsibleRoles.add(value);
    }

    public boolean removeResponsibleRole(ResponsibleRole item) {
        ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleRoles != null && this._responsibleRoles.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Event Timing", description="The timing under which the task is intended to occur.", name="timing", moduleClass=OscalAssessmentCommonModule.class)
    public static class Timing
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="On Date Condition", description="The task is intended to occur on the specified date.", useName="on-date", minOccurs=1)
        private OnDate _onDate;
        @BoundAssembly(formalName="On Date Range Condition", description="The task is intended to occur within the specified date range.", useName="within-date-range", minOccurs=1)
        private WithinDateRange _withinDateRange;
        @BoundAssembly(formalName="Frequency Condition", description="The task is intended to occur at the specified frequency.", useName="at-frequency", minOccurs=1)
        private AtFrequency _atFrequency;

        public Timing() {
            this(null);
        }

        public Timing(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public OnDate getOnDate() {
            return this._onDate;
        }

        public void setOnDate(OnDate value) {
            this._onDate = value;
        }

        public WithinDateRange getWithinDateRange() {
            return this._withinDateRange;
        }

        public void setWithinDateRange(WithinDateRange value) {
            this._withinDateRange = value;
        }

        public AtFrequency getAtFrequency() {
            return this._atFrequency;
        }

        public void setAtFrequency(AtFrequency value) {
            this._atFrequency = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="On Date Condition", description="The task is intended to occur on the specified date.", name="on-date", moduleClass=OscalAssessmentCommonModule.class)
        public static class OnDate
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="On Date Condition", description="The task must occur on the specified date.", name="date", required=true, typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _date;

            public OnDate() {
                this(null);
            }

            public OnDate(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public ZonedDateTime getDate() {
                return this._date;
            }

            public void setDate(ZonedDateTime value) {
                this._date = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }

        @MetaschemaAssembly(formalName="On Date Range Condition", description="The task is intended to occur within the specified date range.", name="within-date-range", moduleClass=OscalAssessmentCommonModule.class)
        public static class WithinDateRange
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Start Date Condition", description="The task must occur on or after the specified date.", name="start", required=true, typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _start;
            @BoundFlag(formalName="End Date Condition", description="The task must occur on or before the specified date.", name="end", required=true, typeAdapter=DateTimeWithTZAdapter.class)
            private ZonedDateTime _end;

            public WithinDateRange() {
                this(null);
            }

            public WithinDateRange(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public ZonedDateTime getStart() {
                return this._start;
            }

            public void setStart(ZonedDateTime value) {
                this._start = value;
            }

            public ZonedDateTime getEnd() {
                return this._end;
            }

            public void setEnd(ZonedDateTime value) {
                this._end = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }

        @MetaschemaAssembly(formalName="Frequency Condition", description="The task is intended to occur at the specified frequency.", name="at-frequency", moduleClass=OscalAssessmentCommonModule.class)
        public static class AtFrequency
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Period", description="The task must occur after the specified period has elapsed.", name="period", required=true, typeAdapter=PositiveIntegerAdapter.class)
            private BigInteger _period;
            @BoundFlag(formalName="Time Unit", description="The unit of time for the period.", name="unit", required=true, typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="seconds", description="The period is specified in seconds."), @AllowedValue(value="minutes", description="The period is specified in minutes."), @AllowedValue(value="hours", description="The period is specified in hours."), @AllowedValue(value="days", description="The period is specified in days."), @AllowedValue(value="months", description="The period is specified in calendar months."), @AllowedValue(value="years", description="The period is specified in calendar years.")})}))
            private String _unit;

            public AtFrequency() {
                this(null);
            }

            public AtFrequency(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public BigInteger getPeriod() {
                return this._period;
            }

            public void setPeriod(BigInteger value) {
                this._period = value;
            }

            public String getUnit() {
                return this._unit;
            }

            public void setUnit(String value) {
                this._unit = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }

    @MetaschemaAssembly(formalName="Task Dependency", description="Used to indicate that a task is dependent on another task.", name="dependency", moduleClass=OscalAssessmentCommonModule.class)
    public static class Dependency
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Task Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a unique task.", name="task-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _taskUuid;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public Dependency() {
            this(null);
        }

        public Dependency(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getTaskUuid() {
            return this._taskUuid;
        }

        public void setTaskUuid(UUID value) {
            this._taskUuid = value;
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Associated Activity", description="Identifies an individual activity to be performed as part of a task.", name="associated-activity", moduleClass=OscalAssessmentCommonModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-associated-activity-responsible-role", level=IConstraint.Level.ERROR, target="responsible-role", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-role` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
    public static class AssociatedActivity
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Activity Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to an activity defined in the list of activities.", name="activity-uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _activityUuid;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Responsible Role", description="A reference to a role with responsibility for performing a function relative to the containing object, optionally associated with a set of persons and/or organizations that perform that role.", useName="responsible-role", remarks="Identifies the person or organization responsible for performing a specific role defined by the activity.", maxOccurs=-1, groupAs=@GroupAs(name="responsible-roles", inJson=JsonGroupAsBehavior.LIST))
        private List<ResponsibleRole> _responsibleRoles;
        @BoundAssembly(formalName="Subject of Assessment", description="Identifies system elements being assessed, such as components, inventory items, and locations. In the assessment plan, this identifies a planned assessment subject. In the assessment results this is an actual assessment subject, and reflects any changes from the plan. exactly what will be the focus of this assessment. Any subjects not identified in this way are out-of-scope.", useName="subject", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="subjects", inJson=JsonGroupAsBehavior.LIST))
        private List<AssessmentSubject> _subjects;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public AssociatedActivity() {
            this(null);
        }

        public AssociatedActivity(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getActivityUuid() {
            return this._activityUuid;
        }

        public void setActivityUuid(UUID value) {
            this._activityUuid = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<ResponsibleRole> getResponsibleRoles() {
            return this._responsibleRoles;
        }

        public void setResponsibleRoles(List<ResponsibleRole> value) {
            this._responsibleRoles = value;
        }

        public boolean addResponsibleRole(ResponsibleRole item) {
            ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._responsibleRoles == null) {
                this._responsibleRoles = new LinkedList<ResponsibleRole>();
            }
            return this._responsibleRoles.add(value);
        }

        public boolean removeResponsibleRole(ResponsibleRole item) {
            ResponsibleRole value = (ResponsibleRole)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._responsibleRoles != null && this._responsibleRoles.remove(value);
        }

        public List<AssessmentSubject> getSubjects() {
            return this._subjects;
        }

        public void setSubjects(List<AssessmentSubject> value) {
            this._subjects = value;
        }

        public boolean addSubject(AssessmentSubject item) {
            AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._subjects == null) {
                this._subjects = new LinkedList<AssessmentSubject>();
            }
            return this._subjects.add(value);
        }

        public boolean removeSubject(AssessmentSubject item) {
            AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._subjects != null && this._subjects.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

