/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaField(formalName="Telephone Number", description="A telephone service number as defined by [ITU-T E.164](https://www.itu.int/rec/T-REC-E.164-201011-I/en).", name="telephone-number", moduleClass=OscalMetadataModule.class, valueConstraints=@ValueConstraints(matches={@Matches(level=IConstraint.Level.WARNING, pattern="^[0-9]{3}[0-9]{1,12}$", remarks="Providing a country code provides an international means to interpret the phone number.")}))
public class TelephoneNumber
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="type flag", description="Indicates the type of phone number.", name="type", typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="home", description="A home phone number."), @AllowedValue(value="office", description="An office phone number."), @AllowedValue(value="mobile", description="A mobile phone number.")})}))
    private String _type;
    @BoundFieldValue(valueKeyName="number")
    private String _number;

    public TelephoneNumber() {
        this(null);
    }

    public TelephoneNumber(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public String getNumber() {
        return this._number;
    }

    public void setNumber(String value) {
        this._number = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

