/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import java.net.URI;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaField(formalName="Threat ID", description="A pointer, by ID, to an externally-defined threat.", name="threat-id", moduleClass=OscalAssessmentCommonModule.class)
public class ThreatId
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Threat Type Identification System", description="Specifies the source of the threat information.", name="system", required=true, typeAdapter=UriAdapter.class, remarks="This value must be an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that serves as a [naming system identifier](https://pages.nist.gov/OSCAL/concepts/uri-use/#use-as-a-naming-system-identifier).", valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="http://fedramp.gov", description="\\*\\*deprecated\\*\\* The value conforms to FedRAMP definitions. This value has been deprecated; use `http://fedramp.gov/ns/oscal` instead.", deprecatedVersion="1.0.3"), @AllowedValue(value="http://fedramp.gov/ns/oscal", description="The value conforms to FedRAMP definitions.")})}))
    private URI _system;
    @BoundFlag(formalName="Threat Information Resource Reference", description="An optional location for the threat data, from which this ID originates.", name="href", typeAdapter=UriReferenceAdapter.class, remarks="This value may be one of:\n\n1. an [absolute URI](https://pages.nist.gov/OSCAL/concepts/uri-use/#absolute-uri) that points to a network resolvable resource,\n2. a [relative reference](https://pages.nist.gov/OSCAL/concepts/uri-use/#relative-reference) pointing to a network resolvable resource whose base URI is the URI of the containing document, or\n3. a bare URI fragment (i.e., \\`#uuid\\`) pointing to a `back-matter` resource in this or an imported document (see [linking to another OSCAL object](https://pages.nist.gov/OSCAL/concepts/uri-use/#linking-to-another-oscal-object)).")
    private URI _href;
    @BoundFieldValue(valueKeyName="id", typeAdapter=UriAdapter.class)
    private URI _id;

    public ThreatId() {
        this(null);
    }

    public ThreatId(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public URI getSystem() {
        return this._system;
    }

    public void setSystem(URI value) {
        this._system = value;
    }

    public URI getHref() {
        return this._href;
    }

    public void setHref(URI value) {
        this._href = value;
    }

    public URI getId() {
        return this._id;
    }

    public void setId(URI value) {
        this._id = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

