/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.control;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.ParameterConstraint;
import gov.nist.secauto.oscal.lib.model.ParameterGuideline;
import gov.nist.secauto.oscal.lib.model.ParameterSelection;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.IParameter;
import gov.nist.secauto.oscal.lib.model.metadata.IProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AbstractParameter
implements IParameter {
    @Override
    public Stream<String> getParameterReferences() {
        Stream<String> aggregatesIds = CollectionUtil.listOrEmpty(this.getProps()).stream().filter(Objects::nonNull).filter(prop -> prop.isNamespaceEqual(IProperty.OSCAL_NAMESPACE) && "aggregates".equals(prop.getName())).map(Property::getValue);
        ParameterSelection selection = this.getSelect();
        Stream<Object> selectInsertIds = selection == null ? Stream.empty() : CollectionUtil.listOrEmpty(selection.getChoice()).stream().filter(Objects::nonNull).flatMap(choice -> choice.getInserts(insert -> "param".equals(insert.getType().toString())).stream().map(insert -> insert.getIdReference().toString()));
        Stream<String> retval = Stream.concat(aggregatesIds, selectInsertIds).filter(Objects::nonNull).distinct();
        assert (retval != null);
        return retval;
    }

    @NonNull
    public static Builder builder(@NonNull String id) {
        return new Builder(id);
    }

    public static class Builder {
        @NonNull
        private final String id;
        private String clazz;
        private final List<Property> props = new LinkedList<Property>();
        private final List<Link> links = new LinkedList<Link>();
        private MarkupLine label;
        private MarkupMultiline usage;
        private final List<ParameterConstraint> constraints = new LinkedList<ParameterConstraint>();
        private final List<ParameterGuideline> guidelines = new LinkedList<ParameterGuideline>();
        private List<String> values = new LinkedList<String>();
        private ParameterSelection selection;
        private MarkupMultiline remarks;

        public Builder(@NonNull String id) {
            this.id = (String)ObjectUtils.requireNonNull((Object)id);
        }

        @NonNull
        public Builder clazz(@NonNull String value) {
            this.clazz = (String)ObjectUtils.requireNonNull((Object)value);
            return this;
        }

        @NonNull
        public Builder prop(@NonNull Property value) {
            this.props.add((Property)ObjectUtils.requireNonNull((Object)value));
            return this;
        }

        @NonNull
        public Builder link(@NonNull Link value) {
            this.links.add((Link)ObjectUtils.requireNonNull((Object)value));
            return this;
        }

        @NonNull
        public Builder label(@NonNull String markdown) {
            return this.label(MarkupLine.fromMarkdown((String)Objects.requireNonNull(markdown)));
        }

        @NonNull
        public Builder label(@NonNull MarkupLine value) {
            this.label = (MarkupLine)ObjectUtils.requireNonNull((Object)value);
            return this;
        }

        @NonNull
        public Builder usage(@NonNull String markdown) {
            return this.usage(MarkupMultiline.fromMarkdown((String)((String)ObjectUtils.requireNonNull((Object)markdown))));
        }

        @NonNull
        public Builder usage(@NonNull MarkupMultiline value) {
            this.usage = (MarkupMultiline)ObjectUtils.requireNonNull((Object)value);
            return this;
        }

        @NonNull
        public Builder constraint(@NonNull ParameterConstraint value) {
            this.constraints.add((ParameterConstraint)ObjectUtils.requireNonNull((Object)value));
            return this;
        }

        @NonNull
        public Builder guideline(@NonNull ParameterGuideline value) {
            this.guidelines.add((ParameterGuideline)ObjectUtils.requireNonNull((Object)value));
            return this;
        }

        @NonNull
        public Builder values(String ... values) {
            return this.values(Arrays.asList(values));
        }

        @NonNull
        public Builder values(@NonNull Collection<String> values) {
            this.values = new ArrayList<String>(values);
            return this;
        }

        @NonNull
        public Builder select(@NonNull ParameterSelection value) {
            this.selection = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder remarks(@NonNull MarkupMultiline value) {
            this.remarks = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Parameter build() {
            Parameter retval = new Parameter();
            retval.setId(this.id);
            if (this.clazz != null) {
                retval.setClazz(this.clazz);
            }
            if (!this.props.isEmpty()) {
                retval.setProps(this.props);
            }
            if (!this.links.isEmpty()) {
                retval.setLinks(this.links);
            }
            if (this.label != null) {
                retval.setLabel(this.label);
            }
            if (this.usage != null) {
                retval.setUsage(this.usage);
            }
            if (!this.constraints.isEmpty()) {
                retval.setConstraints(this.constraints);
            }
            if (!this.guidelines.isEmpty()) {
                retval.setGuidelines(this.guidelines);
            }
            if (!this.values.isEmpty()) {
                retval.setValues(this.values);
            }
            if (this.selection != null) {
                retval.setSelect(this.selection);
            }
            if (this.remarks != null) {
                retval.setRemarks(this.remarks);
            }
            return retval;
        }
    }
}

