/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.control;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.flexmark.InsertAnchorExtension;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.IPart;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractPart
implements IPart {
    @Override
    @NonNull
    public Stream<InsertAnchorExtension.InsertAnchorNode> getInserts(@NonNull Predicate<InsertAnchorExtension.InsertAnchorNode> filter) {
        Stream retval;
        MarkupMultiline prose = this.getProse();
        if (prose == null) {
            retval = (Stream)ObjectUtils.notNull(Stream.empty());
        } else {
            List result = prose.getInserts(filter);
            retval = (Stream)ObjectUtils.notNull(result.stream());
        }
        return retval;
    }

    public Stream<IPart> getPartsRecursively() {
        return Stream.concat(Stream.of(this), CollectionUtil.listOrEmpty(this.getParts()).stream().flatMap(AbstractPart::getPartsRecursively));
    }

    @NonNull
    public static Builder builder(@NonNull String name) {
        return new Builder(name);
    }

    public static class Builder {
        private String id;
        @NonNull
        private final String name;
        private URI namespace;
        private String clazz;
        private MarkupMultiline prose;
        private MarkupLine title;
        private final List<Property> props = new LinkedList<Property>();
        private final List<Link> links = new LinkedList<Link>();
        private final List<ControlPart> parts = new LinkedList<ControlPart>();

        public Builder(@NonNull String name) {
            this.name = Objects.requireNonNull(name);
        }

        @NonNull
        public Builder id(@NonNull String value) {
            this.id = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder namespace(@NonNull URI value) {
            this.namespace = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder clazz(@NonNull String value) {
            this.clazz = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder title(@NonNull String markdown) {
            return this.title(MarkupLine.fromMarkdown((String)Objects.requireNonNull(markdown)));
        }

        @NonNull
        public Builder title(@NonNull MarkupLine value) {
            this.title = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder prose(@NonNull String markdown) {
            return this.prose(MarkupMultiline.fromMarkdown((String)Objects.requireNonNull(markdown)));
        }

        @NonNull
        public Builder prose(@NonNull MarkupMultiline value) {
            this.prose = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder prop(@NonNull Property value) {
            this.props.add(Objects.requireNonNull(value));
            return this;
        }

        @NonNull
        public Builder link(@NonNull Link value) {
            this.links.add(Objects.requireNonNull(value));
            return this;
        }

        @NonNull
        public Builder part(@NonNull ControlPart value) {
            this.parts.add(Objects.requireNonNull(value));
            return this;
        }

        @NonNull
        public ControlPart build() {
            ControlPart retval = new ControlPart();
            retval.setName(this.name);
            if (this.id != null) {
                retval.setId(this.id);
            }
            if (this.namespace != null) {
                retval.setNs(this.namespace);
            }
            if (this.clazz != null) {
                retval.setClazz(this.clazz);
            }
            if (this.prose != null) {
                retval.setProse(this.prose);
            }
            if (this.title != null) {
                retval.setTitle(this.title);
            }
            if (!this.props.isEmpty()) {
                retval.setProps(this.props);
            }
            if (!this.links.isEmpty()) {
                retval.setLinks(this.links);
            }
            if (!this.parts.isEmpty()) {
                retval.setParts(this.parts);
            }
            return retval;
        }
    }
}

