/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.control.catalog;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.AbstractParameter;
import gov.nist.secauto.oscal.lib.model.control.catalog.ICatalogGroup;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AbstractCatalogGroup
implements ICatalogGroup {
    @Override
    @NonNull
    public Stream<String> getReferencedParameterIds() {
        Stream insertIds = CollectionUtil.listOrEmpty(this.getParts()).stream().flatMap(part -> Stream.concat(Stream.of(part), part.getPartsRecursively())).flatMap(part -> part.getInserts(insert -> "param".equals(insert.getType().toString()))).map(insert -> insert.getIdReference().toString()).flatMap(ObjectUtils::filterNull);
        Stream parameterIds = CollectionUtil.listOrEmpty(this.getParams()).stream().flatMap(ObjectUtils::filterNull).flatMap(AbstractParameter::getParameterReferences);
        return (Stream)ObjectUtils.notNull(Stream.concat(insertIds, parameterIds).distinct());
    }

    @NonNull
    public static Builder builder(@NonNull String id) {
        return new Builder(id);
    }

    public static class Builder {
        @NonNull
        private final String id;
        private String clazz;
        private MarkupLine title;
        private final List<Parameter> params = new LinkedList<Parameter>();
        private final List<Property> props = new LinkedList<Property>();
        private final List<Link> links = new LinkedList<Link>();
        private final List<ControlPart> parts = new LinkedList<ControlPart>();
        private final List<CatalogGroup> groups = new LinkedList<CatalogGroup>();
        private final List<Control> controls = new LinkedList<Control>();

        public Builder(@NonNull String id) {
            this.id = (String)ObjectUtils.requireNonNull((Object)id, (String)"id");
        }

        @NonNull
        public Builder clazz(@NonNull String value) {
            this.clazz = (String)ObjectUtils.requireNonNull((Object)value, (String)"value");
            return this;
        }

        @NonNull
        public Builder title(@NonNull String markdown) {
            this.title = MarkupLine.fromMarkdown((String)Objects.requireNonNull(markdown, "markdown"));
            return this;
        }

        @NonNull
        public Builder title(@NonNull MarkupLine value) {
            this.title = (MarkupLine)ObjectUtils.requireNonNull((Object)value, (String)"value");
            return this;
        }

        @NonNull
        public Builder param(@NonNull Parameter value) {
            this.params.add(Objects.requireNonNull(value, "value"));
            return this;
        }

        @NonNull
        public Builder prop(@NonNull Property value) {
            this.props.add(Objects.requireNonNull(value, "value"));
            return this;
        }

        @NonNull
        public Builder link(@NonNull Link value) {
            this.links.add(Objects.requireNonNull(value, "value"));
            return this;
        }

        @NonNull
        public Builder part(@NonNull ControlPart value) {
            this.parts.add(Objects.requireNonNull(value, "value"));
            return this;
        }

        @NonNull
        public Builder group(@NonNull CatalogGroup value) {
            this.groups.add(Objects.requireNonNull(value, "value"));
            return this;
        }

        @NonNull
        public Builder control(@NonNull Control value) {
            this.controls.add(Objects.requireNonNull(value, "value"));
            return this;
        }

        @NonNull
        public CatalogGroup build() {
            CatalogGroup retval = new CatalogGroup();
            retval.setId(this.id);
            if (this.title == null) {
                throw new IllegalStateException("a title must be provided");
            }
            retval.setTitle(this.title);
            if (this.clazz != null) {
                retval.setClazz(this.clazz);
            }
            if (!this.params.isEmpty()) {
                retval.setParams(this.params);
            }
            if (!this.props.isEmpty()) {
                retval.setProps(this.props);
            }
            if (!this.links.isEmpty()) {
                retval.setLinks(this.links);
            }
            if (!this.parts.isEmpty()) {
                retval.setParts(this.parts);
            }
            if (!this.controls.isEmpty()) {
                retval.setControls(this.controls);
            }
            if (!this.groups.isEmpty()) {
                retval.setGroups(this.groups);
            }
            return retval;
        }
    }
}

