/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.control.catalog;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.control.catalog.ICatalogVisitor;
import java.util.Objects;

public abstract class AbstractCatalogVisitor<RESULT, CONTEXT>
implements ICatalogVisitor<RESULT, CONTEXT> {
    protected abstract RESULT defaultResult();

    protected RESULT aggregateResult(RESULT previous, RESULT current) {
        return current;
    }

    @Override
    public RESULT visitCatalog(Catalog catalog, CONTEXT context) {
        Object result = CollectionUtil.listOrEmpty(catalog.getGroups()).stream().filter(Objects::nonNull).map(childGroup -> this.visitGroup((CatalogGroup)ObjectUtils.notNull((Object)childGroup), context)).reduce(this.defaultResult(), this::aggregateResult);
        result = CollectionUtil.listOrEmpty(catalog.getControls()).stream().filter(Objects::nonNull).map(childControl -> this.visitControl((Control)ObjectUtils.notNull((Object)childControl), context)).reduce(result, this::aggregateResult);
        return (RESULT)CollectionUtil.listOrEmpty(catalog.getParams()).stream().filter(Objects::nonNull).map(childParameter -> this.visitParameter((Parameter)ObjectUtils.notNull((Object)childParameter), context)).reduce(result, this::aggregateResult);
    }

    @Override
    public RESULT visitGroup(@NonNull CatalogGroup group, CONTEXT context) {
        Object result = CollectionUtil.listOrEmpty(group.getGroups()).stream().filter(Objects::nonNull).map(childGroup -> this.visitGroup((CatalogGroup)ObjectUtils.notNull((Object)childGroup), context)).reduce(this.defaultResult(), this::aggregateResult);
        result = CollectionUtil.listOrEmpty(group.getControls()).stream().filter(Objects::nonNull).map(childControl -> this.visitControl((Control)ObjectUtils.notNull((Object)childControl), context)).reduce(result, this::aggregateResult);
        return (RESULT)CollectionUtil.listOrEmpty(group.getParams()).stream().filter(Objects::nonNull).map(childParameter -> this.visitParameter((Parameter)ObjectUtils.notNull((Object)childParameter), context)).reduce(result, this::aggregateResult);
    }

    @Override
    public RESULT visitControl(Control control, CONTEXT context) {
        Object result = CollectionUtil.listOrEmpty(control.getControls()).stream().filter(Objects::nonNull).map(childControl -> this.visitControl((Control)ObjectUtils.notNull((Object)childControl), context)).reduce(this.defaultResult(), this::aggregateResult);
        return (RESULT)CollectionUtil.listOrEmpty(control.getParams()).stream().filter(Objects::nonNull).map(childParameter -> this.visitParameter((Parameter)ObjectUtils.notNull((Object)childParameter), context)).reduce(result, this::aggregateResult);
    }

    @Override
    public RESULT visitParameter(Parameter parameter, CONTEXT context) {
        return this.defaultResult();
    }
}

