/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.control.profile;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.oscal.lib.model.Matching;
import gov.nist.secauto.oscal.lib.model.ProfileSelectControlById;
import gov.nist.secauto.oscal.lib.model.control.profile.IProfileSelectControlById;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractProfileSelectControlById
implements IProfileSelectControlById {
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean withChildControls;
        private final List<String> withIds = new LinkedList<String>();
        private final List<Pattern> matching = new LinkedList<Pattern>();

        @NonNull
        public Builder withChildControls(boolean value) {
            this.withChildControls = value;
            return this;
        }

        @NonNull
        public Builder withId(@NonNull String id) {
            this.withIds.add(id);
            return this;
        }

        @NonNull
        public Builder withIds(@NonNull Collection<String> ids) {
            this.withIds.addAll(ids);
            return this;
        }

        @NonNull
        public Builder matching(@NonNull Pattern pattern) {
            this.matching.add(pattern);
            return this;
        }

        @NonNull
        public ProfileSelectControlById build() {
            ProfileSelectControlById retval = new ProfileSelectControlById();
            retval.setWithChildControls(this.withChildControls ? "yes" : "no");
            retval.setWithIds(this.withIds);
            retval.setMatching(this.matching.stream().map(pattern -> {
                Matching matching = new Matching();
                matching.setPattern(pattern.pattern());
                return matching;
            }).collect(Collectors.toList()));
            return retval;
        }
    }
}

