/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.metadata;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.metadata.ILink;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractLink
implements ILink {
    public static List<Link> merge(@NonNull List<Link> original, @NonNull List<Link> additional) {
        return Stream.concat(original.stream(), additional.stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    @NonNull
    public static Builder builder(@NonNull URI href) {
        return new Builder(href);
    }

    public static class Builder {
        @NonNull
        private final URI href;
        private String rel;
        private String mediaType;
        private MarkupLine text;

        public Builder(@NonNull URI href) {
            this.href = (URI)ObjectUtils.requireNonNull((Object)href, (String)"href");
        }

        @NonNull
        public Builder relation(@NonNull String relation) {
            this.rel = (String)ObjectUtils.requireNonNull((Object)relation, (String)"rel");
            return this;
        }

        @NonNull
        public Builder value(@NonNull String mediaType) {
            this.mediaType = (String)ObjectUtils.requireNonNull((Object)mediaType, (String)"mediaType");
            return this;
        }

        @NonNull
        public Builder clazz(@NonNull MarkupLine text) {
            this.text = (MarkupLine)ObjectUtils.requireNonNull((Object)text, (String)"text");
            return this;
        }

        @NonNull
        public Link build() {
            Link retval = new Link();
            retval.setHref(this.href);
            if (this.rel != null) {
                retval.setRel(this.rel);
            }
            if (this.mediaType != null) {
                retval.setMediaType(this.mediaType);
            }
            if (this.text != null) {
                retval.setText(this.text);
            }
            return retval;
        }
    }
}

