/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model.metadata;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.metadata.IProperty;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;

public abstract class AbstractProperty
implements IProperty {
    @NonNull
    public static QName qname(URI namespace, @NonNull String name) {
        return new QName(AbstractProperty.normalizeNamespace(namespace).toString(), name);
    }

    @NonNull
    public static QName qname(@NonNull String name) {
        return new QName(OSCAL_NAMESPACE.toString(), name);
    }

    @NonNull
    public static URI normalizeNamespace(URI namespace) {
        URI propertyNamespace = namespace;
        if (propertyNamespace == null) {
            propertyNamespace = OSCAL_NAMESPACE;
        }
        return propertyNamespace;
    }

    @NonNull
    public static Optional<Property> find(List<Property> props, @NonNull QName qname) {
        return CollectionUtil.listOrEmpty(props).stream().filter(prop -> qname.equals(prop.getQName())).findFirst();
    }

    protected AbstractProperty() {
    }

    public static List<Property> merge(@NonNull List<Property> original, @NonNull List<Property> additional) {
        return Stream.concat(original.stream(), additional.stream()).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public boolean isNamespaceEqual(@NonNull URI namespace) {
        return AbstractProperty.normalizeNamespace(this.getNs()).equals(namespace);
    }

    @NonNull
    public QName getQName() {
        return new QName(AbstractProperty.normalizeNamespace(this.getNs()).toString(), this.getName());
    }

    @NonNull
    public static Builder builder(@NonNull String name) {
        return new Builder(name);
    }

    public static class Builder {
        @NonNull
        private final String name;
        private UUID uuid;
        private URI namespace;
        private String value;
        private String clazz;

        public Builder(@NonNull String name) {
            this.name = Objects.requireNonNull(name, "name");
        }

        @NonNull
        public Builder uuid(@NonNull UUID uuid) {
            this.uuid = Objects.requireNonNull(uuid);
            return this;
        }

        @NonNull
        public Builder namespace(@NonNull URI namespace) {
            this.namespace = IProperty.OSCAL_NAMESPACE.equals(namespace) ? null : Objects.requireNonNull(namespace);
            return this;
        }

        @NonNull
        public Builder value(@NonNull String value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        @NonNull
        public Builder clazz(@NonNull String clazz) {
            this.clazz = Objects.requireNonNull(clazz);
            return this;
        }

        @NonNull
        public Property build() {
            Property retval = new Property();
            retval.setName(this.name);
            retval.setValue(Objects.requireNonNull(this.value, "value"));
            if (this.uuid != null) {
                retval.setUuid(this.uuid);
            }
            if (this.namespace != null) {
                retval.setNs(this.namespace);
            }
            if (this.clazz != null) {
                retval.setClazz(this.clazz);
            }
            return retval;
        }
    }
}

