/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ModifyPhaseUtils {
    private ModifyPhaseUtils() {
    }

    public static <T> Function<? super T, String> identityKey() {
        return item -> Integer.toString(Objects.hashCode(item));
    }

    public static <T, R> Function<? super T, String> identifierKey(@NonNull Function<T, R> identifierFunction) {
        return item -> {
            Object identifier = identifierFunction.apply(item);
            String retval = identifier == null ? Integer.toString(Objects.hashCode(item)) : identifier.toString();
            return retval;
        };
    }

    public static <T> T mergeItem(@Nullable T original, @Nullable T additional) {
        if (additional == null) {
            return original;
        }
        return additional;
    }

    public static <T> List<T> merge(@Nullable List<T> original, @Nullable List<T> additional, Function<? super T, String> keyFunction) {
        if (additional == null || additional.isEmpty()) {
            return original;
        }
        if (original == null || original.isEmpty()) {
            return additional;
        }
        List reversed = Stream.concat(CollectionUtil.listOrEmpty(original).stream(), CollectionUtil.listOrEmpty(additional).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
            Collections.reverse(l);
            return l;
        }));
        Map identityMap = reversed.stream().collect(Collectors.groupingBy(keyFunction, LinkedHashMap::new, Collectors.toList()));
        return identityMap.values().stream().map(list -> list.stream().findFirst().get()).collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
            Collections.reverse(l);
            return l;
        }));
    }
}

