/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.IDocumentLoader;
import gov.nist.secauto.metaschema.core.metapath.ISequence;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.format.IPathFormatter;
import gov.nist.secauto.metaschema.core.metapath.function.FunctionUtils;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.oscal.lib.OscalBindingContext;
import gov.nist.secauto.oscal.lib.OscalModelConstants;
import gov.nist.secauto.oscal.lib.OscalUtils;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.Merge;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Modify;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Profile;
import gov.nist.secauto.oscal.lib.model.ProfileImport;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractLink;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractProperty;
import gov.nist.secauto.oscal.lib.profile.resolver.ModifyPhaseUtils;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionEvaluationException;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionException;
import gov.nist.secauto.oscal.lib.profile.resolver.alter.AddVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.alter.RemoveVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.merge.FlatteningStructuringVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.Import;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.ImportCycleException;
import gov.nist.secauto.oscal.lib.profile.resolver.support.BasicIndexer;
import gov.nist.secauto.oscal.lib.profile.resolver.support.ControlIndexingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProfileResolver {
    private static final Logger LOGGER = LogManager.getLogger(ProfileResolver.class);
    @NonNull
    private static final QName IMPORT_QNAME = new QName("http://csrc.nist.gov/ns/oscal/1.0", "import");
    @NonNull
    private static final MetapathExpression METAPATH_SET_PARAMETER = MetapathExpression.compile((String)"modify/set-parameter", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression METAPATH_ALTER = MetapathExpression.compile((String)"modify/alter", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression METAPATH_ALTER_REMOVE = MetapathExpression.compile((String)"remove", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression METAPATH_ALTER_ADD = MetapathExpression.compile((String)"add", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression CATALOG_OR_PROFILE = MetapathExpression.compile((String)"/(catalog|profile)", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression CATALOG = MetapathExpression.compile((String)"/catalog", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private final DynamicContext dynamicContext;

    public ProfileResolver() {
        this(ProfileResolver.newDynamicContext());
    }

    public ProfileResolver(@NonNull DynamicContext dynamicContext) {
        this.dynamicContext = dynamicContext;
    }

    @NonNull
    private static DynamicContext newDynamicContext() {
        IBoundLoader loader = OscalBindingContext.instance().newBoundLoader();
        loader.disableFeature(DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
        DynamicContext retval = new DynamicContext(StaticContext.builder().defaultModelNamespace(OscalModelConstants.NS_URI_OSCAL).build());
        retval.setDocumentLoader((IDocumentLoader)loader);
        return retval;
    }

    @NonNull
    public IDocumentLoader getDocumentLoader() {
        return this.getDynamicContext().getDocumentLoader();
    }

    @NonNull
    public DynamicContext getDynamicContext() {
        return this.dynamicContext;
    }

    @Nullable
    private static IRootAssemblyNodeItem getRoot(@NonNull IDocumentNodeItem document, @NonNull MetapathExpression rootPath) {
        ISequence result = rootPath.evaluate((IItem)document);
        IItem item = result.getFirstItem(false);
        return item == null ? null : (IRootAssemblyNodeItem)FunctionUtils.asType((IItem)item);
    }

    @NonNull
    public IDocumentNodeItem resolve(@NonNull URL url) throws URISyntaxException, IOException, ProfileResolutionException {
        IDocumentLoader loader = this.getDocumentLoader();
        IDocumentNodeItem catalogOrProfile = loader.loadAsNodeItem(url);
        return this.resolve(catalogOrProfile, new Stack<URI>());
    }

    @NonNull
    public IDocumentNodeItem resolve(@NonNull File file) throws IOException, ProfileResolutionException {
        return this.resolve((Path)ObjectUtils.notNull((Object)file.toPath()));
    }

    @NonNull
    public IDocumentNodeItem resolve(@NonNull Path path) throws IOException, ProfileResolutionException {
        IDocumentLoader loader = this.getDocumentLoader();
        IDocumentNodeItem catalogOrProfile = loader.loadAsNodeItem(path);
        return this.resolve(catalogOrProfile, new Stack<URI>());
    }

    @NonNull
    public IDocumentNodeItem resolve(@NonNull IDocumentNodeItem profileOrCatalogDocument) throws IOException, ProfileResolutionException {
        return this.resolve(profileOrCatalogDocument, new Stack<URI>());
    }

    @NonNull
    public IDocumentNodeItem resolve(@NonNull IDocumentNodeItem profileOrCatalogDocument, @NonNull Stack<URI> importHistory) throws IOException, ProfileResolutionException {
        IRootAssemblyNodeItem profileOrCatalog = ProfileResolver.getRoot(profileOrCatalogDocument, CATALOG_OR_PROFILE);
        if (profileOrCatalog == null) {
            throw new ProfileResolutionException(String.format("The provided document '%s' does not contain a catalog or profile.", profileOrCatalogDocument.getDocumentUri()));
        }
        return this.resolve(profileOrCatalog, importHistory);
    }

    @NonNull
    public IDocumentNodeItem resolve(@NonNull IRootAssemblyNodeItem profileOrCatalog, @NonNull Stack<URI> importHistory) throws IOException, ProfileResolutionException {
        Object profileObject = profileOrCatalog.getValue();
        IDocumentNodeItem retval = profileObject instanceof Catalog ? profileOrCatalog.getParentNodeItem() : this.resolveProfile(profileOrCatalog, importHistory);
        return retval;
    }

    @NonNull
    protected IDocumentNodeItem resolveProfile(@NonNull IRootAssemblyNodeItem profileItem, @NonNull Stack<URI> importHistory) throws IOException, ProfileResolutionException {
        Catalog resolvedCatalog = new Catalog();
        ProfileResolver.generateMetadata(resolvedCatalog, profileItem);
        IIndexer index = this.resolveImports(resolvedCatalog, profileItem, importHistory);
        ProfileResolver.handleReferences(resolvedCatalog, profileItem, index);
        this.handleMerge(resolvedCatalog, profileItem, index);
        this.handleModify(resolvedCatalog, profileItem);
        return INodeItemFactory.instance().newDocumentNodeItem((IAssemblyDefinition)ObjectUtils.requireNonNull((Object)((IBoundDefinitionModelAssembly)OscalBindingContext.instance().getBoundDefinitionForClass(Catalog.class))), (URI)ObjectUtils.requireNonNull((Object)profileItem.getBaseUri()), (Object)resolvedCatalog);
    }

    @NonNull
    private static Profile toProfile(@NonNull IRootAssemblyNodeItem profileItem) {
        Object object = profileItem.getValue();
        assert (object != null);
        return (Profile)object;
    }

    private static void generateMetadata(@NonNull Catalog resolvedCatalog, @NonNull IRootAssemblyNodeItem profileItem) {
        resolvedCatalog.setUuid(UUID.randomUUID());
        Profile profile = ProfileResolver.toProfile(profileItem);
        Metadata profileMetadata = profile.getMetadata();
        Metadata resolvedMetadata = new Metadata();
        resolvedMetadata.setTitle(profileMetadata.getTitle());
        if (profileMetadata.getVersion() != null) {
            resolvedMetadata.setVersion(profileMetadata.getVersion());
        }
        resolvedMetadata.setOscalVersion(profileMetadata.getOscalVersion());
        resolvedMetadata.setLastModified(ZonedDateTime.now(ZoneOffset.UTC));
        resolvedMetadata.addProp(AbstractProperty.builder("resolution-tool").value("libOSCAL-Java").build());
        URI profileUri = (URI)ObjectUtils.requireNonNull((Object)profileItem.getParentNodeItem().getDocumentUri());
        resolvedMetadata.addLink(AbstractLink.builder(profileUri).relation("source-profile").build());
        resolvedCatalog.setMetadata(resolvedMetadata);
    }

    @NonNull
    private IIndexer resolveImports(@NonNull Catalog resolvedCatalog, @NonNull IRootAssemblyNodeItem profileItem, @NonNull Stack<URI> importHistory) throws IOException, ProfileResolutionException {
        List profileImports = profileItem.getModelItemsByName(IMPORT_QNAME);
        if (profileImports.isEmpty()) {
            throw new ProfileResolutionException(String.format("Profile '%s' has no imports", profileItem.getBaseUri()));
        }
        BasicIndexer retval = new BasicIndexer();
        for (IAssemblyNodeItem profileImportItem : profileImports) {
            IIndexer result = this.resolveImport((IAssemblyNodeItem)ObjectUtils.notNull((Object)profileImportItem), profileItem, importHistory, resolvedCatalog);
            retval.append(result);
        }
        return retval;
    }

    @NonNull
    protected IIndexer resolveImport(@NonNull IAssemblyNodeItem profileImportItem, @NonNull IRootAssemblyNodeItem profileItem, @NonNull Stack<URI> importHistory, @NonNull Catalog resolvedCatalog) throws IOException, ProfileResolutionException {
        ProfileImport profileImport = (ProfileImport)ObjectUtils.requireNonNull((Object)((ProfileImport)profileImportItem.getValue()));
        URI importUri = profileImport.getHref();
        if (importUri == null) {
            throw new ProfileResolutionException("profileImport.getHref() must return a non-null URI");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("resolving profile import '{}'", (Object)importUri);
        }
        IDocumentNodeItem importedDocument = this.getImport(importUri, profileItem);
        URI importedUri = importedDocument.getDocumentUri();
        assert (importedUri != null);
        try {
            ProfileResolver.requireNonCycle(importedUri, importHistory);
        }
        catch (ImportCycleException ex) {
            throw new IOException(ex);
        }
        importHistory.push(importedUri);
        try {
            IDocumentNodeItem importedCatalog = this.resolve(importedDocument, importHistory);
            try {
                IRootAssemblyNodeItem importedCatalogRoot = (IRootAssemblyNodeItem)ObjectUtils.requireNonNull((Object)ProfileResolver.getRoot(importedCatalog, CATALOG));
                Catalog catalogCopy = (Catalog)OscalBindingContext.instance().deepCopy((IBoundObject)((IRootAssemblyNodeItem)ObjectUtils.requireNonNull((Object)importedCatalogRoot)).getValue(), null);
                importedCatalog = INodeItemFactory.instance().newDocumentNodeItem((IAssemblyDefinition)importedCatalogRoot.getDefinition(), (URI)ObjectUtils.requireNonNull((Object)importedCatalog.getDocumentUri()), (Object)catalogCopy);
                IIndexer iIndexer = new Import(profileItem, profileImportItem).resolve(importedCatalog, resolvedCatalog);
                return iIndexer;
            }
            catch (BindingException ex) {
                throw new IOException(ex);
            }
        }
        finally {
            URI poppedUri = (URI)ObjectUtils.notNull((Object)importHistory.pop());
            assert (importedUri.equals(poppedUri));
        }
    }

    private IDocumentNodeItem getImport(@NonNull URI importUri, @NonNull IRootAssemblyNodeItem importingProfile) throws IOException {
        IDocumentNodeItem retval;
        URI importingDocumentUri = (URI)ObjectUtils.requireNonNull((Object)importingProfile.getParentNodeItem().getDocumentUri());
        if (OscalUtils.isInternalReference(importUri)) {
            String uuid = OscalUtils.internalReferenceFragmentToId(importUri);
            Profile profile = (Profile)INodeItem.toValue((INodeItem)importingProfile);
            BackMatter.Resource resource = profile.getResourceByUuid((UUID)ObjectUtils.notNull((Object)UUID.fromString(uuid)));
            if (resource == null) {
                throw new IOException(String.format("unable to find the resource identified by '%s' used in profile import", importUri));
            }
            retval = this.getImport(resource, importingDocumentUri);
        } else {
            URI uri = importingDocumentUri.resolve(importUri);
            assert (uri != null);
            retval = this.getDynamicContext().getDocumentLoader().loadAsNodeItem(uri);
        }
        return retval;
    }

    @Nullable
    private IDocumentNodeItem getImport(@NonNull BackMatter.Resource resource, @NonNull URI baseUri) throws IOException {
        ByteBuffer buffer;
        IDocumentLoader loader = this.getDynamicContext().getDocumentLoader();
        IDocumentNodeItem retval = null;
        BackMatter.Resource.Base64 base64 = resource.getBase64();
        ByteBuffer byteBuffer = buffer = base64 == null ? null : base64.getValue();
        if (buffer != null) {
            URI resourceUri = baseUri.resolve("#" + resource.getUuid());
            assert (resourceUri != null);
            retval = loader.loadAsNodeItem(resourceUri);
        }
        if (retval == null) {
            URI uri;
            BackMatter.Resource.Rlink rlink = OscalUtils.findMatchingRLink(resource, null);
            URI uRI = uri = rlink == null ? null : rlink.getHref();
            if (uri == null) {
                throw new IOException(String.format("unable to determine URI for resource '%s'", resource.getUuid()));
            }
            uri = baseUri.resolve(uri);
            assert (uri != null);
            retval = loader.loadAsNodeItem(uri);
        }
        return retval;
    }

    private static void requireNonCycle(@NonNull URI uri, @NonNull Stack<URI> importHistory) throws ImportCycleException {
        List<URI> cycle = ProfileResolver.checkCycle(uri, importHistory);
        if (!cycle.isEmpty()) {
            throw new ImportCycleException(String.format("Importing resource '%s' would result in the import cycle: %s", uri, cycle.stream().map(URI::toString).collect(Collectors.joining(" -> ", " -> ", ""))));
        }
    }

    @NonNull
    private static List<URI> checkCycle(@NonNull URI uri, @NonNull Stack<URI> importHistory) {
        int index = importHistory.indexOf(uri);
        List retval = index == -1 ? CollectionUtil.emptyList() : CollectionUtil.unmodifiableList((List)((List)ObjectUtils.notNull(importHistory.subList(0, index + 1))));
        return retval;
    }

    private static StructuringDirective getStructuringDirective(Profile profile) {
        Merge merge = profile.getMerge();
        StructuringDirective retval = merge == null ? StructuringDirective.FLAT : (merge.getAsIs() != null && merge.getAsIs() != false ? StructuringDirective.AS_IS : (merge.getCustom() != null ? StructuringDirective.CUSTOM : StructuringDirective.FLAT));
        return retval;
    }

    protected void handleMerge(@NonNull Catalog resolvedCatalog, @NonNull IRootAssemblyNodeItem profileItem, @NonNull IIndexer importIndex) {
        switch (ProfileResolver.getStructuringDirective(ProfileResolver.toProfile(profileItem))) {
            case AS_IS: {
                break;
            }
            case CUSTOM: {
                throw new UnsupportedOperationException("custom structuring");
            }
            default: {
                this.structureFlat(resolvedCatalog, profileItem, importIndex);
            }
        }
    }

    protected void structureFlat(@NonNull Catalog resolvedCatalog, @NonNull IRootAssemblyNodeItem profileItem, @NonNull IIndexer importIndex) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("applying flat structuring directive");
        }
        IDocumentNodeItem resolvedCatalogItem = INodeItemFactory.instance().newDocumentNodeItem((IAssemblyDefinition)ObjectUtils.requireNonNull((Object)((IBoundDefinitionModelAssembly)OscalBindingContext.instance().getBoundDefinitionForClass(Catalog.class))), (URI)ObjectUtils.requireNonNull((Object)profileItem.getBaseUri()), (Object)resolvedCatalog);
        FlatteningStructuringVisitor.instance().visitCatalog(resolvedCatalogItem, importIndex);
    }

    protected void handleModify(@NonNull Catalog resolvedCatalog, @NonNull IRootAssemblyNodeItem profileItem) throws ProfileResolutionException {
        IDocumentNodeItem resolvedCatalogDocument = INodeItemFactory.instance().newDocumentNodeItem((IAssemblyDefinition)ObjectUtils.requireNonNull((Object)((IBoundDefinitionModelAssembly)OscalBindingContext.instance().getBoundDefinitionForClass(Catalog.class))), (URI)ObjectUtils.requireNonNull((Object)profileItem.getBaseUri()), (Object)resolvedCatalog);
        try {
            BasicIndexer indexer = new BasicIndexer();
            ControlIndexingVisitor visitor = new ControlIndexingVisitor((Set)ObjectUtils.notNull(EnumSet.of(IEntityItem.ItemType.CONTROL, IEntityItem.ItemType.PARAMETER)));
            visitor.visitCatalog(resolvedCatalogDocument, indexer);
            METAPATH_SET_PARAMETER.evaluate((IItem)profileItem).forEach(item -> {
                IAssemblyNodeItem setParameter = (IAssemblyNodeItem)item;
                try {
                    this.handleSetParameter(setParameter, indexer);
                }
                catch (ProfileResolutionEvaluationException ex) {
                    throw new ProfileResolutionEvaluationException(String.format("Unable to apply the set-parameter at '%s'. %s", setParameter.toPath(IPathFormatter.METAPATH_PATH_FORMATER), ex.getLocalizedMessage()), ex);
                }
            });
            METAPATH_ALTER.evaluate((IItem)profileItem).forEach(item -> this.handleAlter((IAssemblyNodeItem)item, indexer));
        }
        catch (ProfileResolutionEvaluationException ex) {
            throw new ProfileResolutionException(ex.getLocalizedMessage(), ex);
        }
    }

    protected void handleSetParameter(IAssemblyNodeItem item, IIndexer indexer) {
        Modify.ProfileSetParameter setParameter = (Modify.ProfileSetParameter)ObjectUtils.requireNonNull((Object)((Modify.ProfileSetParameter)item.getValue()));
        String paramId = (String)ObjectUtils.requireNonNull((Object)setParameter.getParamId());
        IEntityItem entity = indexer.getEntity(IEntityItem.ItemType.PARAMETER, paramId, false);
        if (entity == null) {
            throw new ProfileResolutionEvaluationException(String.format("The parameter '%s' does not exist in the resolved catalog.", paramId));
        }
        Parameter param = (Parameter)entity.getInstanceValue();
        param.setClazz(ModifyPhaseUtils.mergeItem(param.getClazz(), setParameter.getClazz()));
        param.setProps(ModifyPhaseUtils.merge(param.getProps(), setParameter.getProps(), ModifyPhaseUtils.identifierKey(Property::getUuid)));
        param.setLinks(ModifyPhaseUtils.merge(param.getLinks(), setParameter.getLinks(), ModifyPhaseUtils.identityKey()));
        param.setLabel(ModifyPhaseUtils.mergeItem(param.getLabel(), setParameter.getLabel()));
        param.setUsage(ModifyPhaseUtils.mergeItem(param.getUsage(), setParameter.getUsage()));
        param.setConstraints(ModifyPhaseUtils.merge(param.getConstraints(), setParameter.getConstraints(), ModifyPhaseUtils.identityKey()));
        param.setGuidelines(ModifyPhaseUtils.merge(param.getGuidelines(), setParameter.getGuidelines(), ModifyPhaseUtils.identityKey()));
        param.setValues(new LinkedList<String>(setParameter.getValues()));
        param.setSelect(setParameter.getSelect());
    }

    protected void handleAlter(IAssemblyNodeItem item, IIndexer indexer) {
        Modify.Alter alter = (Modify.Alter)ObjectUtils.requireNonNull((Object)((Modify.Alter)item.getValue()));
        String controlId = (String)ObjectUtils.requireNonNull((Object)alter.getControlId());
        IEntityItem entity = indexer.getEntity(IEntityItem.ItemType.CONTROL, controlId, false);
        if (entity == null) {
            throw new ProfileResolutionEvaluationException(String.format("Unable to apply the alter targeting control '%s' at '%s'. The control does not exist in the resolved catalog.", controlId, item.toPath(IPathFormatter.METAPATH_PATH_FORMATER)));
        }
        Control control = (Control)entity.getInstanceValue();
        METAPATH_ALTER_REMOVE.evaluate((IItem)item).forEach(nodeItem -> {
            INodeItem removeItem = (INodeItem)nodeItem;
            Modify.Alter.Remove remove = (Modify.Alter.Remove)ObjectUtils.notNull((Object)((Modify.Alter.Remove)removeItem.getValue()));
            try {
                if (!RemoveVisitor.remove(control, remove.getByName(), remove.getByClass(), remove.getById(), remove.getByNs(), RemoveVisitor.TargetType.forFieldName(remove.getByItemName()))) {
                    throw new ProfileResolutionEvaluationException(String.format("The remove did not match a valid target", new Object[0]));
                }
            }
            catch (ProfileResolutionEvaluationException ex) {
                throw new ProfileResolutionEvaluationException(String.format("Unable to apply the remove targeting control '%s' at '%s'. %s", control.getId(), removeItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER), ex.getLocalizedMessage()), ex);
            }
        });
        METAPATH_ALTER_ADD.evaluate((IItem)item).forEach(nodeItem -> {
            INodeItem addItem = (INodeItem)nodeItem;
            Modify.Alter.Add add = (Modify.Alter.Add)ObjectUtils.notNull((Object)((Modify.Alter.Add)addItem.getValue()));
            String byId = add.getById();
            try {
                if (!AddVisitor.add(control, AddVisitor.Position.forName(add.getPosition()), byId, add.getTitle(), CollectionUtil.listOrEmpty(add.getParams()), CollectionUtil.listOrEmpty(add.getProps()), CollectionUtil.listOrEmpty(add.getLinks()), CollectionUtil.listOrEmpty(add.getParts()))) {
                    throw new ProfileResolutionEvaluationException(String.format("The add did not match a valid target", new Object[0]));
                }
            }
            catch (ProfileResolutionEvaluationException ex) {
                throw new ProfileResolutionEvaluationException(String.format("Unable to apply the add targeting control '%s'%s at '%s'. %s", control.getId(), byId == null ? "" : String.format(" having by-id '%s'", byId), addItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER), ex.getLocalizedMessage()), ex);
            }
        });
    }

    private static void handleReferences(@NonNull Catalog resolvedCatalog, @NonNull IRootAssemblyNodeItem profileItem, @NonNull IIndexer index) {
        BasicIndexer profileIndex = new BasicIndexer();
        new ControlIndexingVisitor((Set)ObjectUtils.notNull(EnumSet.allOf(IEntityItem.ItemType.class))).visitProfile(profileItem, profileIndex);
        Metadata resolvedMetadata = resolvedCatalog.getMetadata();
        resolvedMetadata.setRoles(IIndexer.filterDistinct((Stream)ObjectUtils.notNull(CollectionUtil.listOrEmpty(resolvedMetadata.getRoles()).stream()), profileIndex.getEntitiesByItemType(IEntityItem.ItemType.ROLE), Metadata.Role::getId).collect(Collectors.toCollection(LinkedList::new)));
        resolvedMetadata.setParties(IIndexer.filterDistinct((Stream)ObjectUtils.notNull(CollectionUtil.listOrEmpty(resolvedMetadata.getParties()).stream()), profileIndex.getEntitiesByItemType(IEntityItem.ItemType.PARTY), Metadata.Party::getUuid).collect(Collectors.toCollection(LinkedList::new)));
        resolvedMetadata.setLocations(IIndexer.filterDistinct((Stream)ObjectUtils.notNull(CollectionUtil.listOrEmpty(resolvedMetadata.getLocations()).stream()), profileIndex.getEntitiesByItemType(IEntityItem.ItemType.LOCATION), Metadata.Location::getUuid).collect(Collectors.toCollection(LinkedList::new)));
        BackMatter resolvedBackMatter = resolvedCatalog.getBackMatter();
        List resolvedResources = resolvedBackMatter == null ? CollectionUtil.emptyList() : CollectionUtil.listOrEmpty(resolvedBackMatter.getResources());
        List resources = IIndexer.filterDistinct((Stream)ObjectUtils.notNull(resolvedResources.stream()), profileIndex.getEntitiesByItemType(IEntityItem.ItemType.RESOURCE), BackMatter.Resource::getUuid).collect(Collectors.toCollection(LinkedList::new));
        if (!resources.isEmpty()) {
            if (resolvedBackMatter == null) {
                resolvedBackMatter = new BackMatter();
                resolvedCatalog.setBackMatter(resolvedBackMatter);
            }
            resolvedBackMatter.setResources(resources);
        }
        index.append(profileIndex);
    }

    public static enum StructuringDirective {
        FLAT,
        AS_IS,
        CUSTOM;

    }
}

