/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.alter;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.catalog.ICatalogVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionEvaluationException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AddVisitor
implements ICatalogVisitor<Boolean, Context> {
    @NonNull
    private static final AddVisitor INSTANCE = new AddVisitor();
    private static final Map<TargetType, Set<TargetType>> APPLICABLE_TARGETS = new EnumMap<TargetType, Set<TargetType>>(TargetType.class);

    private static Set<TargetType> getApplicableTypes(@NonNull TargetType type) {
        return APPLICABLE_TARGETS.getOrDefault((Object)type, CollectionUtil.emptySet());
    }

    public static boolean add(@NonNull Control control, @Nullable Position position, @Nullable String byId, @Nullable MarkupLine title, @NonNull List<Parameter> params, @NonNull List<Property> props, @NonNull List<Link> links, @NonNull List<ControlPart> parts) {
        return INSTANCE.visitControl(control, Context.newContext(control, position == null ? Position.ENDING : position, byId, title, params, props, links, parts));
    }

    @Override
    public Boolean visitCatalog(Catalog catalog, Context context) {
        throw new UnsupportedOperationException("not needed");
    }

    @Override
    public Boolean visitGroup(CatalogGroup group, Context context) {
        throw new UnsupportedOperationException("not needed");
    }

    private static <T> boolean handleCurrent(@NonNull T targetItem, @Nullable Consumer<MarkupLine> titleConsumer, @Nullable Supplier<? extends List<Parameter>> paramsSupplier, @Nullable Supplier<? extends List<Property>> propsSupplier, @Nullable Supplier<? extends List<Link>> linksSupplier, @Nullable Supplier<? extends List<ControlPart>> partsSupplier, @NonNull Context context) {
        boolean retval = false;
        Position position = context.getPosition();
        if (context.appliesTo(targetItem) && !context.isSequenceTargeted(targetItem)) {
            MarkupLine newTitle = context.getTitle();
            if (newTitle != null) {
                assert (titleConsumer != null);
                titleConsumer.accept(newTitle);
            }
            AddVisitor.handleCollection(position, context.getParams(), paramsSupplier);
            AddVisitor.handleCollection(position, context.getProps(), propsSupplier);
            AddVisitor.handleCollection(position, context.getLinks(), linksSupplier);
            AddVisitor.handleCollection(position, context.getParts(), partsSupplier);
            retval = true;
        }
        return retval;
    }

    private static <T> void handleCollection(@NonNull Position position, @NonNull List<T> newItems, @Nullable Supplier<? extends List<T>> originalCollectionSupplier) {
        if (originalCollectionSupplier != null) {
            List<T> oldItems = originalCollectionSupplier.get();
            if (!newItems.isEmpty()) {
                if (Position.STARTING.equals((Object)position)) {
                    oldItems.addAll(0, newItems);
                } else {
                    oldItems.addAll(newItems);
                }
            }
        }
    }

    private static <T> boolean handleChild(@NonNull TargetType itemType, @NonNull Supplier<? extends List<T>> originalCollectionSupplier, @NonNull Supplier<? extends List<T>> newItemsSupplier, @Nullable Function<T, Boolean> handler, @NonNull Context context) {
        boolean isItemTypeMatch = context.isMatchingType(itemType);
        Set<TargetType> applicableTypes = AddVisitor.getApplicableTypes(itemType);
        boolean descendChild = handler != null && !Collections.disjoint(context.getTargetItemTypes(), applicableTypes);
        boolean retval = false;
        if (isItemTypeMatch || descendChild) {
            List<T> collection = originalCollectionSupplier.get();
            ListIterator<T> iter = collection.listIterator();
            boolean deferred = false;
            while (iter.hasNext()) {
                Object item = ObjectUtils.requireNonNull(iter.next());
                if (isItemTypeMatch && context.appliesTo(item) && context.isSequenceTargeted(item)) {
                    switch (context.getPosition()) {
                        case AFTER: {
                            newItemsSupplier.get().forEach(iter::add);
                            retval = true;
                            break;
                        }
                        case BEFORE: {
                            iter.previous();
                            List<Object> adds = newItemsSupplier.get();
                            adds.forEach(iter::add);
                            item = iter.next();
                            retval = true;
                            break;
                        }
                        case STARTING: 
                        case ENDING: {
                            deferred = true;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(context.getPosition().name().toLowerCase(Locale.ROOT));
                        }
                    }
                }
                if (!descendChild) continue;
                assert (handler != null);
                retval = retval || handler.apply(item) != false;
            }
            if (deferred) {
                List<T> newItems = newItemsSupplier.get();
                if (Position.ENDING.equals((Object)context.getPosition())) {
                    collection.addAll(newItems);
                    retval = true;
                } else if (Position.STARTING.equals((Object)context.getPosition())) {
                    collection.addAll(0, newItems);
                    retval = true;
                }
            }
        }
        return retval;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Boolean visitControl(Control control, Context context) {
        if (!AddVisitor.$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (control.getParams() == null) {
            control.setParams(new LinkedList<Parameter>());
        }
        if (control.getProps() == null) {
            control.setProps(new LinkedList<Property>());
        }
        if (control.getLinks() == null) {
            control.setLinks(new LinkedList<Link>());
        }
        if (control.getParts() == null) {
            control.setParts(new LinkedList<ControlPart>());
        }
        retval = AddVisitor.handleCurrent(control, (Consumer<MarkupLine>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setTitle(gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine ), (Lgov/nist/secauto/metaschema/core/datatype/markup/MarkupLine;)V)((Control)control), (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getParams(), ()Ljava/util/List;)((Control)control), (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getProps(), ()Ljava/util/List;)((Control)control), (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getLinks(), ()Ljava/util/List;)((Control)control), (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getParts(), ()Ljava/util/List;)((Control)control), context);
        if (retval) ** GOTO lbl-1000
        if (AddVisitor.handleChild(TargetType.PARAM, (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getParams(), ()Ljava/util/List;)((Control)control), (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$visitControl$0(gov.nist.secauto.oscal.lib.profile.resolver.alter.AddVisitor$Context ), ()Ljava/util/List;)((Context)context), (Function<Parameter, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitControl$1(gov.nist.secauto.oscal.lib.profile.resolver.alter.AddVisitor$Context gov.nist.secauto.oscal.lib.model.Parameter ), (Lgov/nist/secauto/oscal/lib/model/Parameter;)Ljava/lang/Boolean;)((AddVisitor)this, (Context)context), context)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = retval = false;
        }
        if (retval) ** GOTO lbl-1000
        if (AddVisitor.handleChild(TargetType.PART, (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getParts(), ()Ljava/util/List;)((Control)control), (Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$visitControl$2(gov.nist.secauto.oscal.lib.profile.resolver.alter.AddVisitor$Context ), ()Ljava/util/List;)((Context)context), (Function<ControlPart, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitControl$3(gov.nist.secauto.oscal.lib.profile.resolver.alter.AddVisitor$Context gov.nist.secauto.oscal.lib.model.ControlPart ), (Lgov/nist/secauto/oscal/lib/model/ControlPart;)Ljava/lang/Boolean;)((AddVisitor)this, (Context)context), context)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        retval = v1;
        for (Control childControl : CollectionUtil.listOrEmpty(control.getControls())) {
            applicableTypes = AddVisitor.getApplicableTypes(TargetType.CONTROL);
            if (Collections.disjoint(context.getTargetItemTypes(), applicableTypes)) continue;
            retval = retval != false || this.visitControl((Control)ObjectUtils.requireNonNull((Object)childControl), context) != false;
        }
        return retval;
    }

    @Override
    public Boolean visitParameter(Parameter parameter, Context context) {
        assert (context != null);
        if (parameter.getProps() == null) {
            parameter.setProps(new LinkedList<Property>());
        }
        if (parameter.getLinks() == null) {
            parameter.setLinks(new LinkedList<Link>());
        }
        return AddVisitor.handleCurrent(parameter, null, null, parameter::getProps, parameter::getLinks, null, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visitPart(ControlPart part, Context context) {
        assert (context != null);
        if (part.getProps() == null) {
            part.setProps(new LinkedList<Property>());
        }
        if (part.getLinks() == null) {
            part.setLinks(new LinkedList<Link>());
        }
        if (part.getParts() == null) {
            part.setParts(new LinkedList<ControlPart>());
        }
        boolean retval = AddVisitor.handleCurrent(part, null, null, part::getProps, part::getLinks, part::getParts, context);
        if (retval) return true;
        if (!AddVisitor.handleChild(TargetType.PART, part::getParts, () -> context.getParts(), child -> this.visitPart((ControlPart)child, context), context)) return false;
        return true;
    }

    private /* synthetic */ Boolean lambda$visitControl$3(Context context, ControlPart child) {
        return this.visitPart(child, context);
    }

    private static /* synthetic */ List lambda$visitControl$2(Context rec$) {
        return rec$.getParts();
    }

    private /* synthetic */ Boolean lambda$visitControl$1(Context context, Parameter child) {
        return this.visitParameter((Parameter)ObjectUtils.notNull((Object)child), context);
    }

    private static /* synthetic */ List lambda$visitControl$0(Context rec$) {
        return rec$.getParams();
    }

    static {
        APPLICABLE_TARGETS.put(TargetType.CONTROL, Set.of(TargetType.CONTROL, TargetType.PARAM, TargetType.PART));
        APPLICABLE_TARGETS.put(TargetType.PARAM, Set.of(TargetType.PARAM));
        APPLICABLE_TARGETS.put(TargetType.PART, Set.of(TargetType.PART));
    }

    public static enum Position {
        BEFORE,
        AFTER,
        STARTING,
        ENDING;

        @NonNull
        private static final Map<String, Position> NAME_TO_POSITION;

        @Nullable
        public static Position forName(@Nullable String name) {
            return name == null ? null : NAME_TO_POSITION.get(name);
        }

        static {
            ConcurrentHashMap<String, Position> map = new ConcurrentHashMap<String, Position>();
            for (Position position : Position.values()) {
                map.put(position.name().toLowerCase(Locale.ROOT), position);
            }
            NAME_TO_POSITION = CollectionUtil.unmodifiableMap(map);
        }
    }

    static final class Context {
        @NonNull
        private static final Set<TargetType> TITLE_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.CONTROL, TargetType.PART));
        @NonNull
        private static final Set<TargetType> PARAM_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.CONTROL, TargetType.PARAM));
        @NonNull
        private static final Set<TargetType> PROP_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.CONTROL, TargetType.PARAM, TargetType.PART));
        @NonNull
        private static final Set<TargetType> LINK_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.CONTROL, TargetType.PARAM, TargetType.PART));
        @NonNull
        private static final Set<TargetType> PART_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.CONTROL, TargetType.PART));
        @NonNull
        private final Control control;
        @NonNull
        private final Position position;
        @Nullable
        private final String byId;
        @Nullable
        private final MarkupLine title;
        @NonNull
        private final List<Parameter> params;
        @NonNull
        private final List<Property> props;
        @NonNull
        private final List<Link> links;
        @NonNull
        private final List<ControlPart> parts;
        @NonNull
        private final Set<TargetType> targetItemTypes;

        public static Context newContext(@NonNull Control control, @NonNull Position position, @Nullable String byId, @Nullable MarkupLine title, @NonNull List<Parameter> params, @NonNull List<Property> props, @NonNull List<Link> links, @NonNull List<ControlPart> parts) {
            Set targetItemTypes = (Set)ObjectUtils.notNull(EnumSet.allOf(TargetType.class));
            LinkedList<String> additionObjects = new LinkedList<String>();
            boolean sequenceTarget = true;
            if (title != null) {
                targetItemTypes.retainAll(TITLE_TYPES);
                additionObjects.add("title");
                sequenceTarget = false;
            }
            if (!params.isEmpty()) {
                targetItemTypes.retainAll(PARAM_TYPES);
                additionObjects.add("param");
            }
            if (!props.isEmpty()) {
                targetItemTypes.retainAll(PROP_TYPES);
                additionObjects.add("prop");
                sequenceTarget = false;
            }
            if (!links.isEmpty()) {
                targetItemTypes.retainAll(LINK_TYPES);
                additionObjects.add("link");
                sequenceTarget = false;
            }
            if (!parts.isEmpty()) {
                targetItemTypes.retainAll(PART_TYPES);
                additionObjects.add("part");
            }
            if (Position.BEFORE.equals((Object)position) || Position.AFTER.equals((Object)position)) {
                if (!sequenceTarget) {
                    throw new ProfileResolutionEvaluationException("When using position before or after, one collection of parameters or parts can be specified. Other additions must not be used.");
                }
                if (!params.isEmpty() && parts.isEmpty()) {
                    targetItemTypes.retainAll(Set.of(TargetType.PARAM));
                } else if (!parts.isEmpty() && params.isEmpty()) {
                    targetItemTypes.retainAll(Set.of(TargetType.PART));
                } else {
                    throw new ProfileResolutionEvaluationException("When using position before or after, only one collection of parameters or parts can be specified.");
                }
            }
            if (targetItemTypes.isEmpty()) {
                throw new ProfileResolutionEvaluationException("No parent object supports the requested objects to add: " + (String)additionObjects.stream().collect(CustomCollectors.joiningWithOxfordComma((String)"or")));
            }
            return new Context(control, position, byId, title, params, props, links, parts, targetItemTypes);
        }

        private Context(@NonNull Control control, @NonNull Position position, @Nullable String byId, @Nullable MarkupLine title, @NonNull List<Parameter> params, @NonNull List<Property> props, @NonNull List<Link> links, @NonNull List<ControlPart> parts, @NonNull Set<TargetType> targetItemTypes) {
            this.control = control;
            this.position = position;
            this.byId = byId;
            this.title = title;
            this.params = params;
            this.props = props;
            this.links = links;
            this.parts = parts;
            this.targetItemTypes = CollectionUtil.unmodifiableSet(targetItemTypes);
        }

        @NonNull
        private Control getControl() {
            return this.control;
        }

        @NonNull
        private Position getPosition() {
            return this.position;
        }

        @Nullable
        private String getById() {
            return this.byId;
        }

        @Nullable
        private MarkupLine getTitle() {
            return this.title;
        }

        @NonNull
        private List<Parameter> getParams() {
            return this.params;
        }

        @NonNull
        private List<Property> getProps() {
            return this.props;
        }

        @NonNull
        private List<Link> getLinks() {
            return this.links;
        }

        @NonNull
        private List<ControlPart> getParts() {
            return this.parts;
        }

        @NonNull
        private Set<TargetType> getTargetItemTypes() {
            return this.targetItemTypes;
        }

        private boolean isMatchingType(@NonNull TargetType type) {
            return this.getTargetItemTypes().contains((Object)type);
        }

        private <T> boolean isSequenceTargeted(T targetItem) {
            TargetType objectType = TargetType.forClass(targetItem.getClass());
            return (Position.BEFORE.equals((Object)this.position) || Position.AFTER.equals((Object)this.position)) && (TargetType.PARAM.equals((Object)objectType) && this.isMatchingType(TargetType.PARAM) || TargetType.PART.equals((Object)objectType) && this.isMatchingType(TargetType.PART));
        }

        private boolean appliesTo(@NonNull Object obj) {
            boolean retval;
            TargetType objectType = TargetType.forClass(obj.getClass());
            boolean bl = retval = objectType != null && this.isMatchingType(objectType);
            if (retval) {
                assert (objectType != null);
                String actualId = null;
                switch (objectType) {
                    case CONTROL: {
                        Control control = (Control)obj;
                        actualId = control.getId();
                        break;
                    }
                    case PARAM: {
                        Parameter param = (Parameter)obj;
                        actualId = param.getId();
                        break;
                    }
                    case PART: {
                        ControlPart part = (ControlPart)obj;
                        String partId = part.getId();
                        if (part.getId() == null) break;
                        actualId = partId;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(objectType.fieldName());
                    }
                }
                String byId = this.getById();
                retval = this.getById() == null && TargetType.CONTROL.equals((Object)objectType) ? this.getControl().equals(obj) : byId != null && byId.equals(actualId);
            }
            return retval;
        }
    }

    public static enum TargetType {
        CONTROL("control", Control.class),
        PARAM("param", Parameter.class),
        PART("part", ControlPart.class);

        @NonNull
        private static final Map<Class<?>, TargetType> CLASS_TO_TYPE;
        @NonNull
        private static final Map<String, TargetType> NAME_TO_TYPE;
        @NonNull
        private final String fieldName;
        @NonNull
        private final Class<?> clazz;

        @Nullable
        public static TargetType forClass(@NonNull Class<?> clazz) {
            TargetType retval;
            Class<?> target = clazz;
            while ((retval = CLASS_TO_TYPE.get(target)) == null && (target = target.getSuperclass()) != null) {
            }
            return retval;
        }

        @Nullable
        public static TargetType forFieldName(@Nullable String name) {
            return name == null ? null : NAME_TO_TYPE.get(name);
        }

        private TargetType(String fieldName, Class<?> clazz) {
            this.fieldName = fieldName;
            this.clazz = clazz;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        static {
            ConcurrentHashMap<Object, TargetType> map = new ConcurrentHashMap<Object, TargetType>();
            for (TargetType type : TargetType.values()) {
                map.put(type.getClazz(), type);
            }
            CLASS_TO_TYPE = CollectionUtil.unmodifiableMap(map);
            map = new ConcurrentHashMap();
            for (TargetType type : TargetType.values()) {
                map.put(type.fieldName(), type);
            }
            NAME_TO_TYPE = CollectionUtil.unmodifiableMap(map);
        }
    }
}

