/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.alter;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.control.catalog.ICatalogVisitor;
import gov.nist.secauto.oscal.lib.model.metadata.IProperty;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionEvaluationException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class RemoveVisitor
implements ICatalogVisitor<Boolean, Context> {
    @NonNull
    private static final RemoveVisitor INSTANCE = new RemoveVisitor();
    private static final Map<TargetType, Set<TargetType>> APPLICABLE_TARGETS = new EnumMap<TargetType, Set<TargetType>>(TargetType.class);

    private static Set<TargetType> getApplicableTypes(@NonNull TargetType type) {
        return APPLICABLE_TARGETS.getOrDefault((Object)type, CollectionUtil.emptySet());
    }

    private static <T> boolean handle(@NonNull TargetType itemType, @NonNull Supplier<? extends Collection<T>> supplier, @Nullable Function<T, Boolean> handler, @NonNull Context context) {
        boolean retval;
        block4: {
            boolean handleChildren;
            block3: {
                handleChildren = !Collections.disjoint(context.getTargetItemTypes(), RemoveVisitor.getApplicableTypes(itemType));
                retval = false;
                if (!context.isMatchingType(itemType)) break block3;
                Iterator<T> iter = supplier.get().iterator();
                while (iter.hasNext()) {
                    T item = iter.next();
                    if (item == null || context.isApplicableTo(item)) {
                        iter.remove();
                        retval = true;
                        continue;
                    }
                    if (handler == null || !handleChildren) continue;
                    retval = retval || handler.apply(item) != false;
                }
                break block4;
            }
            if (!handleChildren || handler == null) break block4;
            for (T item : supplier.get()) {
                if (item == null) continue;
                retval = retval || handler.apply(item) != false;
            }
        }
        return retval;
    }

    public static boolean remove(@NonNull Control control, @Nullable String objectName, @Nullable String objectClass, @Nullable String objectId, @Nullable String objectNamespace, @Nullable TargetType itemType) {
        return INSTANCE.visitControl(control, new Context(objectName, objectClass, objectId, objectNamespace, itemType));
    }

    @Override
    public Boolean visitCatalog(Catalog catalog, Context context) {
        throw new UnsupportedOperationException("not needed");
    }

    @Override
    public Boolean visitGroup(CatalogGroup group, Context context) {
        throw new UnsupportedOperationException("not needed");
    }

    @NonNull
    private static <T> List<T> modifiableListOrEmpty(@Nullable List<T> list) {
        return list == null ? CollectionUtil.emptyList() : list;
    }

    @Override
    public Boolean visitControl(Control control, Context context) {
        assert (context != null);
        boolean retval = RemoveVisitor.handle(TargetType.PARAM, () -> RemoveVisitor.modifiableListOrEmpty(control.getParams()), child -> this.visitParameter((Parameter)ObjectUtils.notNull((Object)child), context), context);
        retval = retval || RemoveVisitor.handle(TargetType.PROP, () -> RemoveVisitor.modifiableListOrEmpty(control.getProps()), null, context);
        retval = retval || RemoveVisitor.handle(TargetType.LINK, () -> RemoveVisitor.modifiableListOrEmpty(control.getLinks()), null, context);
        return retval || RemoveVisitor.handle(TargetType.PART, () -> RemoveVisitor.modifiableListOrEmpty(control.getParts()), child -> this.visitPart((ControlPart)child, context), context);
    }

    @Override
    public Boolean visitParameter(Parameter parameter, Context context) {
        assert (context != null);
        boolean retval = RemoveVisitor.handle(TargetType.PROP, () -> RemoveVisitor.modifiableListOrEmpty(parameter.getProps()), null, context);
        return retval || RemoveVisitor.handle(TargetType.LINK, () -> RemoveVisitor.modifiableListOrEmpty(parameter.getLinks()), null, context);
    }

    public boolean visitPart(ControlPart part, Context context) {
        assert (context != null);
        boolean retval = RemoveVisitor.handle(TargetType.PROP, () -> RemoveVisitor.modifiableListOrEmpty(part.getProps()), null, context);
        retval = retval || RemoveVisitor.handle(TargetType.LINK, () -> RemoveVisitor.modifiableListOrEmpty(part.getLinks()), null, context);
        return retval || RemoveVisitor.handle(TargetType.PART, () -> RemoveVisitor.modifiableListOrEmpty(part.getParts()), child -> this.visitPart((ControlPart)child, context), context);
    }

    static {
        APPLICABLE_TARGETS.put(TargetType.PARAM, Set.of(TargetType.PROP, TargetType.LINK));
        APPLICABLE_TARGETS.put(TargetType.PART, Set.of(TargetType.PART, TargetType.PROP, TargetType.LINK));
    }

    static final class Context {
        @NonNull
        private static final Set<TargetType> NAME_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.PART, TargetType.PROP));
        @NonNull
        private static final Set<TargetType> CLASS_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.PARAM, TargetType.PART, TargetType.PROP));
        @NonNull
        private static final Set<TargetType> ID_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.PARAM, TargetType.PART));
        @NonNull
        private static final Set<TargetType> NAMESPACE_TYPES = (Set)ObjectUtils.notNull(Set.of(TargetType.PART, TargetType.PROP));
        @Nullable
        private final String objectName;
        @Nullable
        private final String objectClass;
        @Nullable
        private final String objectId;
        @Nullable
        private final String objectNamespace;
        @NonNull
        private final Set<TargetType> targetItemTypes;

        private static boolean filterTypes(@NonNull Set<TargetType> effectiveTypes, @NonNull String criteria, @NonNull Set<TargetType> allowedTypes, @Nullable String value, @Nullable TargetType itemType) {
            boolean retval = false;
            if (value != null) {
                retval = effectiveTypes.retainAll(allowedTypes);
                if (itemType != null && !allowedTypes.contains((Object)itemType)) {
                    throw new ProfileResolutionEvaluationException(String.format("%s='%s' is not supported for items of type '%s'", criteria, value, itemType.fieldName()));
                }
            }
            return retval;
        }

        private Context(@Nullable String objectName, @Nullable String objectClass, @Nullable String objectId, @Nullable String objectNamespace, @Nullable TargetType itemType) {
            Set targetItemTypes = (Set)ObjectUtils.notNull(EnumSet.allOf(TargetType.class));
            Context.filterTypes(targetItemTypes, "by-name", NAME_TYPES, objectName, itemType);
            Context.filterTypes(targetItemTypes, "by-class", CLASS_TYPES, objectClass, itemType);
            Context.filterTypes(targetItemTypes, "by-id", ID_TYPES, objectId, itemType);
            Context.filterTypes(targetItemTypes, "by-ns", NAMESPACE_TYPES, objectNamespace, itemType);
            if (itemType != null) {
                targetItemTypes.retainAll(Set.of(itemType));
            }
            if (targetItemTypes.isEmpty()) {
                throw new ProfileResolutionEvaluationException("The filter matches no available item types");
            }
            this.objectName = objectName;
            this.objectClass = objectClass;
            this.objectId = objectId;
            this.objectNamespace = objectNamespace;
            this.targetItemTypes = CollectionUtil.unmodifiableSet((Set)targetItemTypes);
        }

        @Nullable
        public String getObjectName() {
            return this.objectName;
        }

        @Nullable
        public String getObjectClass() {
            return this.objectClass;
        }

        @Nullable
        public String getObjectId() {
            return this.objectId;
        }

        @NonNull
        public Set<TargetType> getTargetItemTypes() {
            return this.targetItemTypes;
        }

        public boolean isMatchingType(@NonNull TargetType type) {
            return this.getTargetItemTypes().contains((Object)type);
        }

        @Nullable
        public String getObjectNamespace() {
            return this.objectNamespace;
        }

        private static boolean checkValue(@Nullable String actual, @Nullable String expected) {
            return expected == null || expected.equals(actual);
        }

        public boolean isApplicableTo(@NonNull Object obj) {
            boolean retval;
            TargetType objectType = TargetType.forClass(obj.getClass());
            boolean bl = retval = objectType != null && this.getTargetItemTypes().contains((Object)objectType);
            if (retval) {
                assert (objectType != null);
                String actualName = null;
                String actualClass = null;
                String actualId = null;
                String actualNamespace = null;
                switch (objectType) {
                    case PARAM: {
                        Parameter param = (Parameter)obj;
                        actualClass = param.getClazz();
                        actualId = param.getId();
                        break;
                    }
                    case PROP: {
                        Property prop = (Property)obj;
                        actualName = prop.getName();
                        actualClass = prop.getClazz();
                        actualNamespace = prop.getNs() == null ? IProperty.OSCAL_NAMESPACE.toString() : prop.getNs().toString();
                        break;
                    }
                    case PART: {
                        ControlPart part = (ControlPart)obj;
                        actualName = part.getName();
                        actualClass = part.getClazz();
                        String partId = part.getId();
                        if (partId != null) {
                            actualId = partId;
                        }
                        actualNamespace = part.getNs() == null ? IProperty.OSCAL_NAMESPACE.toString() : part.getNs().toString();
                        break;
                    }
                    case LINK: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(objectType.name().toLowerCase(Locale.ROOT));
                    }
                }
                retval = Context.checkValue(actualName, this.getObjectName()) && Context.checkValue(actualClass, this.getObjectClass()) && Context.checkValue(actualId, this.getObjectId()) && Context.checkValue(actualNamespace, this.getObjectNamespace());
            }
            return retval;
        }
    }

    public static enum TargetType {
        PARAM("param", Parameter.class),
        PROP("prop", Property.class),
        LINK("link", Link.class),
        PART("part", ControlPart.class);

        @NonNull
        private static final Map<Class<?>, TargetType> CLASS_TO_TYPE;
        @NonNull
        private static final Map<String, TargetType> NAME_TO_TYPE;
        @NonNull
        private final String fieldName;
        @NonNull
        private final Class<?> clazz;

        @Nullable
        public static TargetType forClass(@NonNull Class<?> clazz) {
            TargetType retval;
            Class<?> target = clazz;
            while ((retval = CLASS_TO_TYPE.get(target)) == null && (target = target.getSuperclass()) != null) {
            }
            return retval;
        }

        @Nullable
        public static TargetType forFieldName(@Nullable String name) {
            return name == null ? null : NAME_TO_TYPE.get(name);
        }

        private TargetType(String fieldName, Class<?> clazz) {
            this.fieldName = fieldName;
            this.clazz = clazz;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        static {
            ConcurrentHashMap<Object, TargetType> map = new ConcurrentHashMap<Object, TargetType>();
            for (TargetType type : TargetType.values()) {
                map.put(type.getClazz(), type);
            }
            CLASS_TO_TYPE = CollectionUtil.unmodifiableMap(map);
            map = new ConcurrentHashMap();
            for (TargetType type : TargetType.values()) {
                map.put(type.fieldName(), type);
            }
            NAME_TO_TYPE = CollectionUtil.unmodifiableMap(map);
        }
    }
}

