/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.merge;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.ReferenceCountingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.DefaultResult;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.FilterNonSelectedVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.AbstractCatalogEntityVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.net.URI;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;

public class FlatteningStructuringVisitor
extends AbstractCatalogEntityVisitor<IIndexer, Void> {
    private static final FlatteningStructuringVisitor SINGLETON = new FlatteningStructuringVisitor();

    @SuppressFBWarnings(value={"SING_SINGLETON_GETTER_NOT_SYNCHRONIZED"}, justification="class initialization")
    public static FlatteningStructuringVisitor instance() {
        return SINGLETON;
    }

    @SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="public constructor allows for extension usecases")
    public FlatteningStructuringVisitor() {
        super((Set)ObjectUtils.notNull(EnumSet.of(IEntityItem.ItemType.GROUP, IEntityItem.ItemType.CONTROL)));
    }

    @Override
    protected Void newDefaultResult(IIndexer state) {
        return null;
    }

    @Override
    protected Void aggregateResults(Void first, Void second, IIndexer state) {
        return null;
    }

    @Override
    public Void visitCatalog(@NonNull IDocumentNodeItem catalogItem, IIndexer index) {
        index.resetSelectionStatus();
        index.setSelectionStatus((INodeItem)catalogItem, IIndexer.SelectionStatus.SELECTED);
        super.visitCatalog(catalogItem, index);
        for (IEntityItem.ItemType itemType : IEntityItem.ItemType.values()) {
            assert (itemType != null);
            for (IEntityItem item : index.getEntitiesByItemType(itemType)) {
                item.resetReferenceCount();
            }
        }
        URI catalogUri = (URI)ObjectUtils.requireNonNull((Object)catalogItem.getDocumentUri());
        ReferenceCountingVisitor.instance().visitCatalog(catalogItem, index, catalogUri);
        FlatteningFilterNonSelectedVisitor.instance().visitCatalog(catalogItem, index);
        return null;
    }

    @Override
    public Void visitGroup(IAssemblyNodeItem item, Void childResult, IIndexer index) {
        CatalogGroup group = (CatalogGroup)ObjectUtils.requireNonNull((Object)((CatalogGroup)item.getValue()));
        String id = group.getId();
        if (id != null) {
            IEntityItem entity = index.getEntity(IEntityItem.ItemType.GROUP, id);
            assert (entity != null);
            entity.setInstance((IModelNodeItem<?, ?>)item);
        }
        index.setSelectionStatus((INodeItem)item, IIndexer.SelectionStatus.UNSELECTED);
        FlatteningStructuringVisitor.handlePartSelection(item, index, IIndexer.SelectionStatus.UNSELECTED);
        return super.visitGroup(item, childResult, index);
    }

    @Override
    public Void visitControl(IAssemblyNodeItem item, Void childResult, IIndexer index) {
        Control control = (Control)ObjectUtils.requireNonNull((Object)((Control)item.getValue()));
        String id = (String)ObjectUtils.requireNonNull((Object)control.getId());
        IEntityItem entity = index.getEntity(IEntityItem.ItemType.CONTROL, id);
        assert (entity != null);
        entity.setInstance((IModelNodeItem<?, ?>)item);
        index.setSelectionStatus((INodeItem)item, IIndexer.SelectionStatus.SELECTED);
        FlatteningStructuringVisitor.handlePartSelection(item, index, IIndexer.SelectionStatus.SELECTED);
        return null;
    }

    @Override
    protected Void visitParameter(IAssemblyNodeItem item, IAssemblyNodeItem catalogOrGroupOrControl, IIndexer index) {
        Parameter parameter = (Parameter)ObjectUtils.requireNonNull((Object)((Parameter)item.getValue()));
        String id = (String)ObjectUtils.requireNonNull((Object)parameter.getId());
        IEntityItem entity = index.getEntity(IEntityItem.ItemType.PARAMETER, id);
        assert (entity != null);
        entity.setInstance((IModelNodeItem<?, ?>)item);
        return null;
    }

    @Override
    protected void visitRole(IAssemblyNodeItem item, IAssemblyNodeItem metadataItem, IIndexer index) {
        Metadata.Role role = (Metadata.Role)ObjectUtils.requireNonNull((Object)((Metadata.Role)item.getValue()));
        String id = (String)ObjectUtils.requireNonNull((Object)role.getId());
        IEntityItem entity = index.getEntity(IEntityItem.ItemType.ROLE, id);
        assert (entity != null);
        entity.setInstance((IModelNodeItem<?, ?>)item);
    }

    @Override
    protected void visitLocation(IAssemblyNodeItem item, IAssemblyNodeItem metadataItem, IIndexer index) {
        Metadata.Location location = (Metadata.Location)ObjectUtils.requireNonNull((Object)((Metadata.Location)item.getValue()));
        UUID uuid = (UUID)ObjectUtils.requireNonNull((Object)location.getUuid());
        IEntityItem entity = index.getEntity(IEntityItem.ItemType.LOCATION, uuid);
        assert (entity != null);
        entity.setInstance((IModelNodeItem<?, ?>)item);
    }

    @Override
    protected void visitParty(IAssemblyNodeItem item, IAssemblyNodeItem metadataItem, IIndexer index) {
        Metadata.Party location = (Metadata.Party)ObjectUtils.requireNonNull((Object)((Metadata.Party)item.getValue()));
        UUID uuid = (UUID)ObjectUtils.requireNonNull((Object)location.getUuid());
        IEntityItem entity = index.getEntity(IEntityItem.ItemType.PARTY, uuid);
        assert (entity != null);
        entity.setInstance((IModelNodeItem<?, ?>)item);
    }

    @Override
    protected void visitResource(IAssemblyNodeItem item, IRootAssemblyNodeItem rootItem, IIndexer index) {
        BackMatter.Resource location = (BackMatter.Resource)ObjectUtils.requireNonNull((Object)((BackMatter.Resource)item.getValue()));
        UUID uuid = (UUID)ObjectUtils.requireNonNull((Object)location.getUuid());
        IEntityItem entity = index.getEntity(IEntityItem.ItemType.RESOURCE, uuid);
        assert (entity != null);
        entity.setInstance((IModelNodeItem<?, ?>)item);
    }

    private static void handlePartSelection(@NonNull IAssemblyNodeItem groupOrControlItem, @NonNull IIndexer index, @NonNull IIndexer.SelectionStatus selectionStatus) {
        CHILD_PART_METAPATH.evaluate((IItem)groupOrControlItem).stream().map(item -> (IAssemblyNodeItem)item).forEachOrdered(partItem -> {
            index.setSelectionStatus((INodeItem)ObjectUtils.requireNonNull((Object)partItem), selectionStatus);
            ControlPart part = (ControlPart)ObjectUtils.requireNonNull((Object)((ControlPart)partItem.getValue()));
            String id = part.getId();
            if (id != null) {
                IEntityItem entity = index.getEntity(IEntityItem.ItemType.PART, id);
                assert (entity != null);
                entity.setInstance((IModelNodeItem<?, ?>)partItem);
            }
        });
    }

    private static final class FlatteningFilterNonSelectedVisitor
    extends FilterNonSelectedVisitor {
        private static final FlatteningFilterNonSelectedVisitor SINGLETON = new FlatteningFilterNonSelectedVisitor();

        private FlatteningFilterNonSelectedVisitor() {
        }

        @SuppressFBWarnings(value={"SING_SINGLETON_GETTER_NOT_SYNCHRONIZED"}, justification="class initialization")
        public static FlatteningFilterNonSelectedVisitor instance() {
            return SINGLETON;
        }

        @Override
        public DefaultResult visitControl(IAssemblyNodeItem item, DefaultResult childResult, FilterNonSelectedVisitor.Context context) {
            assert (childResult != null);
            Control control = (Control)ObjectUtils.requireNonNull((Object)((Control)item.getValue()));
            IIndexer index = context.getIndexer();
            IEntityItem entity = (IEntityItem)ObjectUtils.requireNonNull((Object)index.getEntity(IEntityItem.ItemType.CONTROL, (String)ObjectUtils.requireNonNull((Object)control.getId()), false));
            IAssemblyNodeItem parent = (IAssemblyNodeItem)ObjectUtils.notNull((Object)item.getParentContentNodeItem());
            DefaultResult retval = new DefaultResult();
            if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)item))) {
                retval.promoteControl(control);
                retval.appendPromoted(childResult);
                childResult.applyRemovesTo(control);
                if (parent.getValue() instanceof Control && IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)parent))) {
                    retval.removeControl(control);
                }
            } else {
                if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)parent))) {
                    retval.removeControl(control);
                }
                retval.appendPromoted((DefaultResult)ObjectUtils.notNull((Object)childResult));
                index.removeItem(entity);
                FlatteningFilterNonSelectedVisitor.removePartsFromIndex(item, index);
            }
            return retval;
        }
    }
}

