/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.policy;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.ICustomReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IIdentifierParser;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.ReferenceCountingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCustomReferencePolicy<TYPE>
implements ICustomReferencePolicy<TYPE> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractCustomReferencePolicy.class);
    @NonNull
    private final IIdentifierParser identifierParser;

    protected AbstractCustomReferencePolicy(@NonNull IIdentifierParser identifierParser) {
        this.identifierParser = identifierParser;
    }

    @Override
    @NonNull
    public IIdentifierParser getIdentifierParser() {
        return this.identifierParser;
    }

    @NonNull
    protected abstract List<IEntityItem.ItemType> getEntityItemTypes(@NonNull TYPE var1);

    protected boolean handleIndexHit(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE reference, @NonNull IEntityItem item, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        if (visitorContext.getIndexer().isSelected(item)) {
            if (!visitorContext.isResolved(item)) {
                ReferenceCountingVisitor.instance().resolveEntity(item, visitorContext);
            }
            item.incrementReferenceCount();
            if (item.isIdentifierReassigned()) {
                String referenceText = (String)ObjectUtils.notNull((Object)this.getReferenceText(reference));
                String newReferenceText = this.getIdentifierParser().update(referenceText, item.getIdentifier());
                this.setReferenceText(reference, newReferenceText);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().log("Mapping {} reference '{}' to '{}'.", (Object)item.getItemType().name(), (Object)referenceText, (Object)newReferenceText);
                }
            }
            this.handleSelected(contextItem, reference, item, visitorContext);
        } else {
            this.handleUnselected(contextItem, reference, item, visitorContext);
        }
        return true;
    }

    protected void handleUnselected(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE reference, @NonNull IEntityItem item, @NonNull ReferenceCountingVisitor.Context visitorContext) {
    }

    protected void handleSelected(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE reference, @NonNull IEntityItem item, @NonNull ReferenceCountingVisitor.Context visitorContext) {
    }

    protected boolean handleIndexMiss(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE reference, @NonNull List<IEntityItem.ItemType> itemTypes, @NonNull String identifier, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        return false;
    }

    protected boolean handleIdentifierNonMatch(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE reference, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        return false;
    }

    @Override
    public boolean handleReference(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE type, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        String referenceText = this.getReferenceText(type);
        return referenceText == null || this.handleIdentifier(contextItem, type, this.getIdentifierParser().parse(referenceText), visitorContext);
    }

    protected boolean handleIdentifier(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull TYPE type, @Nullable String identifier, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        boolean retval;
        if (identifier == null) {
            retval = this.handleIdentifierNonMatch(contextItem, type, visitorContext);
        } else {
            List<IEntityItem.ItemType> itemTypes = this.getEntityItemTypes(type);
            IEntityItem item = null;
            for (IEntityItem.ItemType itemType : itemTypes) {
                assert (itemType != null);
                item = visitorContext.getEntity(itemType, identifier);
                if (item == null) continue;
                break;
            }
            retval = item == null ? this.handleIndexMiss(contextItem, type, itemTypes, identifier, visitorContext) : this.handleIndexHit(contextItem, type, item, visitorContext);
        }
        return retval;
    }
}

