/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.policy;

import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.format.IPathFormatter;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.AbstractCustomReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IIdentifierParser;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.ReferenceCountingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnchorReferencePolicy
extends AbstractCustomReferencePolicy<InlineLinkNode> {
    private static final Logger LOGGER = LogManager.getLogger(AnchorReferencePolicy.class);

    public AnchorReferencePolicy() {
        super(IIdentifierParser.FRAGMENT_PARSER);
    }

    @Override
    protected List<IEntityItem.ItemType> getEntityItemTypes(@NonNull InlineLinkNode link) {
        return List.of(IEntityItem.ItemType.RESOURCE, IEntityItem.ItemType.CONTROL, IEntityItem.ItemType.GROUP, IEntityItem.ItemType.PART);
    }

    @Override
    public String getReferenceText(@NonNull InlineLinkNode link) {
        return link.getUrl().toString();
    }

    @Override
    public void setReferenceText(@NonNull InlineLinkNode link, @NonNull String newValue) {
        link.setUrl(BasedSequence.of((CharSequence)newValue));
    }

    @Override
    protected void handleUnselected(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull InlineLinkNode link, @NonNull IEntityItem item, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        URI linkHref = URI.create(link.getUrl().toString());
        URI sourceUri = item.getSource();
        URI resolved = sourceUri.resolve(linkHref);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().log("At path '{}', remapping orphaned URI '{}' to '{}'", (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER), (Object)linkHref.toString(), (Object)resolved.toString());
        }
        link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)resolved.toString()));
    }

    @Override
    protected boolean handleIndexMiss(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull InlineLinkNode reference, @NonNull List<IEntityItem.ItemType> itemTypes, @NonNull String identifier, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.atError().log("The anchor at '{}' should reference a {} identified by '{}', but the identifier was not found in the index.", (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER), itemTypes.stream().map(en -> en.name().toLowerCase(Locale.ROOT)).collect(CustomCollectors.joiningWithOxfordComma((String)"or")), (Object)identifier);
        }
        return true;
    }

    @Override
    protected boolean handleIdentifierNonMatch(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull InlineLinkNode reference, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("Ignoring URI '{}' at '{}'", (Object)reference.getUrl().toStringOrNull(), (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
        }
        return true;
    }
}

