/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.policy;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.format.IPathFormatter;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.AbstractMultiItemTypeReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IIdentifierParser;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.ReferenceCountingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinkReferencePolicy
extends AbstractMultiItemTypeReferencePolicy<Link> {
    private static final Logger LOGGER = LogManager.getLogger(LinkReferencePolicy.class);

    @NonNull
    public static LinkReferencePolicy create(@NonNull IEntityItem.ItemType itemType) {
        return LinkReferencePolicy.create(List.of(itemType));
    }

    @NonNull
    public static LinkReferencePolicy create(@NonNull List<IEntityItem.ItemType> itemTypes) {
        return new LinkReferencePolicy((List)CollectionUtil.requireNonEmpty(itemTypes, (String)"itemTypes"));
    }

    public LinkReferencePolicy(@NonNull List<IEntityItem.ItemType> itemTypes) {
        super(IIdentifierParser.FRAGMENT_PARSER, itemTypes);
    }

    @Override
    public String getReferenceText(@NonNull Link link) {
        return link.getHref().toString();
    }

    @Override
    public void setReferenceText(@NonNull Link link, @NonNull String newValue) {
        link.setHref(URI.create(newValue));
    }

    @Override
    protected void handleUnselected(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull Link link, @NonNull IEntityItem item, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        URI linkHref = link.getHref();
        URI sourceUri = item.getSource();
        URI resolved = sourceUri.resolve(linkHref);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().log("At path '{}', remapping orphaned URI '{}' to '{}'", (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER), (Object)linkHref.toString(), (Object)resolved.toString());
        }
        link.setHref(resolved);
    }

    @Override
    protected boolean handleIndexMiss(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull Link link, @NonNull List<IEntityItem.ItemType> itemTypes, @NonNull String identifier, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().log("The link at '{}' with rel '{}' should reference a {} identified by '{}'. The index did not contain the identifier.", (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER), (Object)link.getRel(), itemTypes.stream().map(en -> en.name().toLowerCase(Locale.ROOT)).collect(CustomCollectors.joiningWithOxfordComma((String)"or")), (Object)identifier);
        }
        return true;
    }

    @Override
    protected boolean handleIdentifierNonMatch(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull Link reference, @NonNull ReferenceCountingVisitor.Context visitorContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("Ignoring URI '{}' at '{}'", (Object)reference.getHref().toString(), (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
        }
        return true;
    }
}

