/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.policy;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionEvaluationException;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IIdentifierParser;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternIdentifierParser
implements IIdentifierParser {
    private final Pattern pattern;
    private final int identifierGroup;

    public PatternIdentifierParser(@NonNull String pattern, int identifierGroup) {
        this(Pattern.compile(pattern), identifierGroup);
    }

    public PatternIdentifierParser(@NonNull Pattern pattern, int identifierGroup) {
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.identifierGroup = identifierGroup;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getIdentifierGroup() {
        return this.identifierGroup;
    }

    @Override
    public String parse(@NonNull String referenceText) {
        Matcher matcher = this.getPattern().matcher(referenceText);
        String retval = null;
        if (matcher.matches()) {
            retval = matcher.group(this.getIdentifierGroup());
        }
        return retval;
    }

    @Override
    public String update(@NonNull String referenceText, @NonNull String newIdentifier) {
        Matcher matcher = this.getPattern().matcher(referenceText);
        if (!matcher.matches()) {
            throw new ProfileResolutionEvaluationException(String.format("The original reference '%s' did not match the pattern '%s'.", referenceText, this.getPattern().pattern()));
        }
        return (String)ObjectUtils.notNull((Object)new StringBuilder(referenceText).replace(matcher.start(this.getIdentifierGroup()), matcher.end(this.getIdentifierGroup()), newIdentifier).toString());
    }
}

