/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.policy;

import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.util.ast.Node;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.datatype.markup.IMarkupString;
import gov.nist.secauto.metaschema.core.datatype.markup.flexmark.InsertAnchorExtension;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.format.IPathFormatter;
import gov.nist.secauto.metaschema.core.metapath.function.library.FnData;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.atomic.IMarkupItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IFieldNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalBindingContext;
import gov.nist.secauto.oscal.lib.OscalModelConstants;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractProperty;
import gov.nist.secauto.oscal.lib.model.metadata.IProperty;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.AnchorReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IIdentifierParser;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.IReferenceVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.InsertReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.LinkReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.PropertyReferencePolicy;
import gov.nist.secauto.oscal.lib.profile.resolver.support.AbstractCatalogEntityVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ReferenceCountingVisitor
extends AbstractCatalogEntityVisitor<Context, Void>
implements IReferenceVisitor<Context> {
    private static final Logger LOGGER = LogManager.getLogger(ReferenceCountingVisitor.class);
    private static final ReferenceCountingVisitor SINGLETON = new ReferenceCountingVisitor();
    @NonNull
    private static final MetapathExpression PARAM_MARKUP_METAPATH = MetapathExpression.compile((String)"label|usage|constraint/(description|tests/remarks)|guideline/prose|select/choice|remarks", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression ROLE_MARKUP_METAPATH = MetapathExpression.compile((String)"title|description|remarks", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression LOCATION_MARKUP_METAPATH = MetapathExpression.compile((String)"title|remarks", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression PARTY_MARKUP_METAPATH = MetapathExpression.compile((String)"title|remarks", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression RESOURCE_MARKUP_METAPATH = MetapathExpression.compile((String)"title|description|remarks", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final IReferencePolicy<Property> PROPERTY_POLICY_IGNORE = IReferencePolicy.ignore();
    @NonNull
    private static final IReferencePolicy<Link> LINK_POLICY_IGNORE = IReferencePolicy.ignore();
    @NonNull
    private static final Map<QName, IReferencePolicy<Property>> PROPERTY_POLICIES;
    @NonNull
    private static final Map<String, IReferencePolicy<Link>> LINK_POLICIES;
    @NonNull
    private static final InsertReferencePolicy INSERT_POLICY;
    @NonNull
    private static final AnchorReferencePolicy ANCHOR_POLICY;

    @SuppressFBWarnings(value={"SING_SINGLETON_GETTER_NOT_SYNCHRONIZED"}, justification="class initialization")
    public static ReferenceCountingVisitor instance() {
        return SINGLETON;
    }

    private ReferenceCountingVisitor() {
        super((Set)ObjectUtils.notNull(EnumSet.complementOf(EnumSet.of(IEntityItem.ItemType.PART, new IEntityItem.ItemType[]{IEntityItem.ItemType.ROLE, IEntityItem.ItemType.LOCATION, IEntityItem.ItemType.PARTY, IEntityItem.ItemType.PARAMETER, IEntityItem.ItemType.RESOURCE}))));
    }

    @Override
    protected Void newDefaultResult(Context context) {
        return null;
    }

    @Override
    protected Void aggregateResults(Void first, Void second, Context context) {
        return null;
    }

    public void visitCatalog(@NonNull IDocumentNodeItem catalogItem, @NonNull IIndexer indexer, @NonNull URI baseUri) {
        Context context = new Context(indexer, baseUri);
        this.visitCatalog(catalogItem, context);
        IIndexer index = context.getIndexer();
        IIndexer.getReferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.ROLE)).forEachOrdered(item -> ReferenceCountingVisitor.resolveEntity((IEntityItem)ObjectUtils.notNull((Object)item), context, ReferenceCountingVisitor::resolveRole));
        IIndexer.getReferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.LOCATION)).forEachOrdered(item -> ReferenceCountingVisitor.resolveEntity((IEntityItem)ObjectUtils.notNull((Object)item), context, ReferenceCountingVisitor::resolveLocation));
        IIndexer.getReferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.PARTY)).forEachOrdered(item -> ReferenceCountingVisitor.resolveEntity((IEntityItem)ObjectUtils.notNull((Object)item), context, ReferenceCountingVisitor::resolveParty));
        IIndexer.getReferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.PARAMETER)).forEachOrdered(item -> ReferenceCountingVisitor.resolveEntity((IEntityItem)ObjectUtils.notNull((Object)item), context, ReferenceCountingVisitor::resolveParameter));
        IIndexer.getReferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.RESOURCE)).forEachOrdered(item -> ReferenceCountingVisitor.resolveEntity((IEntityItem)ObjectUtils.notNull((Object)item), context, ReferenceCountingVisitor::resolveResource));
    }

    @Override
    public Void visitGroup(IAssemblyNodeItem item, Void childResult, Context context) {
        IIndexer index = context.getIndexer();
        if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)item))) {
            boolean resolve;
            CatalogGroup group = (CatalogGroup)ObjectUtils.requireNonNull((Object)((CatalogGroup)item.getValue()));
            String id = group.getId();
            if (id == null) {
                resolve = true;
            } else {
                IEntityItem entity = index.getEntity(IEntityItem.ItemType.GROUP, id, false);
                if (entity != null && !context.isResolved(entity)) {
                    context.markResolved(entity);
                    resolve = true;
                } else {
                    resolve = false;
                }
            }
            if (resolve) {
                this.resolveGroup(item, context);
            }
        }
        return null;
    }

    @Override
    public Void visitControl(IAssemblyNodeItem item, Void childResult, Context context) {
        IIndexer index = context.getIndexer();
        if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)item))) {
            Control control = (Control)ObjectUtils.requireNonNull((Object)((Control)item.getValue()));
            IEntityItem entity = context.getIndexer().getEntity(IEntityItem.ItemType.CONTROL, (String)ObjectUtils.notNull((Object)control.getId()), false);
            assert (entity != null);
            if (!context.isResolved(entity)) {
                context.markResolved(entity);
                if (IIndexer.SelectionStatus.SELECTED.equals((Object)context.getIndexer().getSelectionStatus((INodeItem)item))) {
                    this.resolveControl(item, context);
                }
            }
        }
        return null;
    }

    @Override
    protected void visitParts(IAssemblyNodeItem groupOrControlItem, Context context) {
        CHILD_PART_METAPATH.evaluate((IItem)groupOrControlItem).stream().map(item -> (IAssemblyNodeItem)item).forEachOrdered(partItem -> this.visitPart((IAssemblyNodeItem)ObjectUtils.notNull((Object)partItem), groupOrControlItem, context));
    }

    @Override
    protected void visitPart(IAssemblyNodeItem item, IAssemblyNodeItem groupOrControlItem, Context context) {
        boolean resolve;
        assert (context != null);
        ControlPart part = (ControlPart)ObjectUtils.requireNonNull((Object)((ControlPart)item.getValue()));
        String id = part.getId();
        if (id == null) {
            resolve = true;
        } else {
            IEntityItem entity = context.getIndexer().getEntity(IEntityItem.ItemType.PART, id, false);
            if (entity != null && !context.isResolved(entity)) {
                context.markResolved(entity);
                resolve = true;
            } else {
                resolve = false;
            }
        }
        if (resolve) {
            ReferenceCountingVisitor.resolvePart(item, context);
        }
    }

    protected void resolveGroup(@NonNull IAssemblyNodeItem item, @NonNull Context context) {
        if (IIndexer.SelectionStatus.SELECTED.equals((Object)context.getIndexer().getSelectionStatus((INodeItem)item))) {
            item.getModelItemsByName(OscalModelConstants.QNAME_TITLE).forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
            item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
            item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
            this.visitParts(item, context);
        }
    }

    protected void resolveControl(@NonNull IAssemblyNodeItem item, @NonNull Context context) {
        item.getModelItemsByName(OscalModelConstants.QNAME_TITLE).forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        this.visitParts(item, context);
    }

    private static void resolveRole(@NonNull IEntityItem entity, @NonNull Context context) {
        IModelNodeItem<?, ?> item = entity.getInstance();
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        ROLE_MARKUP_METAPATH.evaluate(item).getValue().forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
    }

    private static void resolveParty(@NonNull IEntityItem entity, @NonNull Context context) {
        IModelNodeItem<?, ?> item = entity.getInstance();
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        PARTY_MARKUP_METAPATH.evaluate(item).getValue().forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
    }

    public static void resolveLocation(@NonNull IEntityItem entity, @NonNull Context context) {
        IModelNodeItem<?, ?> item = entity.getInstance();
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        LOCATION_MARKUP_METAPATH.evaluate(item).getValue().forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
    }

    public static void resolveResource(@NonNull IEntityItem entity, @NonNull Context context) {
        IModelNodeItem<?, ?> item = entity.getInstance();
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_CITATION).forEach(child -> {
            if (child != null) {
                child.getModelItemsByName(OscalModelConstants.QNAME_TEXT).forEach(citationChild -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)citationChild)), context));
                child.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(citationChild -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)citationChild)), context));
                child.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(citationChild -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)citationChild)), context));
            }
        });
        RESOURCE_MARKUP_METAPATH.evaluate(item).getValue().forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
    }

    public static void resolveParameter(@NonNull IEntityItem entity, @NonNull Context context) {
        IModelNodeItem<?, ?> item = entity.getInstance();
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        PARAM_MARKUP_METAPATH.evaluate(item).getValue().forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
    }

    private static void resolvePart(@NonNull IAssemblyNodeItem item, @NonNull Context context) {
        item.getModelItemsByName(OscalModelConstants.QNAME_TITLE).forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_PROP).forEach(child -> ReferenceCountingVisitor.handleProperty((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_LINK).forEach(child -> ReferenceCountingVisitor.handleLink((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)child)), context));
        item.getModelItemsByName(OscalModelConstants.QNAME_PROSE).forEach(child -> ReferenceCountingVisitor.handleMarkup((IFieldNodeItem)ObjectUtils.notNull((Object)((IFieldNodeItem)child)), context));
    }

    private static void handleMarkup(@NonNull IFieldNodeItem item, @NonNull Context context) {
        IMarkupItem markupItem = (IMarkupItem)FnData.fnDataItem((IItem)item);
        IMarkupString markup = markupItem.asMarkup();
        ReferenceCountingVisitor.handleMarkup(item, markup, context);
    }

    private static void handleMarkup(@NonNull IFieldNodeItem contextItem, @NonNull IMarkupString<?> text, @NonNull Context context) {
        for (Node node : CollectionUtil.toIterable((Iterator)((Iterator)ObjectUtils.notNull(text.getNodesAsStream().iterator())))) {
            if (node instanceof InsertAnchorExtension.InsertAnchorNode) {
                ReferenceCountingVisitor.handleInsert(contextItem, (InsertAnchorExtension.InsertAnchorNode)node, context);
                continue;
            }
            if (!(node instanceof InlineLinkNode)) continue;
            ReferenceCountingVisitor.handleAnchor(contextItem, (InlineLinkNode)node, context);
        }
    }

    private static void handleInsert(@NonNull IFieldNodeItem contextItem, @NonNull InsertAnchorExtension.InsertAnchorNode node, @NonNull Context context) {
        boolean retval = INSERT_POLICY.handleReference((IModelNodeItem<?, ?>)contextItem, node, context);
        if (LOGGER.isWarnEnabled() && !retval) {
            LOGGER.atWarn().log("Unsupported insert type '{}' at '{}'", (Object)node.getType().toString(), (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
        }
    }

    private static void handleAnchor(@NonNull IFieldNodeItem contextItem, @NonNull InlineLinkNode node, @NonNull Context context) {
        boolean result = ANCHOR_POLICY.handleReference((IModelNodeItem<?, ?>)contextItem, node, context);
        if (LOGGER.isWarnEnabled() && !result) {
            LOGGER.atWarn().log("Unsupported anchor with href '{}' at '{}'", (Object)node.getUrl().toString(), (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
        }
    }

    private static void handleProperty(@NonNull IAssemblyNodeItem item, @NonNull Context context) {
        boolean result;
        Property property = (Property)ObjectUtils.requireNonNull((Object)((Property)item.getValue()));
        QName qname = property.getQName();
        IReferencePolicy<Property> policy = PROPERTY_POLICIES.get(qname);
        boolean bl = result = policy != null && policy.handleReference((IModelNodeItem<?, ?>)item, property, context);
        if (LOGGER.isWarnEnabled() && !result) {
            LOGGER.atWarn().log("Unsupported property '{}' at '{}'", (Object)property.getQName(), (Object)item.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
        }
    }

    private static void handleLink(@NonNull IAssemblyNodeItem item, @NonNull Context context) {
        boolean result;
        Link link = (Link)ObjectUtils.requireNonNull((Object)((Link)item.getValue()));
        IReferencePolicy<Link> policy = null;
        String rel = link.getRel();
        if (rel != null) {
            policy = LINK_POLICIES.get(rel);
        }
        boolean bl = result = policy != null && policy.handleReference((IModelNodeItem<?, ?>)item, link, context);
        if (LOGGER.isWarnEnabled() && !result) {
            LOGGER.atWarn().log("unsupported link rel '{}' at '{}'", (Object)link.getRel(), (Object)item.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
        }
    }

    protected static void resolveEntity(@NonNull IEntityItem entity, @NonNull Context context, @NonNull BiConsumer<IEntityItem, Context> handler) {
        if (!context.isResolved(entity)) {
            context.markResolved(entity);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("Resolving {} identified as '{}'", (Object)entity.getItemType().name(), (Object)entity.getIdentifier());
            }
            if (!IIndexer.SelectionStatus.UNSELECTED.equals((Object)context.getIndexer().getSelectionStatus((INodeItem)entity.getInstance()))) {
                handler.accept(entity, context);
            }
        }
    }

    public void resolveEntity(@NonNull IEntityItem entity, @NonNull Context context) {
        ReferenceCountingVisitor.resolveEntity(entity, context, (theEntity, theContext) -> this.entityDispatch((IEntityItem)ObjectUtils.notNull((Object)theEntity), (Context)ObjectUtils.notNull((Object)theContext)));
    }

    protected void entityDispatch(@NonNull IEntityItem entity, @NonNull Context context) {
        IAssemblyNodeItem item = (IAssemblyNodeItem)entity.getInstance();
        switch (entity.getItemType()) {
            case CONTROL: {
                this.resolveControl(item, context);
                break;
            }
            case GROUP: {
                this.resolveGroup(item, context);
                break;
            }
            case LOCATION: {
                ReferenceCountingVisitor.resolveLocation(entity, context);
                break;
            }
            case PARAMETER: {
                ReferenceCountingVisitor.resolveParameter(entity, context);
                break;
            }
            case PART: {
                ReferenceCountingVisitor.resolvePart(item, context);
                break;
            }
            case PARTY: {
                ReferenceCountingVisitor.resolveParty(entity, context);
                break;
            }
            case RESOURCE: {
                ReferenceCountingVisitor.resolveResource(entity, context);
                break;
            }
            case ROLE: {
                ReferenceCountingVisitor.resolveRole(entity, context);
                break;
            }
            default: {
                throw new UnsupportedOperationException(entity.getItemType().name());
            }
        }
    }

    static {
        INSERT_POLICY = new InsertReferencePolicy();
        ANCHOR_POLICY = new AnchorReferencePolicy();
        PROPERTY_POLICIES = new HashMap<QName, IReferencePolicy<Property>>();
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "resolution-tool"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "label"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "sort-id"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "alt-label"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "alt-identifier"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "method"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.OSCAL_NAMESPACE, "keep"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.RMF_NAMESPACE, "method"), PROPERTY_POLICY_IGNORE);
        PROPERTY_POLICIES.put(AbstractProperty.qname(IProperty.RMF_NAMESPACE, "aggregates"), PropertyReferencePolicy.create(IIdentifierParser.IDENTITY_PARSER, IEntityItem.ItemType.PARAMETER));
        LINK_POLICIES = new HashMap<String, IReferencePolicy<Link>>();
        LINK_POLICIES.put("source-profile", LINK_POLICY_IGNORE);
        LINK_POLICIES.put("citation", LinkReferencePolicy.create(IEntityItem.ItemType.RESOURCE));
        LINK_POLICIES.put("reference", LinkReferencePolicy.create(IEntityItem.ItemType.RESOURCE));
        LINK_POLICIES.put("related", LinkReferencePolicy.create(IEntityItem.ItemType.CONTROL));
        LINK_POLICIES.put("required", LinkReferencePolicy.create(IEntityItem.ItemType.CONTROL));
        LINK_POLICIES.put("corresp", LinkReferencePolicy.create(IEntityItem.ItemType.PART));
    }

    public static final class Context {
        @NonNull
        private final IIndexer indexer;
        @NonNull
        private final URI source;
        @NonNull
        private final Set<IEntityItem> resolvedEntities = new HashSet<IEntityItem>();

        private Context(@NonNull IIndexer indexer, @NonNull URI source) {
            this.indexer = indexer;
            this.source = source;
        }

        @NonNull
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intending to expose this field")
        public IIndexer getIndexer() {
            return this.indexer;
        }

        @Nullable
        public IEntityItem getEntity(@NonNull IEntityItem.ItemType itemType, @NonNull String identifier) {
            return this.getIndexer().getEntity(itemType, identifier);
        }

        @NonNull
        private URI getSource() {
            return this.source;
        }

        public void markResolved(@NonNull IEntityItem entity) {
            this.resolvedEntities.add(entity);
        }

        public boolean isResolved(@NonNull IEntityItem entity) {
            return this.resolvedEntities.contains(entity);
        }

        public void incrementReferenceCount(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull IEntityItem.ItemType type, @NonNull UUID identifier) {
            this.incrementReferenceCountInternal(contextItem, type, (String)ObjectUtils.notNull((Object)identifier.toString()), false);
        }

        public void incrementReferenceCount(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull IEntityItem.ItemType type, @NonNull String identifier) {
            this.incrementReferenceCountInternal(contextItem, type, identifier, type.isUuid());
        }

        private void incrementReferenceCountInternal(@NonNull IModelNodeItem<?, ?> contextItem, @NonNull IEntityItem.ItemType type, @NonNull String identifier, boolean normalize) {
            IEntityItem item = this.getIndexer().getEntity(type, identifier, normalize);
            if (item == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().log("Unknown reference to {} '{}' at '{}'", (Object)type.toString().toLowerCase(Locale.ROOT), (Object)identifier, (Object)contextItem.toPath(IPathFormatter.METAPATH_PATH_FORMATER));
                }
            } else {
                item.incrementReferenceCount();
            }
        }
    }
}

