/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.format.IPathFormatter;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalBindingContext;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IControlFilter;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IControlSelectionState;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;

public class ControlSelectionState
implements IControlSelectionState {
    private static final MetapathExpression GROUP_CHILDREN = MetapathExpression.compile((String)"group|descendant::control", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private final IIndexer index;
    @NonNull
    private final IControlFilter filter;
    @NonNull
    private final Map<IModelNodeItem<?, ?>, SelectionState> itemSelectionState = new ConcurrentHashMap();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="provides intentional access to index state")
    public ControlSelectionState(@NonNull IIndexer index, @NonNull IControlFilter filter) {
        this.index = index;
        this.filter = filter;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="provides intentional access to index state")
    public IIndexer getIndex() {
        return this.index;
    }

    @NonNull
    public IControlFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean isSelected(@NonNull IModelNodeItem<?, ?> item) {
        return this.getSelectionState(item).isSelected();
    }

    @NonNull
    protected SelectionState getSelectionState(@NonNull IModelNodeItem<?, ?> item) {
        SelectionState retval = this.itemSelectionState.get(item);
        if (retval == null) {
            Object itemValue = ObjectUtils.requireNonNull((Object)item.getValue());
            if (itemValue instanceof Control) {
                Control control = (Control)itemValue;
                IAssemblyNodeItem parentItem = (IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)item.getParentContentNodeItem());
                Object parentValue = parentItem.getValue();
                Control parentControl = parentValue instanceof Control ? (Control)parentValue : null;
                boolean defaultMatch = false;
                if (parentControl != null) {
                    SelectionState parentSelectionState = this.getSelectionState((IModelNodeItem<?, ?>)parentItem);
                    defaultMatch = parentSelectionState.isSelected() && parentSelectionState.isWithChildren();
                }
                Pair<Boolean, Boolean> matchResult = this.getFilter().match(control, defaultMatch);
                boolean selected = (Boolean)matchResult.getLeft();
                boolean withChildren = (Boolean)matchResult.getRight();
                retval = new SelectionState(selected, withChildren);
            } else if (itemValue instanceof CatalogGroup) {
                boolean selected = GROUP_CHILDREN.evaluate(item).stream().map(child -> this.getSelectionState((IModelNodeItem)ObjectUtils.requireNonNull((Object)child)).isSelected()).reduce(false, (first, second) -> first != false || second != false);
                retval = new SelectionState(selected, false);
            } else {
                throw new IllegalStateException(String.format("Selection not supported for type '%s' at path '%s'", itemValue.getClass().getName(), item.toPath(IPathFormatter.METAPATH_PATH_FORMATER)));
            }
            this.itemSelectionState.put(item, retval);
        }
        return retval;
    }

    private static final class SelectionState {
        private final boolean selected;
        private final boolean withChildren;

        private SelectionState(boolean selected, boolean withChildren) {
            this.selected = selected;
            this.withChildren = withChildren;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isWithChildren() {
            return this.selected && this.withChildren;
        }
    }
}

