/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IControlSelectionState;
import gov.nist.secauto.oscal.lib.profile.resolver.support.AbstractIndexingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ControlSelectionVisitor
extends AbstractIndexingVisitor<IControlSelectionState, Boolean> {
    private static final Logger LOGGER = LogManager.getLogger(ControlSelectionVisitor.class);
    private static final ControlSelectionVisitor SINGLETON = new ControlSelectionVisitor();

    @SuppressFBWarnings(value={"SING_SINGLETON_GETTER_NOT_SYNCHRONIZED"}, justification="class initialization")
    public static ControlSelectionVisitor instance() {
        return SINGLETON;
    }

    private ControlSelectionVisitor() {
    }

    @Override
    protected IIndexer getIndexer(IControlSelectionState state) {
        return state.getIndex();
    }

    @Override
    protected Boolean newDefaultResult(IControlSelectionState state) {
        return false;
    }

    @Override
    protected Boolean aggregateResults(Boolean first, Boolean second, IControlSelectionState state) {
        return first != false || second != false;
    }

    public void visit(@NonNull IDocumentNodeItem catalogDocument, @NonNull IControlSelectionState state) {
        this.visitCatalog(catalogDocument, state);
    }

    public void visitProfile(@NonNull IDocumentNodeItem catalogDocument, @NonNull IDocumentNodeItem profileDocument, @NonNull IControlSelectionState state) {
        this.visit(catalogDocument, state);
        profileDocument.modelItems().forEachOrdered(item -> {
            IRootAssemblyNodeItem root = (IRootAssemblyNodeItem)ObjectUtils.requireNonNull((Object)((IRootAssemblyNodeItem)item));
            this.visitMetadata(root, state);
            this.visitBackMatter(root, state);
        });
    }

    @Override
    public Boolean visitCatalog(IDocumentNodeItem catalogDocument, IControlSelectionState state) {
        this.getIndexer(state).setSelectionStatus((INodeItem)catalogDocument, IIndexer.SelectionStatus.SELECTED);
        return (Boolean)super.visitCatalog(catalogDocument, state);
    }

    @Override
    public Boolean visitGroup(IAssemblyNodeItem groupItem, Boolean childSelected, IControlSelectionState state) {
        super.visitGroup(groupItem, childSelected, state);
        if (LOGGER.isTraceEnabled()) {
            CatalogGroup group = (CatalogGroup)ObjectUtils.requireNonNull((Object)((CatalogGroup)groupItem.getValue()));
            LOGGER.atTrace().log("Selecting group '{}'. match={}", (Object)group.getId(), (Object)childSelected);
        }
        assert (state.isSelected((IModelNodeItem<?, ?>)groupItem) == childSelected.booleanValue());
        if (childSelected.booleanValue()) {
            this.getIndexer(state).setSelectionStatus((INodeItem)groupItem, IIndexer.SelectionStatus.SELECTED);
        } else {
            this.getIndexer(state).setSelectionStatus((INodeItem)groupItem, IIndexer.SelectionStatus.UNSELECTED);
        }
        this.handlePartSelection(groupItem, childSelected, state);
        return childSelected;
    }

    private void handlePartSelection(@NonNull IAssemblyNodeItem groupOrControlItem, boolean selected, IControlSelectionState state) {
        if (this.isVisitedItemType(IEntityItem.ItemType.PART)) {
            IIndexer.SelectionStatus selectionStatus = selected ? IIndexer.SelectionStatus.SELECTED : IIndexer.SelectionStatus.UNSELECTED;
            IIndexer index = this.getIndexer(state);
            CHILD_PART_METAPATH.evaluate((IItem)groupOrControlItem).stream().map(item -> (IAssemblyNodeItem)item).forEachOrdered(partItem -> index.setSelectionStatus((INodeItem)ObjectUtils.requireNonNull((Object)partItem), selectionStatus));
        }
    }

    @Override
    public Boolean visitControl(IAssemblyNodeItem controlItem, Boolean childResult, IControlSelectionState state) {
        super.visitControl(controlItem, childResult, state);
        boolean selected = state.isSelected((IModelNodeItem<?, ?>)controlItem);
        if (selected) {
            this.getIndexer(state).setSelectionStatus((INodeItem)controlItem, IIndexer.SelectionStatus.SELECTED);
        } else {
            this.getIndexer(state).setSelectionStatus((INodeItem)controlItem, IIndexer.SelectionStatus.UNSELECTED);
        }
        this.handlePartSelection(controlItem, selected, state);
        return selected;
    }
}

