/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Matching;
import gov.nist.secauto.oscal.lib.model.control.catalog.IControl;
import gov.nist.secauto.oscal.lib.model.control.profile.IProfileSelectControlById;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionEvaluationException;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IControlSelectionFilter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultControlSelectionFilter
implements IControlSelectionFilter {
    private static final Logger LOGGER = LogManager.getLogger(DefaultControlSelectionFilter.class);
    @NonNull
    private final List<Selection> selections;

    public DefaultControlSelectionFilter(@NonNull List<? extends IProfileSelectControlById> selections) {
        this.selections = selections.stream().filter(Objects::nonNull).map(Selection::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NonNull
    public Pair<Boolean, Boolean> apply(IControl control) {
        String id = control.getId();
        if (id == null) {
            throw new ProfileResolutionEvaluationException("control is missing an identifier");
        }
        return this.match(id);
    }

    @NonNull
    protected Pair<Boolean, Boolean> match(String id) {
        return this.selections.parallelStream().map(selection -> selection.match(id)).filter(Pair::getLeft).reduce((first, second) -> {
            Pair result;
            if (((Boolean)first.getLeft()).booleanValue() || ((Boolean)second.getLeft()).booleanValue()) {
                boolean withChild = (Boolean)first.getLeft() != false && (Boolean)first.getRight() != false || (Boolean)second.getLeft() != false && (Boolean)second.getRight() != false;
                result = Pair.of((Object)true, (Object)withChild);
            } else {
                result = NON_MATCH;
            }
            return result;
        }).orElse(NON_MATCH);
    }

    private static Pattern toPattern(@NonNull Matching matching) {
        String pattern = (String)ObjectUtils.requireNonNull((Object)matching.getPattern());
        String regex = pattern.chars().boxed().map(ch -> Character.valueOf((char)ch.intValue())).map(ch -> {
            Object value;
            switch (ch.charValue()) {
                case '*': {
                    value = ".*";
                    break;
                }
                case '?': {
                    value = ".";
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    value = "\\" + ch;
                    break;
                }
                default: {
                    value = String.valueOf(ch);
                }
            }
            return value;
        }).collect(Collectors.joining("", "^", "$"));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().log("regex: {}", (Object)regex);
        }
        return Pattern.compile(regex);
    }

    private static class Selection {
        private final boolean withChildControls;
        private final Set<String> identifiers;
        private final List<Pattern> patterns;

        public Selection(IProfileSelectControlById selection) {
            this.withChildControls = "yes".equals(selection.getWithChildControls());
            List<String> ids = selection.getWithIds();
            if (ids == null) {
                ids = Collections.emptyList();
            }
            this.identifiers = ids.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
            List<Matching> matching = selection.getMatching();
            if (matching == null) {
                matching = Collections.emptyList();
            }
            this.patterns = matching.stream().filter(Objects::nonNull).map(x$0 -> DefaultControlSelectionFilter.toPattern(x$0)).collect(Collectors.toUnmodifiableList());
        }

        public boolean isWithChildControls() {
            return this.withChildControls;
        }

        @NonNull
        protected Pair<Boolean, Boolean> match(String id) {
            boolean result = this.identifiers.stream().anyMatch(controlIdentifier -> controlIdentifier.equals(id));
            if (!result) {
                result = this.patterns.stream().anyMatch(pattern -> pattern.asMatchPredicate().test(id));
            }
            return (Pair)ObjectUtils.notNull((Object)Pair.of((Object)result, (Object)this.isWithChildControls()));
        }
    }
}

