/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultResult
implements IResult {
    private static final Logger LOGGER = LogManager.getLogger(DefaultResult.class);
    @NonNull
    private final Lazy<Set<Control>> promotedControls = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(LinkedHashSet::new));
    @NonNull
    private final Lazy<Set<Parameter>> promotedParameters = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(LinkedHashSet::new));
    @NonNull
    private final Lazy<Set<CatalogGroup>> removedGroups = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(HashSet::new));
    @NonNull
    private final Lazy<Set<Control>> removedControls = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(HashSet::new));
    @NonNull
    private final Lazy<Set<Parameter>> removedParameters = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(HashSet::new));

    @NonNull
    protected Collection<Parameter> getPromotedParameters() {
        return this.promotedParameters.getIfAvailable().orElse(Collections.emptySet());
    }

    @NonNull
    protected Collection<Control> getPromotedControls() {
        return this.promotedControls.getIfAvailable().orElse(Collections.emptySet());
    }

    @NonNull
    protected Collection<CatalogGroup> getRemovedGroups() {
        return this.removedGroups.getIfAvailable().orElse(Collections.emptySet());
    }

    @NonNull
    protected Collection<Control> getRemovedControls() {
        return this.removedControls.getIfAvailable().orElse(Collections.emptySet());
    }

    @NonNull
    protected Collection<Parameter> getRemovedParameters() {
        return this.removedParameters.getIfAvailable().orElse(Collections.emptySet());
    }

    @Override
    public void promoteParameter(@NonNull Parameter param) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("promoting parameter '{}'", (Object)param.getId());
        }
        ((Set)this.promotedParameters.get()).add(param);
    }

    @Override
    public void promoteControl(@NonNull Control control) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("promoting control '{}'", (Object)control.getId());
        }
        ((Set)this.promotedControls.get()).add(control);
    }

    @Override
    public void applyTo(@NonNull Catalog parent) {
        this.applyRemovesTo(parent);
        this.getPromotedParameters().forEach(param -> parent.addParam((Parameter)ObjectUtils.notNull((Object)param)));
        this.getPromotedControls().forEach(control -> {
            assert (control != null);
            parent.addControl((Control)control);
            control.setParentControl(null);
        });
    }

    @Override
    public void applyTo(@NonNull CatalogGroup parent) {
        this.applyRemovesTo(parent);
        this.getPromotedControls().forEach(control -> {
            assert (control != null);
            parent.addControl((Control)control);
            control.setParentControl(null);
        });
        this.getPromotedParameters().forEach(param -> parent.addParam((Parameter)ObjectUtils.notNull((Object)param)));
    }

    @Override
    public void applyTo(@NonNull Control parent) {
        this.applyRemovesTo(parent);
        this.getPromotedControls().forEach(control -> {
            assert (control != null);
            parent.addControl((Control)control);
            control.setParentControl(null);
        });
        this.getPromotedParameters().forEach(param -> parent.addParam((Parameter)ObjectUtils.notNull((Object)param)));
    }

    public void applyRemovesTo(Catalog parent) {
        DefaultResult.removeItems(parent.getGroups(), this.getRemovedGroups());
        DefaultResult.removeItems(parent.getControls(), this.getRemovedControls());
        DefaultResult.removeItems(parent.getParams(), this.getRemovedParameters());
    }

    public void applyRemovesTo(CatalogGroup parent) {
        DefaultResult.removeItems(parent.getGroups(), this.getRemovedGroups());
        DefaultResult.removeItems(parent.getControls(), this.getRemovedControls());
        DefaultResult.removeItems(parent.getParams(), this.getRemovedParameters());
    }

    public void applyRemovesTo(Control parent) {
        DefaultResult.removeItems(parent.getControls(), this.getRemovedControls());
        DefaultResult.removeItems(parent.getParams(), this.getRemovedParameters());
    }

    public DefaultResult append(@NonNull DefaultResult that) {
        DefaultResult.lazyAppend(this.promotedControls, that.promotedControls);
        DefaultResult.lazyAppend(this.promotedParameters, that.promotedParameters);
        DefaultResult.lazyAppend(this.removedGroups, that.removedGroups);
        DefaultResult.lazyAppend(this.removedControls, that.removedControls);
        DefaultResult.lazyAppend(this.removedParameters, that.removedParameters);
        return this;
    }

    public DefaultResult appendPromoted(@NonNull DefaultResult that) {
        DefaultResult.lazyAppend(this.promotedControls, that.promotedControls);
        DefaultResult.lazyAppend(this.promotedParameters, that.promotedParameters);
        return this;
    }

    protected static <T> void lazyAppend(@NonNull Lazy<Set<T>> self, @NonNull Lazy<Set<T>> other) {
        Set otherSet;
        if (other.isAvailable() && !(otherSet = (Set)other.get()).isEmpty()) {
            ((Set)self.get()).addAll(otherSet);
        }
    }

    protected static <T> void removeItems(List<T> list, @NonNull Collection<T> itemsToDelete) {
        itemsToDelete.forEach(item -> {
            if (!list.remove(item)) {
                LOGGER.atError().log("item didn't exist in list");
            }
        });
    }

    public void removeGroup(CatalogGroup group) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("Requesting removal of group '{}'.", (Object)group.getId());
        }
        ((Set)this.removedGroups.get()).add(group);
    }

    public void removeControl(Control control) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("Requesting removal of control '{}'.", (Object)control.getId());
        }
        ((Set)this.removedControls.get()).add(control);
    }

    public void removeParameter(Parameter parameter) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("Requesting removal of parameter '{}'.", (Object)parameter.getId());
        }
        ((Set)this.removedParameters.get()).add(parameter);
    }
}

