/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalModelConstants;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.DefaultResult;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IResult;
import gov.nist.secauto.oscal.lib.profile.resolver.support.AbstractCatalogEntityVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterNonSelectedVisitor
extends AbstractCatalogEntityVisitor<Context, DefaultResult> {
    private static final Logger LOGGER = LogManager.getLogger(FilterNonSelectedVisitor.class);
    @NonNull
    private static final FilterNonSelectedVisitor SINGLETON = new FilterNonSelectedVisitor();

    @NonNull
    @SuppressFBWarnings(value={"SING_SINGLETON_GETTER_NOT_SYNCHRONIZED"}, justification="class initialization")
    public static FilterNonSelectedVisitor instance() {
        return SINGLETON;
    }

    @SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="allows for extension")
    protected FilterNonSelectedVisitor() {
        super(EnumSet.of(IEntityItem.ItemType.GROUP, IEntityItem.ItemType.CONTROL, IEntityItem.ItemType.PARAMETER));
    }

    @Override
    public void visitCatalog(@NonNull IDocumentNodeItem catalogItem, @NonNull IIndexer indexer) {
        Context context = new Context(indexer);
        IResult result = (IResult)this.visitCatalog(catalogItem, context);
        Catalog catalog = (Catalog)INodeItem.toValue((INodeItem)catalogItem);
        result.applyTo(catalog);
        catalogItem.modelItems().forEachOrdered(root -> {
            root.getModelItemsByName(OscalModelConstants.QNAME_METADATA).stream().map(child -> (IAssemblyNodeItem)child).forEachOrdered(child -> {
                assert (child != null);
                this.visitMetadata((IAssemblyNodeItem)child, context);
            });
            root.getModelItemsByName(OscalModelConstants.QNAME_BACK_MATTER).stream().map(child -> (IAssemblyNodeItem)child).forEachOrdered(child -> {
                assert (child != null);
                this.visitBackMatter((IAssemblyNodeItem)child, context);
            });
        });
    }

    @Override
    protected DefaultResult newDefaultResult(Context state) {
        return new DefaultResult();
    }

    @Override
    protected DefaultResult aggregateResults(DefaultResult first, DefaultResult second, Context state) {
        return first.append((DefaultResult)ObjectUtils.notNull((Object)second));
    }

    protected void visitMetadata(@NonNull IAssemblyNodeItem metadataItem, Context context) {
        Metadata metadata = (Metadata)ObjectUtils.requireNonNull((Object)((Metadata)metadataItem.getValue()));
        IIndexer index = context.getIndexer();
        for (IEntityItem entity : IIndexer.getUnreferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.ROLE)).collect(Collectors.toList())) {
            Metadata.Role role = (Metadata.Role)entity.getInstanceValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("Removing role '{}'", (Object)role.getId());
            }
            metadata.removeRole(role);
            index.removeItem(entity);
        }
        for (IEntityItem entity : IIndexer.getUnreferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.PARTY)).collect(Collectors.toList())) {
            Metadata.Party party = (Metadata.Party)entity.getInstanceValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("Removing party '{}'", (Object)party.getUuid());
            }
            metadata.removeParty(party);
            index.removeItem(entity);
        }
        for (IEntityItem entity : IIndexer.getUnreferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.LOCATION)).collect(Collectors.toList())) {
            Metadata.Location location = (Metadata.Location)entity.getInstanceValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("Removing location '{}'", (Object)location.getUuid());
            }
            metadata.removeLocation(location);
            index.removeItem(entity);
        }
    }

    private void visitBackMatter(@NonNull IAssemblyNodeItem backMatterItem, Context context) {
        BackMatter backMatter = (BackMatter)ObjectUtils.requireNonNull((Object)((BackMatter)backMatterItem.getValue()));
        IIndexer index = context.getIndexer();
        for (IEntityItem entity : IIndexer.getUnreferencedEntitiesAsStream(index.getEntitiesByItemType(IEntityItem.ItemType.RESOURCE)).collect(Collectors.toList())) {
            BackMatter.Resource resource = (BackMatter.Resource)entity.getInstanceValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("Removing resource '{}'", (Object)resource.getUuid());
            }
            backMatter.removeResource(resource);
            index.removeItem(entity);
        }
    }

    @Override
    public DefaultResult visitGroup(IAssemblyNodeItem item, DefaultResult childResult, Context context) {
        CatalogGroup group = (CatalogGroup)ObjectUtils.requireNonNull((Object)((CatalogGroup)item.getValue()));
        IIndexer index = context.getIndexer();
        String groupId = group.getId();
        DefaultResult retval = new DefaultResult();
        if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)item))) {
            if (groupId != null) {
                IEntityItem entity = (IEntityItem)ObjectUtils.requireNonNull((Object)index.getEntity(IEntityItem.ItemType.GROUP, groupId, false));
                group.setId(entity.getIdentifier());
            }
            childResult.applyTo(group);
        } else {
            retval.removeGroup(group);
            retval.appendPromoted((DefaultResult)ObjectUtils.notNull((Object)childResult));
            if (groupId != null) {
                IEntityItem entity = (IEntityItem)ObjectUtils.requireNonNull((Object)index.getEntity(IEntityItem.ItemType.GROUP, groupId, false));
                index.removeItem(entity);
            }
            FilterNonSelectedVisitor.removePartsFromIndex(item, index);
        }
        return retval;
    }

    @Override
    public DefaultResult visitControl(IAssemblyNodeItem item, DefaultResult childResult, Context context) {
        Control control = (Control)ObjectUtils.requireNonNull((Object)((Control)item.getValue()));
        IIndexer index = context.getIndexer();
        IEntityItem entity = (IEntityItem)ObjectUtils.requireNonNull((Object)index.getEntity(IEntityItem.ItemType.CONTROL, (String)ObjectUtils.requireNonNull((Object)control.getId()), false));
        IAssemblyNodeItem parent = (IAssemblyNodeItem)ObjectUtils.notNull((Object)item.getParentContentNodeItem());
        DefaultResult retval = new DefaultResult();
        if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)item))) {
            control.setId(entity.getIdentifier());
            if (!IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)parent))) {
                retval.promoteControl(control);
            }
            childResult.applyTo(control);
        } else {
            if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)parent))) {
                retval.removeControl(control);
            }
            retval.appendPromoted((DefaultResult)ObjectUtils.notNull((Object)childResult));
            index.removeItem(entity);
            FilterNonSelectedVisitor.removePartsFromIndex(item, index);
        }
        return retval;
    }

    protected static void removePartsFromIndex(@NonNull IAssemblyNodeItem groupOrControlItem, @NonNull IIndexer index) {
        CHILD_PART_METAPATH.evaluate((IItem)groupOrControlItem).stream().map(item -> (IAssemblyNodeItem)item).forEachOrdered(partItem -> {
            IEntityItem entity;
            ControlPart part = (ControlPart)ObjectUtils.requireNonNull((Object)((ControlPart)partItem.getValue()));
            String id = part.getId();
            if (id != null && (entity = index.getEntity(IEntityItem.ItemType.PART, id)) != null) {
                index.removeItem(entity);
            }
        });
    }

    @Override
    protected DefaultResult visitParameter(IAssemblyNodeItem item, IAssemblyNodeItem parent, Context context) {
        Parameter param = (Parameter)ObjectUtils.requireNonNull((Object)((Parameter)item.getValue()));
        IIndexer index = context.getIndexer();
        IEntityItem entity = (IEntityItem)ObjectUtils.requireNonNull((Object)index.getEntity(IEntityItem.ItemType.PARAMETER, (String)ObjectUtils.requireNonNull((Object)param.getId()), false));
        DefaultResult retval = new DefaultResult();
        if (IIndexer.isReferencedEntity(entity)) {
            param.setId(entity.getIdentifier());
            index.setSelectionStatus((INodeItem)item, IIndexer.SelectionStatus.SELECTED);
            if (IIndexer.SelectionStatus.UNSELECTED.equals((Object)index.getSelectionStatus((INodeItem)parent))) {
                retval.promoteParameter(param);
            }
        } else {
            if (IIndexer.SelectionStatus.SELECTED.equals((Object)index.getSelectionStatus((INodeItem)parent))) {
                retval.removeParameter(param);
            }
            index.removeItem(entity);
        }
        return retval;
    }

    protected static final class Context {
        @NonNull
        private final IIndexer indexer;

        private Context(@NonNull IIndexer indexer) {
            this.indexer = indexer;
        }

        @NonNull
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="provides intentional access to index state")
        public IIndexer getIndexer() {
            return this.indexer;
        }
    }
}

