/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.IncludeAll;
import gov.nist.secauto.oscal.lib.model.ProfileImport;
import gov.nist.secauto.oscal.lib.model.ProfileSelectControlById;
import gov.nist.secauto.oscal.lib.model.control.catalog.IControl;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.DefaultControlSelectionFilter;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IControlSelectionFilter;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public interface IControlFilter {
    @NonNull
    public static final IControlFilter ALWAYS_MATCH = new IControlFilter(){

        @Override
        @NonNull
        public Pair<Boolean, Boolean> match(@NonNull IControl control, boolean defaultMatch) {
            return IControlSelectionFilter.MATCH;
        }

        @Override
        @NonNull
        public IControlSelectionFilter getInclusionFilter() {
            return IControlSelectionFilter.ALL_MATCH;
        }

        @Override
        @NonNull
        public IControlSelectionFilter getExclusionFilter() {
            return IControlSelectionFilter.NONE_MATCH;
        }
    };
    @NonNull
    public static final IControlFilter NONE_MATCH = new IControlFilter(){

        @Override
        @NonNull
        public Pair<Boolean, Boolean> match(@NonNull IControl control, boolean defaultMatch) {
            return IControlSelectionFilter.NON_MATCH;
        }

        @Override
        @NonNull
        public IControlSelectionFilter getInclusionFilter() {
            return IControlSelectionFilter.NONE_MATCH;
        }

        @Override
        @NonNull
        public IControlSelectionFilter getExclusionFilter() {
            return IControlSelectionFilter.NONE_MATCH;
        }
    };

    @NonNull
    public static IControlFilter newInstance(@NonNull ProfileImport profileImport) {
        return new Filter(profileImport);
    }

    @NonNull
    public static IControlFilter newInstance(@NonNull IControlSelectionFilter includes, @NonNull IControlSelectionFilter excludes) {
        return new Filter(includes, excludes);
    }

    @NonNull
    default public Pair<Boolean, Boolean> match(@NonNull IControl control) {
        return this.match(control, false);
    }

    @NonNull
    public Pair<Boolean, Boolean> match(@NonNull IControl var1, boolean var2);

    @NonNull
    public IControlSelectionFilter getInclusionFilter();

    @NonNull
    public IControlSelectionFilter getExclusionFilter();

    public static class Filter
    implements IControlFilter {
        @NonNull
        private final IControlSelectionFilter inclusionFilter;
        @NonNull
        private final IControlSelectionFilter exclusionFilter;

        public Filter(@NonNull ProfileImport profileImport) {
            List<ProfileSelectControlById> selections;
            IncludeAll includeAll = profileImport.getIncludeAll();
            this.inclusionFilter = includeAll == null ? ((selections = profileImport.getIncludeControls()) == null ? IControlSelectionFilter.NONE_MATCH : new DefaultControlSelectionFilter(selections)) : IControlSelectionFilter.ALL_MATCH;
            selections = profileImport.getExcludeControls();
            this.exclusionFilter = selections == null ? IControlSelectionFilter.NONE_MATCH : new DefaultControlSelectionFilter(selections);
        }

        public Filter(@NonNull IControlSelectionFilter includes, @NonNull IControlSelectionFilter excludes) {
            this.inclusionFilter = includes;
            this.exclusionFilter = excludes;
        }

        @Override
        @NonNull
        public IControlSelectionFilter getInclusionFilter() {
            return this.inclusionFilter;
        }

        @Override
        @NonNull
        public IControlSelectionFilter getExclusionFilter() {
            return this.exclusionFilter;
        }

        @Override
        public Pair<Boolean, Boolean> match(@NonNull IControl control, boolean defaultMatch) {
            Pair<Boolean, Boolean> result = this.getInclusionFilter().apply(control);
            boolean left = (Boolean)ObjectUtils.notNull((Object)((Boolean)result.getLeft()));
            if (left) {
                Pair<Boolean, Boolean> excluded = this.getExclusionFilter().apply(control);
                if (((Boolean)ObjectUtils.notNull((Object)((Boolean)excluded.getLeft()))).booleanValue()) {
                    result = IControlSelectionFilter.NON_MATCH;
                }
            } else {
                result = defaultMatch ? IControlSelectionFilter.MATCH : IControlSelectionFilter.NON_MATCH;
            }
            return result;
        }
    }
}

