/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.control.catalog.IControl;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public interface IControlSelectionFilter
extends Function<IControl, Pair<Boolean, Boolean>> {
    @NonNull
    public static final Pair<Boolean, Boolean> NON_MATCH = (Pair)ObjectUtils.notNull((Object)Pair.of((Object)false, (Object)false));
    @NonNull
    public static final Pair<Boolean, Boolean> MATCH = (Pair)ObjectUtils.notNull((Object)Pair.of((Object)true, (Object)true));
    @NonNull
    public static final IControlSelectionFilter ALL_MATCH = control -> MATCH;
    @NonNull
    public static final IControlSelectionFilter NONE_MATCH = control -> NON_MATCH;

    @NonNull
    public static IControlSelectionFilter matchIds(final String ... identifiers) {
        return new IControlSelectionFilter(){
            private final Set<String> keys;
            {
                this.keys = Arrays.stream(identifiers).collect(Collectors.toUnmodifiableSet());
            }

            @Override
            @NonNull
            public Pair<Boolean, Boolean> apply(IControl control) {
                return (Pair)ObjectUtils.notNull((Object)Pair.of((Object)this.keys.contains(control.getId()), (Object)false));
            }
        };
    }

    @Override
    @NonNull
    public Pair<Boolean, Boolean> apply(IControl var1);
}

