/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.selection;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.Catalog;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.model.ProfileImport;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionEvaluationException;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolutionException;
import gov.nist.secauto.oscal.lib.profile.resolver.policy.ReferenceCountingVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.ControlSelectionState;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.ControlSelectionVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.FilterNonSelectedVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.selection.IControlFilter;
import gov.nist.secauto.oscal.lib.profile.resolver.support.BasicIndexer;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Import {
    @NonNull
    private final IRootAssemblyNodeItem profile;
    @NonNull
    private final IAssemblyNodeItem profileImportItem;

    public Import(@NonNull IRootAssemblyNodeItem profile, @NonNull IAssemblyNodeItem profileImportItem) {
        this.profile = profile;
        this.profileImportItem = profileImportItem;
    }

    protected IRootAssemblyNodeItem getProfileItem() {
        return this.profile;
    }

    protected IAssemblyNodeItem getProfileImportItem() {
        return this.profileImportItem;
    }

    @NonNull
    protected ProfileImport getProfileImport() {
        return (ProfileImport)ObjectUtils.requireNonNull((Object)((ProfileImport)this.profileImportItem.getValue()));
    }

    private static Catalog toCatalog(@NonNull IDocumentNodeItem catalogDocument) {
        return (Catalog)INodeItem.toValue((INodeItem)catalogDocument);
    }

    @NonNull
    protected IControlFilter newControlFilter() {
        return IControlFilter.newInstance(this.getProfileImport());
    }

    @NonNull
    protected IIndexer newIndexer() {
        return new BasicIndexer();
    }

    @NonNull
    public IIndexer resolve(@NonNull IDocumentNodeItem importedCatalogDocument, @NonNull Catalog resolvedCatalog) throws ProfileResolutionException {
        ProfileImport profileImport = this.getProfileImport();
        URI uri = (URI)ObjectUtils.requireNonNull((Object)profileImport.getHref(), (String)"profile import href is null");
        IControlFilter filter = this.newControlFilter();
        IIndexer indexer = this.newIndexer();
        ControlSelectionState state = new ControlSelectionState(indexer, filter);
        try {
            ControlSelectionVisitor.instance().visitCatalog(importedCatalogDocument, state);
            ReferenceCountingVisitor.instance().visitCatalog(importedCatalogDocument, indexer, uri);
            FilterNonSelectedVisitor.instance().visitCatalog(importedCatalogDocument, indexer);
        }
        catch (ProfileResolutionEvaluationException ex) {
            throw new ProfileResolutionException(String.format("Import: Unable to resolve profile import '%s'. %s", uri.toString(), ex.getMessage()), ex);
        }
        Catalog importedCatalog = Import.toCatalog(importedCatalogDocument);
        for (Parameter param : CollectionUtil.listOrEmpty(importedCatalog.getParams())) {
            if (param == null) continue;
            resolvedCatalog.addParam(param);
        }
        for (Control control : CollectionUtil.listOrEmpty(importedCatalog.getControls())) {
            if (control == null) continue;
            resolvedCatalog.addControl(control);
        }
        for (CatalogGroup group : CollectionUtil.listOrEmpty(importedCatalog.getGroups())) {
            if (group == null) continue;
            resolvedCatalog.addGroup(group);
        }
        Import.generateMetadata(importedCatalogDocument, resolvedCatalog, indexer);
        Import.generateBackMatter(importedCatalogDocument, resolvedCatalog, indexer);
        return indexer;
    }

    private static void generateMetadata(@NonNull IDocumentNodeItem importedCatalogDocument, @NonNull Catalog resolvedCatalog, @NonNull IIndexer indexer) {
        Metadata importedMetadata = Import.toCatalog(importedCatalogDocument).getMetadata();
        if (importedMetadata != null) {
            Metadata resolvedMetadata = resolvedCatalog.getMetadata();
            if (resolvedMetadata == null) {
                resolvedMetadata = new Metadata();
                resolvedCatalog.setMetadata(resolvedMetadata);
            }
            Import.resolveMetadata(importedMetadata, resolvedMetadata, indexer);
        }
    }

    private static void resolveMetadata(@NonNull Metadata imported, @NonNull Metadata resolved, @NonNull IIndexer indexer) {
        Version resolvedCatalogVersion;
        Version importOscalVersion;
        String importedVersion = imported.getOscalVersion();
        if (importedVersion != null && (importOscalVersion = VersionUtil.parseVersion((String)importedVersion, null, null)).compareTo(resolvedCatalogVersion = VersionUtil.parseVersion((String)resolved.getOscalVersion(), null, null)) > 0) {
            resolved.setOscalVersion(importOscalVersion.toString());
        }
        resolved.setRoles(IIndexer.filterDistinct((Stream)ObjectUtils.notNull(CollectionUtil.listOrEmpty(resolved.getRoles()).stream()), indexer.getEntitiesByItemType(IEntityItem.ItemType.ROLE), Metadata.Role::getId).collect(Collectors.toCollection(LinkedList::new)));
        resolved.setParties(IIndexer.filterDistinct((Stream)ObjectUtils.notNull(CollectionUtil.listOrEmpty(resolved.getParties()).stream()), indexer.getEntitiesByItemType(IEntityItem.ItemType.PARTY), Metadata.Party::getUuid).collect(Collectors.toCollection(LinkedList::new)));
        resolved.setLocations(IIndexer.filterDistinct((Stream)ObjectUtils.notNull(CollectionUtil.listOrEmpty(resolved.getLocations()).stream()), indexer.getEntitiesByItemType(IEntityItem.ItemType.LOCATION), Metadata.Location::getUuid).collect(Collectors.toCollection(LinkedList::new)));
    }

    private static void generateBackMatter(@NonNull IDocumentNodeItem importedCatalogDocument, @NonNull Catalog resolvedCatalog, @NonNull IIndexer indexer) {
        BackMatter resolvedBackMatter;
        List resolvedResources;
        List resources;
        BackMatter importedBackMatter = Import.toCatalog(importedCatalogDocument).getBackMatter();
        if (importedBackMatter != null && !(resources = (List)IIndexer.filterDistinct((Stream)ObjectUtils.notNull((resolvedResources = (resolvedBackMatter = resolvedCatalog.getBackMatter()) == null ? CollectionUtil.emptyList() : CollectionUtil.listOrEmpty(resolvedBackMatter.getResources())).stream()), indexer.getEntitiesByItemType(IEntityItem.ItemType.RESOURCE), BackMatter.Resource::getUuid).collect(Collectors.toCollection(LinkedList::new))).isEmpty()) {
            if (resolvedBackMatter == null) {
                resolvedBackMatter = new BackMatter();
                resolvedCatalog.setBackMatter(resolvedBackMatter);
            }
            resolvedBackMatter.setResources(resources);
        }
    }
}

