/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.support;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IRootAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalBindingContext;
import gov.nist.secauto.oscal.lib.OscalModelConstants;
import gov.nist.secauto.oscal.lib.profile.resolver.support.AbstractCatalogVisitor;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public abstract class AbstractCatalogEntityVisitor<T, R>
extends AbstractCatalogVisitor<T, R> {
    @NonNull
    public static final MetapathExpression CHILD_PART_METAPATH = MetapathExpression.compile((String)"part|part//part", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final MetapathExpression BACK_MATTER_RESOURCES_METAPATH = MetapathExpression.compile((String)"back-matter/resource", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private static final Set<IEntityItem.ItemType> GROUP_CONTAINER_TYPES = (Set)ObjectUtils.notNull(EnumSet.of(IEntityItem.ItemType.GROUP, IEntityItem.ItemType.CONTROL, IEntityItem.ItemType.PARAMETER, IEntityItem.ItemType.PART));
    @NonNull
    private static final Set<IEntityItem.ItemType> CONTROL_CONTAINER_TYPES = (Set)ObjectUtils.notNull(EnumSet.of(IEntityItem.ItemType.CONTROL, IEntityItem.ItemType.PARAMETER, IEntityItem.ItemType.PART));
    @NonNull
    private final Set<IEntityItem.ItemType> itemTypesToVisit;

    public AbstractCatalogEntityVisitor(@NonNull Set<IEntityItem.ItemType> itemTypesToVisit) {
        this.itemTypesToVisit = CollectionUtil.unmodifiableSet(itemTypesToVisit);
    }

    public Set<IEntityItem.ItemType> getItemTypesToVisit() {
        return CollectionUtil.unmodifiableSet(this.itemTypesToVisit);
    }

    protected boolean isVisitedItemType(@NonNull IEntityItem.ItemType type) {
        return this.itemTypesToVisit.contains((Object)type);
    }

    @Override
    public R visitCatalog(IDocumentNodeItem catalogDocument, T state) {
        Object result = super.visitCatalog(catalogDocument, state);
        catalogDocument.modelItems().forEachOrdered(item -> {
            IRootAssemblyNodeItem root = (IRootAssemblyNodeItem)ObjectUtils.requireNonNull((Object)((IRootAssemblyNodeItem)item));
            this.visitMetadata(root, state);
            this.visitBackMatter(root, state);
        });
        return result;
    }

    @Override
    protected R visitGroupContainer(IAssemblyNodeItem catalogOrGroup, R initialResult, T state) {
        R retval = Collections.disjoint(this.getItemTypesToVisit(), GROUP_CONTAINER_TYPES) ? initialResult : super.visitGroupContainer(catalogOrGroup, initialResult, state);
        return retval;
    }

    @Override
    protected R visitControlContainer(IAssemblyNodeItem catalogOrGroupOrControl, R initialResult, T state) {
        Object retval;
        if (Collections.disjoint(this.getItemTypesToVisit(), CONTROL_CONTAINER_TYPES)) {
            retval = initialResult;
        } else {
            retval = super.visitControlContainer(catalogOrGroupOrControl, initialResult, state);
            if (this.isVisitedItemType(IEntityItem.ItemType.PARAMETER)) {
                retval = catalogOrGroupOrControl.getModelItemsByName(OscalModelConstants.QNAME_PARAM).stream().map(paramItem -> this.visitParameter((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)((IAssemblyNodeItem)paramItem)), catalogOrGroupOrControl, state)).reduce(retval, (first, second) -> this.aggregateResults(first, second, state));
            }
        }
        return retval;
    }

    protected void visitParts(@NonNull IAssemblyNodeItem groupOrControlItem, T state) {
        if (this.isVisitedItemType(IEntityItem.ItemType.PART)) {
            CHILD_PART_METAPATH.evaluate((IItem)groupOrControlItem).stream().map(item -> (IAssemblyNodeItem)item).forEachOrdered(partItem -> this.visitPart((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)partItem), groupOrControlItem, state));
        }
    }

    @Override
    protected R visitGroupInternal(@NonNull IAssemblyNodeItem item, R childResult, T state) {
        if (this.isVisitedItemType(IEntityItem.ItemType.PART)) {
            this.visitParts(item, state);
        }
        R retval = childResult;
        if (this.isVisitedItemType(IEntityItem.ItemType.GROUP)) {
            retval = this.visitGroup(item, retval, state);
        }
        return retval;
    }

    @Override
    protected R visitControlInternal(IAssemblyNodeItem item, R childResult, T state) {
        if (this.isVisitedItemType(IEntityItem.ItemType.PART)) {
            this.visitParts(item, state);
        }
        R retval = childResult;
        if (this.isVisitedItemType(IEntityItem.ItemType.CONTROL)) {
            retval = this.visitControl(item, retval, state);
        }
        return retval;
    }

    protected R visitParameter(@NonNull IAssemblyNodeItem item, @NonNull IAssemblyNodeItem catalogOrGroupOrControl, T state) {
        return this.newDefaultResult(state);
    }

    protected void visitPart(@NonNull IAssemblyNodeItem item, @NonNull IAssemblyNodeItem groupOrControl, T state) {
    }

    protected void visitMetadata(@NonNull IRootAssemblyNodeItem rootItem, T state) {
        rootItem.getModelItemsByName(OscalModelConstants.QNAME_METADATA).stream().map(metadataItem -> (IAssemblyNodeItem)metadataItem).forEach(metadataItem -> {
            if (this.isVisitedItemType(IEntityItem.ItemType.ROLE)) {
                metadataItem.getModelItemsByName(OscalModelConstants.QNAME_ROLE).stream().map(roleItem -> (IAssemblyNodeItem)roleItem).forEachOrdered(roleItem -> this.visitRole((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)roleItem), (IAssemblyNodeItem)metadataItem, state));
            }
            if (this.isVisitedItemType(IEntityItem.ItemType.LOCATION)) {
                metadataItem.getModelItemsByName(OscalModelConstants.QNAME_LOCATION).stream().map(locationItem -> (IAssemblyNodeItem)locationItem).forEachOrdered(locationItem -> this.visitLocation((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)locationItem), (IAssemblyNodeItem)metadataItem, state));
            }
            if (this.isVisitedItemType(IEntityItem.ItemType.PARTY)) {
                metadataItem.getModelItemsByName(OscalModelConstants.QNAME_PARTY).stream().map(partyItem -> (IAssemblyNodeItem)partyItem).forEachOrdered(partyItem -> this.visitParty((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)partyItem), (IAssemblyNodeItem)metadataItem, state));
            }
        });
    }

    protected void visitRole(@NonNull IAssemblyNodeItem item, @NonNull IAssemblyNodeItem metadataItem, T state) {
    }

    protected void visitLocation(@NonNull IAssemblyNodeItem item, @NonNull IAssemblyNodeItem metadataItem, T state) {
    }

    protected void visitParty(@NonNull IAssemblyNodeItem item, @NonNull IAssemblyNodeItem metadataItem, T state) {
    }

    protected void visitBackMatter(@NonNull IRootAssemblyNodeItem rootItem, T state) {
        if (this.isVisitedItemType(IEntityItem.ItemType.RESOURCE)) {
            BACK_MATTER_RESOURCES_METAPATH.evaluate((IItem)rootItem).stream().map(item -> (IAssemblyNodeItem)item).forEachOrdered(resourceItem -> this.visitResource((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)resourceItem), rootItem, state));
        }
    }

    protected void visitResource(@NonNull IAssemblyNodeItem resource, @NonNull IRootAssemblyNodeItem backMatter, T state) {
    }
}

