/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.support;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalModelConstants;
import gov.nist.secauto.oscal.lib.profile.resolver.support.ICatalogVisitor;

public abstract class AbstractCatalogVisitor<T, R>
implements ICatalogVisitor<T, R> {
    protected abstract R newDefaultResult(T var1);

    protected abstract R aggregateResults(R var1, R var2, T var3);

    protected R visitCatalog(@NonNull IDocumentNodeItem catalogDocument, T state) {
        return (R)catalogDocument.modelItems().reduce(this.newDefaultResult(state), (result, catalogOrGroup) -> this.visitGroupContainer((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)((IAssemblyNodeItem)catalogOrGroup)), result, state), (result1, result2) -> this.aggregateResults(result1, result2, state));
    }

    protected R visitGroupContainer(@NonNull IAssemblyNodeItem catalogOrGroup, R initialResult, T state) {
        Object result = catalogOrGroup.getModelItemsByName(OscalModelConstants.QNAME_GROUP).stream().map(groupItem -> this.visitGroupItem((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)((IAssemblyNodeItem)groupItem)), state)).reduce(initialResult, (first, second) -> this.aggregateResults(first, second, state));
        return (R)this.visitControlContainer(catalogOrGroup, result, state);
    }

    protected R visitGroupItem(@NonNull IAssemblyNodeItem group, T state) {
        R childResult = this.visitGroupContainer(group, this.newDefaultResult(state), state);
        return this.visitGroupInternal(group, childResult, state);
    }

    protected R visitGroupInternal(@NonNull IAssemblyNodeItem group, R childResult, T state) {
        return this.visitGroup(group, childResult, state);
    }

    protected R visitControlContainer(@NonNull IAssemblyNodeItem catalogOrGroupOrControl, R initialResult, T state) {
        return (R)catalogOrGroupOrControl.getModelItemsByName(OscalModelConstants.QNAME_CONTROL).stream().map(control -> this.visitControlItem((IAssemblyNodeItem)ObjectUtils.requireNonNull((Object)((IAssemblyNodeItem)control)), state)).reduce(initialResult, (first, second) -> this.aggregateResults(first, second, state));
    }

    protected R visitControlItem(@NonNull IAssemblyNodeItem control, T state) {
        R childResult = this.visitControlContainer(control, this.newDefaultResult(state), state);
        return this.visitControlInternal(control, childResult, state);
    }

    protected R visitControlInternal(@NonNull IAssemblyNodeItem control, R childResult, T state) {
        return this.visitControl(control, childResult, state);
    }
}

