/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.support;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import java.net.URI;

public abstract class AbstractEntityItem
implements IEntityItem {
    @NonNull
    private final String originalIdentifier;
    @NonNull
    private IModelNodeItem<?, ?> instance;
    @NonNull
    private final IEntityItem.ItemType itemType;
    @NonNull
    private final URI source;
    private int referenceCount;

    protected AbstractEntityItem(@NonNull Builder builder) {
        this.itemType = (IEntityItem.ItemType)((Object)ObjectUtils.requireNonNull((Object)((Object)builder.itemType), (String)"itemType"));
        this.originalIdentifier = (String)ObjectUtils.requireNonNull((Object)builder.originalIdentifier, (String)"originalIdentifier");
        this.instance = (IModelNodeItem)ObjectUtils.requireNonNull(builder.instance, (String)"instance");
        this.source = (URI)ObjectUtils.requireNonNull((Object)builder.source, (String)"source");
    }

    @Override
    @NonNull
    public String getOriginalIdentifier() {
        return this.originalIdentifier;
    }

    @Override
    @NonNull
    public abstract String getIdentifier();

    @Override
    @NonNull
    public IModelNodeItem<?, ?> getInstance() {
        return this.instance;
    }

    @Override
    public void setInstance(IModelNodeItem<?, ?> item) {
        this.instance = item;
    }

    @Override
    @NonNull
    public <T> T getInstanceValue() {
        return (T)ObjectUtils.notNull((Object)this.getInstance().getValue());
    }

    @Override
    @NonNull
    public IEntityItem.ItemType getItemType() {
        return this.itemType;
    }

    @Override
    @NonNull
    public URI getSource() {
        return this.source;
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Override
    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    @Override
    public int resetReferenceCount() {
        int retval = this.referenceCount;
        this.referenceCount = 0;
        return retval;
    }

    static final class Builder {
        private String originalIdentifier;
        private String reassignedIdentifier;
        private IModelNodeItem<?, ?> instance;
        private IEntityItem.ItemType itemType;
        private URI source;

        Builder() {
        }

        @NonNull
        public Builder instance(@NonNull IModelNodeItem<?, ?> item, @NonNull IEntityItem.ItemType itemType) {
            this.instance = item;
            this.itemType = itemType;
            return this;
        }

        @NonNull
        public Builder reassignedIdentifier(@NonNull String identifier) {
            this.reassignedIdentifier = identifier;
            return this;
        }

        @NonNull
        public Builder originalIdentifier(@NonNull String identifier) {
            this.originalIdentifier = identifier;
            return this;
        }

        @NonNull
        public Builder source(@NonNull URI source) {
            this.source = source;
            return this;
        }

        @NonNull
        public IEntityItem build() {
            return this.reassignedIdentifier == null ? new OriginalEntityItem(this) : new ReassignedEntityItem(this);
        }
    }

    static final class ReassignedEntityItem
    extends AbstractEntityItem {
        @NonNull
        private final String reassignedIdentifier;

        protected ReassignedEntityItem(@NonNull Builder builder) {
            super(builder);
            this.reassignedIdentifier = (String)ObjectUtils.requireNonNull((Object)builder.reassignedIdentifier);
        }

        @Override
        public String getIdentifier() {
            return this.reassignedIdentifier;
        }

        @Override
        public boolean isIdentifierReassigned() {
            return true;
        }
    }

    static final class OriginalEntityItem
    extends AbstractEntityItem {
        protected OriginalEntityItem(@NonNull Builder builder) {
            super(builder);
        }

        @Override
        public String getIdentifier() {
            return this.getOriginalIdentifier();
        }

        @Override
        public boolean isIdentifierReassigned() {
            return false;
        }
    }
}

