/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.support;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalBindingContext;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.CatalogGroup;
import gov.nist.secauto.oscal.lib.model.Control;
import gov.nist.secauto.oscal.lib.model.ControlPart;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.Parameter;
import gov.nist.secauto.oscal.lib.profile.resolver.ProfileResolver;
import gov.nist.secauto.oscal.lib.profile.resolver.support.AbstractEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IIndexer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicIndexer
implements IIndexer {
    private static final Logger LOGGER = LogManager.getLogger(ProfileResolver.class);
    private static final MetapathExpression CONTAINER_METAPATH = MetapathExpression.compile((String)"(ancestor::control|ancestor::group)[1])", (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
    @NonNull
    private final Map<IEntityItem.ItemType, Map<String, IEntityItem>> entityTypeToIdentifierToEntityMap;
    @NonNull
    private Map<INodeItem, IIndexer.SelectionStatus> nodeItemToSelectionStatusMap;

    @Override
    public void append(@NonNull IIndexer other) {
        for (IEntityItem.ItemType itemType : IEntityItem.ItemType.values()) {
            assert (itemType != null);
            for (IEntityItem entity : other.getEntitiesByItemType(itemType)) {
                assert (entity != null);
                this.addItem(entity);
            }
        }
        this.nodeItemToSelectionStatusMap.putAll(other.getSelectionStatusMap());
    }

    public BasicIndexer() {
        this.entityTypeToIdentifierToEntityMap = new EnumMap<IEntityItem.ItemType, Map<String, IEntityItem>>(IEntityItem.ItemType.class);
        this.nodeItemToSelectionStatusMap = new ConcurrentHashMap<INodeItem, IIndexer.SelectionStatus>();
    }

    public BasicIndexer(IIndexer other) {
        this.entityTypeToIdentifierToEntityMap = other.getEntities();
        this.nodeItemToSelectionStatusMap = new ConcurrentHashMap<INodeItem, IIndexer.SelectionStatus>(other.getSelectionStatusMap());
    }

    @Override
    public void setSelectionStatus(@NonNull INodeItem item, @NonNull IIndexer.SelectionStatus selectionStatus) {
        this.nodeItemToSelectionStatusMap.put(item, selectionStatus);
    }

    @Override
    public Map<INodeItem, IIndexer.SelectionStatus> getSelectionStatusMap() {
        return CollectionUtil.unmodifiableMap(this.nodeItemToSelectionStatusMap);
    }

    @Override
    public IIndexer.SelectionStatus getSelectionStatus(@NonNull INodeItem item) {
        IIndexer.SelectionStatus retval = this.nodeItemToSelectionStatusMap.get(item);
        return retval == null ? IIndexer.SelectionStatus.UNKNOWN : retval;
    }

    @Override
    public void resetSelectionStatus() {
        this.nodeItemToSelectionStatusMap = new ConcurrentHashMap<INodeItem, IIndexer.SelectionStatus>();
    }

    @Override
    public boolean isSelected(@NonNull IEntityItem entity) {
        boolean retval;
        switch (entity.getItemType()) {
            case CONTROL: 
            case GROUP: {
                retval = IIndexer.SelectionStatus.SELECTED.equals((Object)this.getSelectionStatus((INodeItem)entity.getInstance()));
                break;
            }
            case PART: {
                IModelNodeItem<?, ?> instance = entity.getInstance();
                IIndexer.SelectionStatus status = this.getSelectionStatus((INodeItem)instance);
                if (IIndexer.SelectionStatus.UNKNOWN.equals((Object)status)) {
                    IModelNodeItem containerItem = (IModelNodeItem)CONTAINER_METAPATH.evaluateAs(instance, MetapathExpression.ResultType.ITEM);
                    assert (containerItem != null);
                    status = this.getSelectionStatus((INodeItem)containerItem);
                    this.setSelectionStatus((INodeItem)instance, status);
                }
                retval = IIndexer.SelectionStatus.SELECTED.equals((Object)status);
                break;
            }
            case PARAMETER: 
            case LOCATION: 
            case PARTY: 
            case RESOURCE: 
            case ROLE: {
                retval = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException(entity.getItemType().name());
            }
        }
        return retval;
    }

    @Override
    public Map<IEntityItem.ItemType, Map<String, IEntityItem>> getEntities() {
        Map copy = this.entityTypeToIdentifierToEntityMap.entrySet().stream().map(entry -> {
            IEntityItem.ItemType key = (IEntityItem.ItemType)((Object)((Object)entry.getKey()));
            Map oldMap = (Map)entry.getValue();
            Map newMap = oldMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (key1, key2) -> key1, LinkedHashMap::new));
            assert (newMap != null);
            return Map.entry(key, Collections.synchronizedMap(newMap));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (key1, key2) -> key1, ConcurrentHashMap::new));
        assert (copy != null);
        return copy;
    }

    @Override
    @NonNull
    public Collection<IEntityItem> getEntitiesByItemType(@NonNull IEntityItem.ItemType itemType) {
        Map<String, IEntityItem> entityGroup = this.entityTypeToIdentifierToEntityMap.get((Object)itemType);
        return entityGroup == null ? CollectionUtil.emptyList() : (Collection)ObjectUtils.notNull(entityGroup.values());
    }

    @Override
    public IEntityItem getEntity(@NonNull IEntityItem.ItemType itemType, @NonNull String identifier, boolean normalize) {
        Map<String, IEntityItem> entityGroup = this.entityTypeToIdentifierToEntityMap.get((Object)itemType);
        String normalizedIdentifier = normalize ? this.normalizeIdentifier(identifier) : identifier;
        return entityGroup == null ? null : entityGroup.get(normalizedIdentifier);
    }

    protected IEntityItem addItem(@NonNull IEntityItem item) {
        IEntityItem.ItemType type = item.getItemType();
        Map entityGroup = this.entityTypeToIdentifierToEntityMap.computeIfAbsent(type, key -> Collections.synchronizedMap(new LinkedHashMap()));
        IEntityItem oldEntity = entityGroup.put(item.getIdentifier(), item);
        if (oldEntity != null && LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().log("Duplicate {} found with identifier {} in index.", (Object)oldEntity.getItemType().name().toLowerCase(Locale.ROOT), (Object)oldEntity.getIdentifier());
        }
        return oldEntity;
    }

    @NonNull
    protected IEntityItem addItem(@NonNull AbstractEntityItem.Builder builder) {
        IEntityItem retval = builder.build();
        this.addItem(retval);
        return retval;
    }

    @Override
    public boolean removeItem(@NonNull IEntityItem entity) {
        IEntityItem.ItemType type = entity.getItemType();
        Map<String, IEntityItem> entityGroup = this.entityTypeToIdentifierToEntityMap.get((Object)type);
        boolean retval = false;
        if (entityGroup != null) {
            retval = entityGroup.remove(entity.getIdentifier(), entity);
            this.nodeItemToSelectionStatusMap.remove(entity.getInstance());
            if (retval) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().log("Removing {} '{}' from index.", (Object)type.name(), (Object)entity.getIdentifier());
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("The {} entity '{}' was not found in the index to remove.", (Object)type.name(), (Object)entity.getIdentifier());
            }
        }
        return retval;
    }

    @Override
    public IEntityItem addRole(IModelNodeItem<?, ?> item) {
        Metadata.Role role = (Metadata.Role)ObjectUtils.requireNonNull((Object)((Metadata.Role)item.getValue()));
        String identifier = (String)ObjectUtils.requireNonNull((Object)role.getId());
        return this.addItem(this.newBuilder(item, IEntityItem.ItemType.ROLE, identifier));
    }

    @Override
    public IEntityItem addLocation(IModelNodeItem<?, ?> item) {
        Metadata.Location location = (Metadata.Location)ObjectUtils.requireNonNull((Object)((Metadata.Location)item.getValue()));
        UUID identifier = (UUID)ObjectUtils.requireNonNull((Object)location.getUuid());
        return this.addItem(this.newBuilder(item, IEntityItem.ItemType.LOCATION, identifier));
    }

    @Override
    public IEntityItem addParty(IModelNodeItem<?, ?> item) {
        Metadata.Party party = (Metadata.Party)ObjectUtils.requireNonNull((Object)((Metadata.Party)item.getValue()));
        UUID identifier = (UUID)ObjectUtils.requireNonNull((Object)party.getUuid());
        return this.addItem(this.newBuilder(item, IEntityItem.ItemType.PARTY, identifier));
    }

    @Override
    public IEntityItem addGroup(IModelNodeItem<?, ?> item) {
        CatalogGroup group = (CatalogGroup)ObjectUtils.requireNonNull((Object)((CatalogGroup)item.getValue()));
        String identifier = group.getId();
        return identifier == null ? null : this.addItem(this.newBuilder(item, IEntityItem.ItemType.GROUP, identifier));
    }

    @Override
    public IEntityItem addControl(IModelNodeItem<?, ?> item) {
        Control control = (Control)ObjectUtils.requireNonNull((Object)((Control)item.getValue()));
        String identifier = (String)ObjectUtils.requireNonNull((Object)control.getId());
        return this.addItem(this.newBuilder(item, IEntityItem.ItemType.CONTROL, identifier));
    }

    @Override
    public IEntityItem addParameter(IModelNodeItem<?, ?> item) {
        Parameter parameter = (Parameter)ObjectUtils.requireNonNull((Object)((Parameter)item.getValue()));
        String identifier = (String)ObjectUtils.requireNonNull((Object)parameter.getId());
        return this.addItem(this.newBuilder(item, IEntityItem.ItemType.PARAMETER, identifier));
    }

    @Override
    public IEntityItem addPart(IModelNodeItem<?, ?> item) {
        ControlPart part = (ControlPart)ObjectUtils.requireNonNull((Object)((ControlPart)item.getValue()));
        String identifier = part.getId();
        return identifier == null ? null : this.addItem(this.newBuilder(item, IEntityItem.ItemType.PART, identifier));
    }

    @Override
    public IEntityItem addResource(IModelNodeItem<?, ?> item) {
        BackMatter.Resource resource = (BackMatter.Resource)ObjectUtils.requireNonNull((Object)((BackMatter.Resource)item.getValue()));
        UUID identifier = (UUID)ObjectUtils.requireNonNull((Object)resource.getUuid());
        return this.addItem(this.newBuilder(item, IEntityItem.ItemType.RESOURCE, identifier));
    }

    @NonNull
    protected final AbstractEntityItem.Builder newBuilder(@NonNull IModelNodeItem<?, ?> item, @NonNull IEntityItem.ItemType itemType, @NonNull UUID identifier) {
        return this.newBuilder(item, itemType, (String)ObjectUtils.notNull((Object)identifier.toString()));
    }

    @NonNull
    protected AbstractEntityItem.Builder newBuilder(@NonNull IModelNodeItem<?, ?> item, @NonNull IEntityItem.ItemType itemType, @NonNull String identifier) {
        return new AbstractEntityItem.Builder().instance(item, itemType).originalIdentifier(identifier).source((URI)ObjectUtils.requireNonNull((Object)item.getBaseUri(), (String)"item must have an associated URI"));
    }

    @NonNull
    public String normalizeIdentifier(@NonNull String identifier) {
        return UuidAdapter.UUID_PATTERN.matcher(identifier).matches() ? (String)ObjectUtils.notNull((Object)identifier.toLowerCase(Locale.ROOT)) : identifier;
    }
}

