/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.support;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;

public interface IIdentifierMapper {
    @NonNull
    public static final IIdentifierMapper IDENTITY = new IIdentifierMapper(){

        @Override
        public String mapRoleIdentifier(@NonNull String identifier) {
            return identifier;
        }

        @Override
        public String mapControlIdentifier(@NonNull String identifier) {
            return identifier;
        }

        @Override
        public String mapGroupIdentifier(@NonNull String identifier) {
            return identifier;
        }

        @Override
        public String mapParameterIdentifier(@NonNull String identifier) {
            return identifier;
        }

        @Override
        @NonNull
        public String mapPartIdentifier(@NonNull String identifier) {
            return identifier;
        }
    };

    @NonNull
    public String mapRoleIdentifier(@NonNull String var1);

    @NonNull
    public String mapControlIdentifier(@NonNull String var1);

    @NonNull
    public String mapGroupIdentifier(@NonNull String var1);

    @NonNull
    public String mapParameterIdentifier(@NonNull String var1);

    @NonNull
    public String mapPartIdentifier(@NonNull String var1);

    @NonNull
    default public String mapByItemType(@NonNull IEntityItem.ItemType itemType, @NonNull String identifier) {
        String retval;
        switch (itemType) {
            case CONTROL: {
                retval = this.mapControlIdentifier(identifier);
                break;
            }
            case GROUP: {
                retval = this.mapGroupIdentifier(identifier);
                break;
            }
            case PARAMETER: {
                retval = this.mapParameterIdentifier(identifier);
                break;
            }
            case PART: {
                retval = this.mapPartIdentifier(identifier);
                break;
            }
            case ROLE: {
                retval = this.mapRoleIdentifier(identifier);
                break;
            }
            case LOCATION: 
            case PARTY: 
            case RESOURCE: {
                retval = identifier;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported item type: " + itemType.name());
            }
        }
        return retval;
    }
}

