/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.profile.resolver.support;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModelNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItem;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.OscalBindingContext;
import gov.nist.secauto.oscal.lib.model.metadata.IProperty;
import gov.nist.secauto.oscal.lib.profile.resolver.support.IEntityItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IIndexer {
    public static final MetapathExpression HAS_PROP_KEEP_METAPATH;
    public static final Predicate<IEntityItem> KEEP_ENTITY_PREDICATE;

    public static boolean isReferencedEntity(@NonNull IEntityItem entity) {
        return KEEP_ENTITY_PREDICATE.test(entity);
    }

    public static Stream<IEntityItem> getReferencedEntitiesAsStream(@NonNull Collection<IEntityItem> entities) {
        return entities.stream().filter(KEEP_ENTITY_PREDICATE);
    }

    public static Stream<IEntityItem> getUnreferencedEntitiesAsStream(@NonNull Collection<IEntityItem> entities) {
        return entities.stream().filter(KEEP_ENTITY_PREDICATE.negate());
    }

    public static <T, K> Stream<T> filterDistinct(@NonNull Stream<T> resolvedItems, @NonNull Collection<IEntityItem> importedEntityItems, @NonNull Function<? super T, ? extends K> keyMapper) {
        Stream<Object> importedStream = IIndexer.getReferencedEntitiesAsStream(importedEntityItems).map(entity -> entity.getInstanceValue());
        return CustomCollectors.distinctByKey((Stream)((Stream)ObjectUtils.notNull(Stream.concat(resolvedItems, importedStream))), keyMapper, (key, value1, value2) -> value2);
    }

    public static void logIndex(@NonNull IIndexer indexer, @NonNull Level logLevel) {
        Logger logger = LogManager.getLogger();
        HashSet indexedItems = new HashSet();
        if (logger.isEnabled(logLevel)) {
            for (IEntityItem.ItemType itemType : IEntityItem.ItemType.values()) {
                if (!1.$assertionsDisabled && itemType == null) {
                    throw new AssertionError();
                }
                for (IEntityItem item : indexer.getEntitiesByItemType(itemType)) {
                    IModelNodeItem<?, ?> nodeItem = item.getInstance();
                    indexedItems.add(nodeItem);
                    logger.atLevel(logLevel).log("{} {}: selected: {}, reference count: {}", (Object)itemType.name(), item.isIdentifierReassigned() ? item.getIdentifier() + "(" + item.getOriginalIdentifier() + ")" : item.getIdentifier(), (Object)indexer.getSelectionStatus((INodeItem)nodeItem), (Object)item.getReferenceCount());
                }
            }
        }
        for (Map.Entry entry : indexer.getSelectionStatusMap().entrySet()) {
            INodeItem nodeItem = (INodeItem)entry.getKey();
            if (indexedItems.contains(nodeItem)) continue;
            Object value = nodeItem.getValue();
            logger.atLevel(logLevel).log("{}: {}", (Object)(value == null ? "(null)" : value.getClass().getName()), entry.getValue());
        }
    }

    @NonNull
    public IEntityItem addRole(@NonNull IModelNodeItem<?, ?> var1);

    @NonNull
    public IEntityItem addLocation(@NonNull IModelNodeItem<?, ?> var1);

    @NonNull
    public IEntityItem addParty(@NonNull IModelNodeItem<?, ?> var1);

    @Nullable
    public IEntityItem addGroup(@NonNull IModelNodeItem<?, ?> var1);

    @NonNull
    public IEntityItem addControl(@NonNull IModelNodeItem<?, ?> var1);

    @NonNull
    public IEntityItem addParameter(@NonNull IModelNodeItem<?, ?> var1);

    @Nullable
    public IEntityItem addPart(@NonNull IModelNodeItem<?, ?> var1);

    @NonNull
    public IEntityItem addResource(@NonNull IModelNodeItem<?, ?> var1);

    @NonNull
    public Collection<IEntityItem> getEntitiesByItemType(@NonNull IEntityItem.ItemType var1);

    @Nullable
    default public IEntityItem getEntity(@NonNull IEntityItem.ItemType itemType, @NonNull UUID identifier) {
        return this.getEntity(itemType, (String)ObjectUtils.notNull((Object)identifier.toString()), false);
    }

    @Nullable
    default public IEntityItem getEntity(@NonNull IEntityItem.ItemType itemType, @NonNull String identifier) {
        return this.getEntity(itemType, identifier, itemType.isUuid());
    }

    @Nullable
    public IEntityItem getEntity(@NonNull IEntityItem.ItemType var1, @NonNull String var2, boolean var3);

    public boolean removeItem(@NonNull IEntityItem var1);

    public boolean isSelected(@NonNull IEntityItem var1);

    public Map<INodeItem, SelectionStatus> getSelectionStatusMap();

    @NonNull
    public SelectionStatus getSelectionStatus(@NonNull INodeItem var1);

    public void setSelectionStatus(@NonNull INodeItem var1, @NonNull SelectionStatus var2);

    public void resetSelectionStatus();

    public void append(@NonNull IIndexer var1);

    @NonNull
    public Map<IEntityItem.ItemType, Map<String, IEntityItem>> getEntities();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        HAS_PROP_KEEP_METAPATH = MetapathExpression.compile((String)("prop[@name='keep' and has-oscal-namespace('" + IProperty.OSCAL_NAMESPACE + "')]/@value = 'always'"), (StaticContext)OscalBindingContext.OSCAL_STATIC_METAPATH_CONTEXT);
        KEEP_ENTITY_PREDICATE = entity -> entity.getReferenceCount() > 0 || (Boolean)ObjectUtils.notNull((Object)HAS_PROP_KEEP_METAPATH.evaluateAs(entity.getInstance(), MetapathExpression.ResultType.BOOLEAN)) != false;
    }

    public static enum SelectionStatus {
        SELECTED,
        UNSELECTED,
        UNKNOWN;

    }
}

