/*
 * Decompiled with CFR 0.152.
 */
package dev.migwel.icyreader;

import dev.migwel.icyreader.Metadata;
import dev.migwel.icyreader.SongInfo;
import dev.migwel.icyreader.Sources;
import dev.migwel.icyreader.parser.IcyStreamTitleParser;
import dev.migwel.icyreader.parser.StreamTitleArtistFirstParser;
import dev.migwel.icyreader.retriever.HttpIcyStreamRetriever;
import dev.migwel.icyreader.retriever.IcyStream;
import dev.migwel.icyreader.retriever.IcyStreamRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class IcyReader {
    private static final Logger log = LogManager.getLogger(IcyReader.class);
    public static final int WAIT_PRE_ROLL = 10000;
    private final IcyStreamRetriever streamRetriever;
    private final IcyStreamTitleParser streamTitleParser;
    private final String streamUrl;

    public IcyReader(IcyStreamRetriever streamRetriever, IcyStreamTitleParser streamTitleParser, String streamUrl) {
        this.streamRetriever = streamRetriever;
        this.streamTitleParser = streamTitleParser;
        this.streamUrl = streamUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public SongInfo currentlyPlaying() {
        try (IcyStream icyStream = this.streamRetriever.retrieve(this.streamUrl);){
            if (icyStream == null) {
                log.info("Stream could not be retrieved");
                SongInfo songInfo = null;
                return songInfo;
            }
            List<Metadata> metadata = this.getMetaData(icyStream);
            return this.getSongInfo(metadata);
        }
        catch (IOException e) {
            log.warn("Could not close input stream", (Throwable)e);
            return null;
        }
    }

    private List<Metadata> getMetaData(IcyStream icyStream) {
        List<Metadata> metadata;
        int metadataOffset = this.getMetadataOffset(icyStream.getIcyMetaInt());
        long startMs = System.currentTimeMillis();
        do {
            try {
                metadata = this.extractMetadata(icyStream.getStream(), metadataOffset);
            }
            catch (IOException e) {
                log.warn("Could not get metadata", (Throwable)e);
                return Collections.emptyList();
            }
        } while ((metadata.isEmpty() || this.containsPreroll(metadata)) && System.currentTimeMillis() - startMs <= 10000L);
        return metadata;
    }

    private boolean containsPreroll(List<Metadata> metadata) {
        return metadata.stream().anyMatch(e -> "insertionType".equals(e.getKey()) && "preroll".equals(e.getValue()));
    }

    private int getMetadataOffset(String icyMetaInt) {
        if ("".equals(icyMetaInt)) {
            return 0;
        }
        icyMetaInt = icyMetaInt.replace("[", "");
        icyMetaInt = icyMetaInt.replace("]", "");
        return Integer.parseInt(icyMetaInt);
    }

    @CheckForNull
    private SongInfo getSongInfo(List<Metadata> metadata) {
        Metadata streamTitle = metadata.stream().filter(e -> "StreamTitle".equals(e.getKey())).findFirst().orElse(null);
        if (streamTitle == null) {
            return null;
        }
        return this.streamTitleParser.parse(streamTitle.getValue());
    }

    @Nonnull
    private List<Metadata> extractMetadata(InputStream stream, int metadataOffset) throws IOException {
        stream.skipNBytes(metadataOffset);
        int metaDataLength = stream.read() * 16;
        if (metaDataLength == 0) {
            return Collections.emptyList();
        }
        String metadataStr = this.getMetadataStr(stream, metaDataLength);
        return Arrays.stream(metadataStr.split(";")).map(e -> e.split("=", 2)).filter(e -> ((String[])e).length == 2).map(e -> new Metadata(e[0], e[1].substring(1, e[1].length() - 1))).collect(Collectors.toList());
    }

    @Nonnull
    private String getMetadataStr(InputStream stream, int metaDataLength) throws IOException {
        byte[] b = new byte[metaDataLength];
        if (stream.read(b, 0, metaDataLength) != metaDataLength) {
            throw new IOException("Could not read " + metaDataLength + " bytes from stream");
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    @ParametersAreNonnullByDefault
    public static class IcyReaderBuilder {
        private IcyStreamRetriever streamRetriever;
        private IcyStreamTitleParser icyStreamTitleParser;
        private final String streamUrl;

        public IcyReaderBuilder(String streamUrl) {
            this.streamUrl = streamUrl;
        }

        public IcyReaderBuilder(Sources sources) {
            this.streamUrl = sources.getUrl();
            this.icyStreamTitleParser = sources.getStreamTitleParser();
        }

        public IcyReaderBuilder withRetriever(IcyStreamRetriever streamRetriever) {
            this.streamRetriever = streamRetriever;
            return this;
        }

        public IcyReaderBuilder withIcyStreamTitleParser(IcyStreamTitleParser icyStreamTitleParser) {
            this.icyStreamTitleParser = icyStreamTitleParser;
            return this;
        }

        public IcyReader build() {
            if (this.streamRetriever == null) {
                this.streamRetriever = new HttpIcyStreamRetriever();
            }
            if (this.icyStreamTitleParser == null) {
                this.icyStreamTitleParser = new StreamTitleArtistFirstParser();
            }
            return new IcyReader(this.streamRetriever, this.icyStreamTitleParser, this.streamUrl);
        }
    }
}

