/*
 * Decompiled with CFR 0.152.
 */
package dev.migwel.icyreader.retriever;

import dev.migwel.icyreader.retriever.HttpIcyStream;
import dev.migwel.icyreader.retriever.IcyStream;
import dev.migwel.icyreader.retriever.IcyStreamRetriever;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpIcyStreamRetriever
implements IcyStreamRetriever {
    private static final Logger log = LogManager.getLogger(HttpIcyStreamRetriever.class);
    private final CloseableHttpClient httpClient;

    public HttpIcyStreamRetriever() {
        this(HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("relaxed").build()).build());
    }

    public HttpIcyStreamRetriever(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public IcyStream retrieve(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Icy-MetaData", (Object)"1");
        httpGet.addHeader("Connection", (Object)"close");
        httpGet.addHeader("Accept", (Object)"");
        try {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpGet);
            if (response.getCode() != 200) {
                log.warn("Could not fetch stream. Status line: " + response.getCode());
                return null;
            }
            String icyMetaInt = this.retrieveIcyMetaInt((HttpResponse)response);
            return new HttpIcyStream(response.getEntity().getContent(), icyMetaInt, (ClassicHttpResponse)response);
        }
        catch (IOException e) {
            log.warn("An exception occurred while fetching the stream", (Throwable)e);
            return null;
        }
    }

    private String retrieveIcyMetaInt(HttpResponse response) {
        Header icyMetaIntHeader = response.getFirstHeader("icy-metaint");
        return icyMetaIntHeader.getValue();
    }
}

