/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.client.PreparedExecuteMessage;
import java.util.Arrays;

final class Binding {
    private final ParameterValue[] values;

    Binding(int length) {
        this.values = new ParameterValue[length];
    }

    void add(int index, ParameterValue value) {
        if (index < 0 || index >= this.values.length) {
            throw new IndexOutOfBoundsException("index must not be a negative integer and less than " + this.values.length);
        }
        this.values[index] = value;
    }

    PreparedExecuteMessage toMessage(int statementId, boolean immediate) {
        ParameterValue[] values = new ParameterValue[this.values.length];
        System.arraycopy(this.values, 0, values, 0, this.values.length);
        Arrays.fill(this.values, null);
        return new PreparedExecuteMessage(statementId, immediate, values);
    }

    void clear() {
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            if (this.values[i] == null) continue;
            this.values[i].dispose();
            this.values[i] = null;
        }
    }

    int findUnbind() {
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            if (this.values[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)o;
        return Arrays.equals(this.values, binding.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return String.format("Binding{values=%s}", Arrays.toString(this.values));
    }
}

