/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.constant.ZeroDateOption;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import java.time.Duration;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class MySqlConnectionConfiguration {
    private static final int DEFAULT_PORT = 3306;
    private final boolean isHost;
    private final String domain;
    private final int port;
    private final MySqlSslConfiguration ssl;
    @Nullable
    private final Duration connectTimeout;
    private final ZeroDateOption zeroDateOption;
    private final String username;
    @Nullable
    private final CharSequence password;
    private final String database;

    private MySqlConnectionConfiguration(boolean isHost, String domain, int port, @Nullable MySqlSslConfiguration ssl, @Nullable Duration connectTimeout, ZeroDateOption zeroDateOption, String username, @Nullable CharSequence password, @Nullable String database) {
        this.isHost = isHost;
        this.domain = domain;
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.ssl = AssertUtils.requireNonNull(ssl, "ssl must not be null");
        this.zeroDateOption = AssertUtils.requireNonNull(zeroDateOption, "zeroDateOption must not be null");
        this.username = AssertUtils.requireNonNull(username, "username must not be null");
        this.password = password;
        this.database = database == null || database.isEmpty() ? "" : database;
    }

    public static Builder builder() {
        return new Builder();
    }

    boolean isHost() {
        return this.isHost;
    }

    String getDomain() {
        return this.domain;
    }

    int getPort() {
        return this.port;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    MySqlSslConfiguration getSsl() {
        return this.ssl;
    }

    ZeroDateOption getZeroDateOption() {
        return this.zeroDateOption;
    }

    String getUsername() {
        return this.username;
    }

    @Nullable
    CharSequence getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlConnectionConfiguration)) {
            return false;
        }
        MySqlConnectionConfiguration that = (MySqlConnectionConfiguration)o;
        return this.isHost == that.isHost && this.domain.equals(that.domain) && this.port == that.port && this.ssl.equals(that.ssl) && Objects.equals(this.connectTimeout, that.connectTimeout) && this.zeroDateOption == that.zeroDateOption && this.username.equals(that.username) && Objects.equals(this.password, that.password) && this.database.equals(that.database);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isHost, this.domain, this.port, this.ssl, this.connectTimeout, this.zeroDateOption, this.username, this.password, this.database});
    }

    public String toString() {
        if (this.isHost) {
            return String.format("MySqlConnectionConfiguration{host=%s, port=%d, ssl=%s, connectTimeout=%s, zeroDateOption=%s, username='%s', password=REDACTED, database='%s'}", new Object[]{this.domain, this.port, this.ssl, this.connectTimeout, this.zeroDateOption, this.username, this.database});
        }
        return String.format("MySqlConnectionConfiguration{unixSocket=%s, connectTimeout=%s, zeroDateOption=%s, username='%s', password=REDACTED, database='%s'}", new Object[]{this.domain, this.connectTimeout, this.zeroDateOption, this.username, this.database});
    }

    public static final class Builder {
        @Nullable
        private String database;
        private boolean isHost = true;
        private String domain;
        @Nullable
        private CharSequence password;
        private int port = 3306;
        @Nullable
        private Duration connectTimeout;
        private String username;
        private ZeroDateOption zeroDateOption = ZeroDateOption.USE_NULL;
        @Nullable
        private SslMode sslMode;
        private String[] tlsVersion = InternalArrays.EMPTY_STRINGS;
        @Nullable
        private String sslCa;
        @Nullable
        private String sslKey;
        @Nullable
        private CharSequence sslKeyPassword;
        @Nullable
        private String sslCert;

        private Builder() {
        }

        public MySqlConnectionConfiguration build() {
            SslMode sslMode = this.requireSslMode();
            if (this.isHost) {
                AssertUtils.requireNonNull(this.domain, "host must not be null when using TCP socket");
                AssertUtils.require(this.port >= 0 && this.port <= 65535, "port must be between 0 and 65535 when using TCP socket");
            } else {
                AssertUtils.requireNonNull(this.domain, "unixSocket must not be null when using unix domain socket");
                AssertUtils.require(!sslMode.startSsl(), "sslMode must be disabled when using unix domain socket");
            }
            MySqlSslConfiguration ssl = MySqlSslConfiguration.create(sslMode, this.tlsVersion, this.sslCa, this.sslKey, this.sslKeyPassword, this.sslCert);
            return new MySqlConnectionConfiguration(this.isHost, this.domain, this.port, ssl, this.connectTimeout, this.zeroDateOption, this.username, this.password, this.database);
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder unixSocket(String unixSocket) {
            this.domain = AssertUtils.requireNonNull(unixSocket, "unixSocket must not be null");
            this.isHost = false;
            return this;
        }

        public Builder host(String host) {
            this.domain = AssertUtils.requireNonNull(host, "host must not be null");
            this.isHost = true;
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            AssertUtils.require(port >= 0 && port <= 65535, "port must be between 0 and 65535");
            this.port = port;
            return this;
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder username(String username) {
            this.username = AssertUtils.requireNonNull(username, "username must not be null");
            return this;
        }

        public Builder zeroDateOption(ZeroDateOption zeroDate) {
            this.zeroDateOption = AssertUtils.requireNonNull(zeroDate, "zeroDateOption must not be null");
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = AssertUtils.requireNonNull(sslMode, "sslMode must not be null");
            return this;
        }

        public Builder tlsVersion(String ... tlsVersion) {
            AssertUtils.requireNonNull(tlsVersion, "tlsVersion must not be null");
            int size = tlsVersion.length;
            if (size > 0) {
                String[] versions = new String[size];
                System.arraycopy(tlsVersion, 0, versions, 0, size);
                this.tlsVersion = versions;
            } else {
                this.tlsVersion = InternalArrays.EMPTY_STRINGS;
            }
            return this;
        }

        public Builder sslCa(@Nullable String sslCa) {
            this.sslCa = sslCa;
            return this;
        }

        public Builder sslKeyAndCert(@Nullable String sslCert, @Nullable String sslKey) {
            return this.sslKeyAndCert(sslCert, sslKey, null);
        }

        public Builder sslKeyAndCert(@Nullable String sslCert, @Nullable String sslKey, @Nullable CharSequence sslKeyPassword) {
            AssertUtils.require(sslCert == null && sslKey == null || sslCert != null && sslKey != null, "SSL key and cert must be both null or both non-null");
            this.sslCert = sslCert;
            this.sslKey = sslKey;
            this.sslKeyPassword = sslKeyPassword;
            return this;
        }

        private SslMode requireSslMode() {
            SslMode sslMode = this.sslMode;
            if (sslMode == null) {
                sslMode = this.isHost ? SslMode.PREFERRED : SslMode.DISABLED;
            }
            return sslMode;
        }
    }
}

