/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.LoginFlow;
import dev.miku.r2dbc.mysql.MySqlConnection;
import dev.miku.r2dbc.mysql.MySqlConnectionConfiguration;
import dev.miku.r2dbc.mysql.MySqlConnectionFactoryMetadata;
import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactor.core.publisher.Mono;

public final class MySqlConnectionFactory
implements ConnectionFactory {
    private final Mono<MySqlConnection> client;

    private MySqlConnectionFactory(Mono<MySqlConnection> client) {
        this.client = client;
    }

    public Mono<MySqlConnection> create() {
        return this.client;
    }

    public ConnectionFactoryMetadata getMetadata() {
        return MySqlConnectionFactoryMetadata.INSTANCE;
    }

    public static MySqlConnectionFactory from(MySqlConnectionConfiguration configuration) {
        AssertUtils.requireNonNull(configuration, "configuration must not be null");
        return new MySqlConnectionFactory((Mono<MySqlConnection>)Mono.defer(() -> {
            Object address;
            MySqlSslConfiguration ssl;
            if (configuration.isHost()) {
                ssl = configuration.getSsl();
                address = InetSocketAddress.createUnresolved(configuration.getDomain(), configuration.getPort());
            } else {
                ssl = MySqlSslConfiguration.disabled();
                address = new DomainSocketAddress(configuration.getDomain());
            }
            String database = configuration.getDatabase();
            String username = configuration.getUsername();
            CharSequence password = configuration.getPassword();
            SslMode sslMode = ssl.getSslMode();
            ConnectionContext context = new ConnectionContext(configuration.getZeroDateOption());
            return Client.connect((SocketAddress)address, ssl, context, configuration.getConnectTimeout()).flatMap(client -> LoginFlow.login(client, sslMode, database, context, username, password)).flatMap(client -> MySqlConnection.create(client, context));
        }));
    }
}

