/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.MySqlRowMetadata;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import io.r2dbc.spi.Row;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import reactor.util.annotation.Nullable;

public final class MySqlRow
implements Row {
    private final FieldValue[] fields;
    private final MySqlRowMetadata rowMetadata;
    private final Codecs codecs;
    private final boolean binary;
    private final ConnectionContext context;

    MySqlRow(FieldValue[] fields, MySqlRowMetadata rowMetadata, Codecs codecs, boolean binary, ConnectionContext context) {
        this.fields = AssertUtils.requireNonNull(fields, "fields must not be null");
        this.rowMetadata = AssertUtils.requireNonNull(rowMetadata, "rowMetadata must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.binary = binary;
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
    }

    public <T> T get(int index, Class<T> type) {
        return this.get0(index, type);
    }

    public <T> T get(String name, Class<T> type) {
        return this.get0(name, type);
    }

    @Nullable
    public <T> T get(int index, ParameterizedType type) {
        return this.get0(index, (Type)type);
    }

    @Nullable
    public <T> T get(String name, ParameterizedType type) {
        return this.get0(name, (Type)type);
    }

    @Nullable
    private <T> T get0(int index, Type type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnMetadata info = this.rowMetadata.getColumnMetadata(index);
        return this.codecs.decode(this.fields[index], info, type, this.binary, this.context);
    }

    @Nullable
    private <T> T get0(String name, Type type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnMetadata info = this.rowMetadata.getColumnMetadata(name);
        return this.codecs.decode(this.fields[info.getIndex()], info, type, this.binary, this.context);
    }
}

