/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.MySqlStatement;
import dev.miku.r2dbc.mysql.MySqlStatementSupport;
import dev.miku.r2dbc.mysql.Query;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.ConnectionContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ParametrizedMySqlStatement
extends MySqlStatementSupport {
    private final Client client;
    private final Codecs codecs;
    private final ConnectionContext context;
    private final Query query;
    private final Bindings bindings;
    private final boolean deprecateEof;
    private final AtomicBoolean executed = new AtomicBoolean();
    private int fetchSize = 0;

    ParametrizedMySqlStatement(Client client, Codecs codecs, ConnectionContext context, Query query, boolean deprecateEof) {
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.query = AssertUtils.requireNonNull(query, "sql must not be null");
        this.deprecateEof = deprecateEof;
        this.bindings = new Bindings(this.query.getParameters());
    }

    @Override
    public MySqlStatement add() {
        this.assertNotExecuted();
        this.bindings.validatedFinish();
        return this;
    }

    @Override
    public MySqlStatement bind(int index, Object value) {
        AssertUtils.requireNonNull(value, "value must not be null");
        this.addBinding(index, this.codecs.encode(value, this.context));
        return this;
    }

    @Override
    public MySqlStatement bind(String name, Object value) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(value, "value must not be null");
        Object indexes = this.query.getIndexes(name);
        if (indexes instanceof Integer) {
            this.addBinding((Integer)indexes, this.codecs.encode(value, this.context));
        } else {
            this.addBinding((Query.Indexes)indexes, this.codecs.encode(value, this.context));
        }
        return this;
    }

    @Override
    public MySqlStatement bindNull(int index, Class<?> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        this.addBinding(index, this.codecs.encodeNull());
        return this;
    }

    @Override
    public MySqlStatement bindNull(String name, Class<?> type) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        Object indexes = this.query.getIndexes(name);
        if (indexes instanceof Integer) {
            this.addBinding((Integer)indexes, this.codecs.encodeNull());
        } else {
            this.addBinding((Query.Indexes)indexes, this.codecs.encodeNull());
        }
        return this;
    }

    public Flux<MySqlResult> execute() {
        if (this.bindings.bindings.isEmpty()) {
            throw new IllegalStateException("No parameters bound for current statement");
        }
        this.bindings.validatedFinish();
        return Flux.defer(() -> {
            if (!this.executed.compareAndSet(false, true)) {
                return Flux.error((Throwable)new IllegalStateException("Statement was already executed"));
            }
            int fetchSize = this.fetchSize;
            String sql = this.query.getSql();
            return QueryFlow.prepare(this.client, sql).doOnCancel(() -> this.bindings.clear()).flatMapMany(it -> QueryFlow.execute(this.client, this.context, sql, it, this.deprecateEof, fetchSize, this.bindings.bindings).map(messages -> new MySqlResult(true, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages)).onErrorResume(e -> it.close().then(Mono.error((Throwable)e))).concatWith((Publisher)it.close().then(Mono.empty())).doOnCancel(() -> it.close().subscribe()));
        });
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }

    private void addBinding(int index, ParameterValue value) {
        this.assertNotExecuted();
        this.bindings.getCurrent().add(index, value);
    }

    private void addBinding(Query.Indexes indexes, ParameterValue value) {
        this.assertNotExecuted();
        indexes.bind(this.bindings.getCurrent(), value);
    }

    private void assertNotExecuted() {
        if (this.executed.get()) {
            throw new IllegalStateException("Statement was already executed");
        }
    }

    private static final class Bindings
    implements Iterable<Binding> {
        private final List<Binding> bindings = new ArrayList<Binding>();
        private final int paramCount;
        private Binding current;

        private Bindings(int paramCount) {
            this.paramCount = paramCount;
        }

        private void clear() {
            for (Binding binding : this.bindings) {
                binding.clear();
            }
            this.bindings.clear();
        }

        @Override
        public Iterator<Binding> iterator() {
            return this.bindings.iterator();
        }

        @Override
        public void forEach(Consumer<? super Binding> action) {
            this.bindings.forEach(action);
        }

        @Override
        public Spliterator<Binding> spliterator() {
            return this.bindings.spliterator();
        }

        private void validatedFinish() {
            Binding current = this.current;
            if (current == null) {
                return;
            }
            int unbind = current.findUnbind();
            if (unbind >= 0) {
                String message = String.format("Parameter %d has no binding", unbind);
                throw new IllegalStateException(message);
            }
            this.current = null;
        }

        private Binding getCurrent() {
            Binding current = this.current;
            if (current == null) {
                this.current = current = new Binding(this.paramCount);
                this.bindings.add(current);
            }
            return current;
        }
    }
}

