/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.message.ParameterValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class Query {
    private final String sql;
    private final Map<String, Object> nameKeyedIndex;
    private final int parameters;

    private Query(String sql, Map<String, Object> nameKeyedIndex, int parameters) {
        this.sql = sql;
        this.nameKeyedIndex = nameKeyedIndex;
        this.parameters = parameters;
    }

    String getSql() {
        return this.sql;
    }

    Object getIndexes(String identifier) {
        Object index = this.nameKeyedIndex.get(identifier);
        if (index == null) {
            throw new IllegalArgumentException(String.format("No such parameter with identifier '%s'", identifier));
        }
        return index;
    }

    Set<String> getParameterNames() {
        return this.nameKeyedIndex.keySet();
    }

    int getParameters() {
        return this.parameters;
    }

    boolean isPrepared() {
        return this.parameters > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query that = (Query)o;
        if (this.parameters != that.parameters) {
            return false;
        }
        if (!this.sql.equals(that.sql)) {
            return false;
        }
        return this.nameKeyedIndex.equals(that.nameKeyedIndex);
    }

    public int hashCode() {
        int result = this.sql.hashCode();
        result = 31 * result + this.nameKeyedIndex.hashCode();
        result = 31 * result + this.parameters;
        return result;
    }

    public String toString() {
        if (!this.isPrepared()) {
            return "Query{sql=REDACTED}";
        }
        return String.format("Query{sql=REDACTED, parameters=%d, nameKeyedIndex=%s", this.parameters, this.nameKeyedIndex);
    }

    static Query parse(String sql) {
        int offset = Query.findParamMark(sql, 0);
        if (offset < 0) {
            return new Query(sql, Collections.emptyMap(), 0);
        }
        HashMap<String, Object> nameKeyedParams = new HashMap<String, Object>();
        StringBuilder sqlBuilder = null;
        int lastEnd = 0;
        String anyName = null;
        int length = sql.length();
        int paramCount = 0;
        while (offset >= 0 && offset < length) {
            char now;
            ++paramCount;
            if (++offset < length && Character.isJavaIdentifierStart(now = sql.charAt(offset))) {
                int start = offset++;
                while (offset < length && Character.isJavaIdentifierPart(sql.charAt(offset))) {
                    ++offset;
                }
                if (sqlBuilder == null) {
                    sqlBuilder = new StringBuilder(sql.length() - offset + start);
                }
                sqlBuilder.append(sql, lastEnd, start);
                lastEnd = offset;
                String name = sql.substring(start, offset);
                int paramIndex = paramCount - 1;
                Object value = nameKeyedParams.get(name);
                anyName = name;
                if (value == null) {
                    nameKeyedParams.put(name, paramIndex);
                } else if (value instanceof Integer) {
                    nameKeyedParams.put(name, new Indexes((Integer)value, paramIndex));
                } else {
                    ((Indexes)value).push(paramIndex);
                }
            }
            if (offset >= length) continue;
            offset = Query.findParamMark(sql, offset);
        }
        String parsedSql = sqlBuilder == null ? sql : (lastEnd < length ? sqlBuilder.append(sql, lastEnd, length).toString() : sqlBuilder.toString());
        switch (nameKeyedParams.size()) {
            case 0: {
                return new Query(parsedSql, Collections.emptyMap(), paramCount);
            }
            case 1: {
                return new Query(parsedSql, Collections.singletonMap(anyName, nameKeyedParams.get(anyName)), paramCount);
            }
        }
        return new Query(parsedSql, nameKeyedParams, paramCount);
    }

    private static int findParamMark(CharSequence sql, int offset) {
        int length = sql.length();
        block5: while (offset < length && offset >= 0) {
            char ch = sql.charAt(offset++);
            switch (ch) {
                case '/': {
                    if (offset == length || sql.charAt(offset) != '*') continue block5;
                    while (++offset < length) {
                        if (sql.charAt(offset) != '*' || offset + 1 >= length || sql.charAt(offset + 1) != '/') continue;
                        offset += 2;
                        continue block5;
                    }
                    continue block5;
                }
                case '-': {
                    if (offset == length || sql.charAt(offset) != '-') continue block5;
                    while (++offset < length) {
                        char now = sql.charAt(offset);
                        if (now != '\n' && now != '\r') continue;
                        ++offset;
                        continue block5;
                    }
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    while (offset < length) {
                        if (sql.charAt(offset++) != ch) continue;
                        if (length == offset || sql.charAt(offset) != ch) continue block5;
                        ++offset;
                    }
                    continue block5;
                }
            }
            if (ch != '?') continue;
            return offset - 1;
        }
        return -1;
    }

    static final class Indexes {
        private static final int INIT_CAPACITY = 8;
        private int size = 2;
        private int[] data;

        private Indexes(int first, int second) {
            int[] data = new int[8];
            data[0] = first;
            data[1] = second;
            this.data = data;
        }

        private void push(int another) {
            int i;
            if ((i = this.size++) >= this.data.length) {
                int[] newData = new int[this.data.length << 1];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
            this.data[i] = another;
        }

        void bind(Binding binding, ParameterValue value) {
            for (int i = 0; i < this.size; ++i) {
                binding.add(this.data[i], value);
            }
        }

        int[] toIntArray() {
            return Arrays.copyOf(this.data, this.size);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Indexes)) {
                return false;
            }
            Indexes indexes = (Indexes)o;
            if (this.size != indexes.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] == indexes.data[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.size; ++i) {
                result = 31 * result + this.data[i];
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append('[').append(this.data[0]);
            for (int i = 1; i < this.size; ++i) {
                builder.append(", ").append(this.data[i]);
            }
            return builder.append(']').toString();
        }
    }
}

